/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.commands;

import com.perforce.team.core.mergequest.model.Branch;
import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.core.mergequest.model.IBranchGraphElement;
import com.perforce.team.core.mergequest.model.Mapping;
import com.perforce.team.ui.mergequest.actions.MappingCreateAction;
import com.perforce.team.ui.mergequest.commands.Messages;
import org.eclipse.gef.commands.Command;

public class MappingCreateCommand
extends Command {
    private IBranchGraph graph;
    private Branch source;
    private Branch target;
    private Mapping created;
    private Object type;
    private int sourceTerminal = 0;
    private int targetTerminal = 0;

    public MappingCreateCommand(IBranchGraph graph, Object type) {
        this.graph = graph;
        this.type = type;
        this.setLabel(Messages.MappingCreateCommand_DefaultLabel);
    }

    public void setSourceTerminal(int terminal) {
        this.sourceTerminal = terminal;
    }

    public void setTargetTerminal(int terminal) {
        this.targetTerminal = terminal;
    }

    public void setSource(Branch source) {
        this.source = source;
    }

    public void setTarget(Branch target) {
        this.target = target;
    }

    public boolean canExecute() {
        if (this.graph != null) {
            if (this.source != null && this.target != null) {
                return !this.source.equals((Object)this.target);
            }
            return true;
        }
        return false;
    }

    public void execute() {
        if (this.graph != null) {
            MappingCreateAction create = new MappingCreateAction(this.graph, this.type);
            create.setInitialSource(this.source);
            create.setInitialTarget(this.target);
            create.setSourceTerminal(this.sourceTerminal);
            create.setTargetTerminal(this.targetTerminal);
            create.run();
            this.created = create.getLastCreated();
        }
    }

    public boolean canUndo() {
        return this.graph != null && this.created != null;
    }

    public void undo() {
        if (this.created != null && this.graph != null) {
            this.created.disconnect();
            this.graph.remove((IBranchGraphElement)this.created);
        }
    }

    public void redo() {
        if (this.created != null && this.graph != null && this.graph.add((IBranchGraphElement)this.created)) {
            this.created.connect();
        }
    }
}

