/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.commands;

import com.perforce.team.core.mergequest.model.Branch;
import com.perforce.team.ui.mergequest.commands.Messages;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class BranchConstraintCommand
extends Command {
    private Branch branch;
    private ChangeBoundsRequest request;
    private Rectangle bounds;
    private Rectangle previousBounds;

    public BranchConstraintCommand(Branch branch, ChangeBoundsRequest request, Rectangle constraint) {
        this.branch = branch;
        this.request = request;
        this.bounds = constraint.getCopy();
        this.setLabel(Messages.BranchConstraintCommand_DefaultLabel);
    }

    public boolean canExecute() {
        Object type = this.request.getType();
        return "move".equals(type) || "move children".equals(type) || "resize".equals(type) || "resize children".equals(type);
    }

    public void execute() {
        this.previousBounds = new Rectangle(this.branch.getX(), this.branch.getY(), this.branch.getWidth(), this.branch.getHeight());
        this.branch.setLocation(this.bounds.x, this.bounds.y);
        this.branch.setSize(this.bounds.width, this.bounds.height);
    }

    public void undo() {
        this.branch.setLocation(this.previousBounds.x, this.previousBounds.y);
        this.branch.setSize(this.previousBounds.width, this.previousBounds.height);
    }
}

