/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.actions;

import com.perforce.team.core.mergequest.model.Branch;
import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.core.mergequest.model.IBranchGraphElement;
import com.perforce.team.core.mergequest.model.Mapping;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.mergequest.wizards.branch.BranchDescriptor;
import com.perforce.team.ui.mergequest.wizards.mapping.NewMappingWizard;
import com.perforce.team.ui.mergequest.wizards.mapping.branch.BranchMappingWizard;
import com.perforce.team.ui.mergequest.wizards.mapping.depot.DepotPathMappingWizard;
import java.awt.Point;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;

public class MappingCreateAction
extends Action {
    public static final int STARTING_X = 100;
    public static final int STARTING_Y = 100;
    public static final int BRANCH_BUFFER = 200;
    private IBranchGraph graph;
    private Object type;
    private Branch source;
    private Branch target;
    private int sourceTerminal = 0;
    private int targetTerminal = 0;
    private Mapping lastCreated = null;

    public MappingCreateAction(IBranchGraph graph, Object type) {
        this.graph = graph;
        this.type = type;
    }

    public Mapping getLastCreated() {
        return this.lastCreated;
    }

    public void setSourceTerminal(int terminal) {
        this.sourceTerminal = terminal;
    }

    public void setTargetTerminal(int terminal) {
        this.targetTerminal = terminal;
    }

    public void setInitialSource(Branch source) {
        this.source = source;
    }

    public void setInitialTarget(Branch target) {
        this.target = target;
    }

    public void run() {
        NewMappingWizard wizard = null;
        if ("branchSpec".equals(this.type)) {
            wizard = new BranchMappingWizard(this.graph);
        } else if ("depotPath".equals(this.type)) {
            wizard = new DepotPathMappingWizard(this.graph);
        }
        if (wizard != null) {
            wizard.setInitialSource(this.source);
            wizard.setInitialTarget(this.target);
            WizardDialog dialog = new WizardDialog(P4UIUtils.getDialogShell(), (IWizard)wizard);
            if (dialog.open() == 0) {
                Mapping created = wizard.getMapping();
                Branch sourceBranch = wizard.getSourceSelection();
                Branch targetBranch = wizard.getTargetSelection();
                Point sourceLocation = null;
                Point targetLocation = null;
                if (sourceBranch == null && targetBranch == null) {
                    sourceLocation = this.graph.findEmptyLocation(new Point(100, 100), 200);
                    targetLocation = this.graph.findEmptyLocation(new Point(sourceLocation.x + 200, sourceLocation.y), 200);
                } else if (sourceBranch == null && targetBranch != null) {
                    sourceLocation = this.graph.findEmptyLocation(new Point(targetBranch.getX(), targetBranch.getY()), 200);
                } else if (sourceBranch != null && targetBranch == null) {
                    targetLocation = this.graph.findEmptyLocation(new Point(sourceBranch.getX(), sourceBranch.getY()), 200);
                }
                if (sourceBranch == null) {
                    sourceBranch = this.graph.createBranch(null);
                    BranchDescriptor sourceDescriptor = wizard.getSourceDescriptor();
                    sourceBranch.setName(sourceDescriptor.getName());
                    sourceBranch.setType(sourceDescriptor.getType().getType());
                    sourceBranch.setLocation(sourceLocation.x, sourceLocation.y);
                    this.graph.add((IBranchGraphElement)sourceBranch);
                }
                if (targetBranch == null) {
                    targetBranch = this.graph.createBranch(null);
                    BranchDescriptor targetDescriptor = wizard.getTargetDescriptor();
                    targetBranch.setName(targetDescriptor.getName());
                    targetBranch.setType(targetDescriptor.getType().getType());
                    targetBranch.setLocation(targetLocation.x, targetLocation.y);
                    this.graph.add((IBranchGraphElement)targetBranch);
                }
                if (this.graph.add((IBranchGraphElement)created)) {
                    created.setSourceAnchor(this.sourceTerminal);
                    created.setTargetAnchor(this.targetTerminal);
                    created.connect(sourceBranch, targetBranch);
                    this.lastCreated = created;
                }
            }
        }
    }
}

