/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.mergequest.model;

import com.perforce.team.core.mergequest.model.BranchGraphElement;
import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.core.mergequest.model.IMappingVisitor;
import com.perforce.team.core.mergequest.model.Mapping;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Branch
extends BranchGraphElement {
    public static final String LOCATION = "location";
    public static final String SIZE = "size";
    public static final String TYPE = "type";
    public static final String SOURCE_MAPPINGS = "sourceMappings";
    public static final String TARGET_MAPPINGS = "targetMappings";
    private Map<String, Mapping> sourceMappings = new HashMap<String, Mapping>();
    private Map<String, Mapping> targetMappings = new HashMap<String, Mapping>();
    private String type = "";
    private int x = -1;
    private int y = -1;
    private int width = -1;
    private int height = -1;

    public Branch(String id) {
        this(id, (IBranchGraph)null);
    }

    public Branch(String id, IBranchGraph graph) {
        super(id, graph);
    }

    public boolean add(Mapping mapping) {
        boolean added = false;
        if (mapping != null) {
            if (this.equals(mapping.getSource())) {
                this.sourceMappings.put(mapping.getId(), mapping);
                added = true;
                this.changeSupport.firePropertyChange(SOURCE_MAPPINGS, null, mapping);
            } else if (this.equals(mapping.getTarget())) {
                this.targetMappings.put(mapping.getId(), mapping);
                added = true;
                this.changeSupport.firePropertyChange(TARGET_MAPPINGS, null, mapping);
            }
        }
        return added;
    }

    public boolean remove(Mapping mapping) {
        boolean removed = false;
        if (mapping != null) {
            if (this.equals(mapping.getSource())) {
                boolean bl = removed = this.sourceMappings.remove(mapping.getId()) != null;
                if (removed) {
                    this.changeSupport.firePropertyChange(SOURCE_MAPPINGS, mapping, null);
                }
            } else if (this.equals(mapping.getTarget())) {
                boolean bl = removed = this.targetMappings.remove(mapping.getId()) != null;
                if (removed) {
                    this.changeSupport.firePropertyChange(TARGET_MAPPINGS, mapping, null);
                }
            }
        }
        return removed;
    }

    public Mapping[] getSourceMappings() {
        return this.sourceMappings.values().toArray(new Mapping[this.sourceMappings.size()]);
    }

    public Mapping getSourceMapping(String id) {
        Mapping mapping = null;
        if (id != null) {
            mapping = this.sourceMappings.get(id);
        }
        return mapping;
    }

    public Mapping getSourceMappingByName(String name) {
        Mapping mapping = null;
        if (name != null) {
            Mapping[] mappingArray = this.getSourceMappings();
            int n = mappingArray.length;
            int n2 = 0;
            while (n2 < n) {
                Mapping candidate = mappingArray[n2];
                if (name.equals(candidate.getName())) {
                    mapping = candidate;
                    break;
                }
                ++n2;
            }
        }
        return mapping;
    }

    public Mapping getTargetMappingByName(String name) {
        Mapping mapping = null;
        if (name != null) {
            Mapping[] mappingArray = this.getTargetMappings();
            int n = mappingArray.length;
            int n2 = 0;
            while (n2 < n) {
                Mapping candidate = mappingArray[n2];
                if (name.equals(candidate.getName())) {
                    mapping = candidate;
                    break;
                }
                ++n2;
            }
        }
        return mapping;
    }

    public Mapping getTargetMapping(String id) {
        Mapping mapping = null;
        if (id != null) {
            mapping = this.targetMappings.get(id);
        }
        return mapping;
    }

    public Mapping[] getTargetMappings() {
        return this.targetMappings.values().toArray(new Mapping[this.targetMappings.size()]);
    }

    public Mapping[] getSourceOwnedTargetMappings() {
        ArrayList<Mapping> mappings = new ArrayList<Mapping>();
        for (Mapping mapping : this.targetMappings.values()) {
            Mapping sourceOwned = mapping.getSource().getSourceMapping(mapping.getId());
            if (sourceOwned == null) continue;
            mappings.add(sourceOwned);
        }
        return mappings.toArray(new Mapping[mappings.size()]);
    }

    public Mapping[] getAllMappings() {
        Mapping[] targets;
        Mapping[] sources = this.getSourceMappings();
        Mapping[] combined = new Mapping[sources.length + (targets = this.getTargetMappings()).length];
        if (combined.length > 0) {
            System.arraycopy(sources, 0, combined, 0, sources.length);
            System.arraycopy(targets, 0, combined, sources.length, targets.length);
        }
        return combined;
    }

    public int getMappingCount() {
        return this.sourceMappings.size() + this.targetMappings.size();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (type != null && !type.equals(this.type)) {
            String previous = this.type;
            this.type = type;
            this.changeSupport.firePropertyChange(TYPE, previous, type);
        }
    }

    public int getX() {
        return this.x;
    }

    public void setLocation(int x, int y) {
        boolean change = false;
        int previousX = this.x;
        int previousY = this.y;
        if (x != this.x) {
            this.x = x;
            change = true;
        }
        if (y != this.y) {
            this.y = y;
            change = true;
        }
        if (change) {
            this.changeSupport.firePropertyChange(LOCATION, new Point(previousX, previousY), new Point(this.x, this.y));
        }
    }

    public void setSize(int width, int height) {
        if (width <= 0) {
            width = -1;
        }
        if (height <= 0) {
            height = -1;
        }
        boolean change = false;
        int previousWidth = this.width;
        int previousHeight = this.height;
        if (width != this.width) {
            this.width = width;
            change = true;
        }
        if (height != this.height) {
            this.height = height;
            change = true;
        }
        if (change) {
            this.changeSupport.firePropertyChange(SIZE, new Rectangle(previousWidth, previousHeight), new Rectangle(this.width, this.height));
        }
    }

    public int getY() {
        return this.y;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Branch && super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public void disconnect() {
        Mapping mapping;
        Mapping[] mappingArray = this.getSourceMappings();
        int n = mappingArray.length;
        int n2 = 0;
        while (n2 < n) {
            mapping = mappingArray[n2];
            mapping.disconnect();
            ++n2;
        }
        mappingArray = this.getTargetMappings();
        n = mappingArray.length;
        n2 = 0;
        while (n2 < n) {
            mapping = mappingArray[n2];
            mapping.disconnect();
            ++n2;
        }
    }

    public void accept(IMappingVisitor visitor, String type, boolean source, boolean target) {
        block12: {
            if (visitor == null) break block12;
            Mapping[] mappings = null;
            if (source && target) {
                mappings = this.getAllMappings();
            } else if (source) {
                mappings = this.getSourceMappings();
            } else if (target) {
                mappings = this.getTargetMappings();
            }
            if (mappings != null && mappings.length > 0) {
                if (type != null) {
                    Mapping[] mappingArray = mappings;
                    int n = mappings.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Mapping mapping = mappingArray[n2];
                        if (!type.equals(mapping.getType()) || visitor.visit(mapping, this)) {
                            ++n2;
                            continue;
                        }
                        break;
                    }
                } else {
                    Mapping[] mappingArray = mappings;
                    int n = mappings.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Mapping mapping = mappingArray[n3];
                        if (visitor.visit(mapping, this)) {
                            ++n3;
                            continue;
                        }
                        break;
                    }
                }
            }
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean containsPoint(Point point) {
        if (point == null) {
            return false;
        }
        if (this.width != -1 ? point.x < this.x || point.x > this.x + this.width : point.x != this.x) {
            return false;
        }
        return !(this.height != -1 ? point.y < this.y || point.y > this.y + this.height : point.y != this.y);
    }
}

