/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.mergequest.builder.xml;

import com.perforce.team.core.mergequest.builder.xml.IElementBuilder;
import com.perforce.team.core.mergequest.builder.xml.MappingBuilder;
import com.perforce.team.core.mergequest.model.DepotPathMapping;
import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.core.mergequest.model.IBranchGraphElement;
import org.w3c.dom.Element;

public class DepotPathMappingBuilder
extends MappingBuilder
implements IElementBuilder {
    public static final String DEPOT_PATH_MAPPING_ELEMENT = "depotPathMapping";
    public static final String TARGET_PATH_ATTRIBUTE = "targetPath";
    public static final String SOURCE_PATH_ATTRIBUTE = "sourcePath";

    @Override
    public IBranchGraphElement initialize(Element element, IBranchGraph graph) {
        DepotPathMapping mapping = null;
        String id = element.getAttribute("id");
        if (id.length() > 0) {
            mapping = graph.createDepotPathMapping(id);
            this.loadMappingFields(element, mapping);
            mapping.setSourcePath(element.getAttribute(SOURCE_PATH_ATTRIBUTE));
            mapping.setTargetPath(element.getAttribute(TARGET_PATH_ATTRIBUTE));
            graph.add(mapping);
        }
        return mapping;
    }

    @Override
    public void save(Element parent, IBranchGraphElement element) {
        if (element instanceof DepotPathMapping) {
            DepotPathMapping mapping = (DepotPathMapping)element;
            Element mappingElement = parent.getOwnerDocument().createElement(DEPOT_PATH_MAPPING_ELEMENT);
            this.saveMappingFields(mappingElement, mapping);
            mappingElement.setAttribute(SOURCE_PATH_ATTRIBUTE, mapping.getSourcePath());
            mappingElement.setAttribute(TARGET_PATH_ATTRIBUTE, mapping.getTargetPath());
            parent.appendChild(mappingElement);
        }
    }
}

