/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.search.query;

import com.perforce.p4java.option.server.MatchingLinesOptions;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;

public class QueryOptions {
    private boolean allRevisions = false;
    private Set<String> paths;
    private String pattern;
    private boolean caseInsensitive = false;
    private boolean searchBinaries = false;
    private int leadingContext = -1;
    private int trailingContext = -1;

    public QueryOptions(String pattern) {
        Assert.isNotNull((Object)pattern, (String)"Pattern cannot be null");
        this.pattern = pattern;
        this.paths = new HashSet<String>();
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        if (pattern != null) {
            this.pattern = pattern;
        }
    }

    public void addPaths(String[] paths) {
        if (paths != null) {
            String[] stringArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                this.addPath(path);
                ++n2;
            }
        }
    }

    public void addPath(String path) {
        if (path != null) {
            this.paths.add(path);
        }
    }

    public MatchingLinesOptions createOptions() {
        MatchingLinesOptions options = new MatchingLinesOptions();
        options.setIncludeLineNumbers(true);
        options.setAllRevisions(this.allRevisions);
        options.setCaseInsensitive(this.caseInsensitive);
        options.setSearchBinaries(this.searchBinaries);
        options.setLeadingContext(this.leadingContext);
        options.setTrailingContext(this.trailingContext);
        return options;
    }

    public String[] getPaths() {
        return this.paths.toArray(new String[this.paths.size()]);
    }

    public boolean isAllRevisions() {
        return this.allRevisions;
    }

    public void setAllRevisions(boolean allRevisions) {
        this.allRevisions = allRevisions;
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    public void setSearchBinaries(boolean searchBinaries) {
        this.searchBinaries = searchBinaries;
    }

    public boolean isSearchBinaries() {
        return this.searchBinaries;
    }

    public int getLeadingContext() {
        return this.leadingContext;
    }

    public void setLeadingContext(int leadingContext) {
        this.leadingContext = leadingContext;
    }

    public int getTrailingContext() {
        return this.trailingContext;
    }

    public void setTrailingContext(int trailingContext) {
        this.trailingContext = trailingContext;
    }
}

