/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mylyn.search;

import com.perforce.team.core.mylyn.P4MylynUtils;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.ui.IErrorDisplay;
import com.perforce.team.ui.IErrorProvider;
import com.perforce.team.ui.mylyn.search.FilterEntry;
import com.perforce.team.ui.mylyn.search.FilterManager;
import com.perforce.team.ui.mylyn.search.IFilterListener;
import com.perforce.team.ui.mylyn.search.Messages;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositoryQueryPage;
import org.eclipse.mylyn.tasks.ui.wizards.ITaskSearchPageContainer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class P4JobQueryPage
extends AbstractRepositoryQueryPage
implements IErrorDisplay {
    private Text queryTitleText;
    private Button manualButton;
    private Button buildableButton;
    private Button limitButton;
    private Spinner limitSpinner;
    private Text queryValueText;
    private FilterManager manager;
    private String localErrorMessage = null;

    public P4JobQueryPage(TaskRepository taskRepository, IRepositoryQuery query) {
        super("jobQuery", taskRepository, query);
        this.setTitle(Messages.P4JobQueryPage_JobQuery);
        this.setDescription(Messages.P4JobQueryPage_SearchJobs);
    }

    public P4JobQueryPage(TaskRepository taskRepository) {
        this(taskRepository, null);
    }

    public void setControlsEnabled(boolean enabled) {
    }

    public void applyTo(IRepositoryQuery query) {
        query.setUrl(this.getTaskRepository().getRepositoryUrl());
        query.setSummary(this.getQueryTitle());
        if (this.buildableButton.getSelection()) {
            query.setAttribute("P4_JOB_SEARCH_TYPE", "COMPLEX");
            String fullQuery = this.manager.getQuery();
            query.setAttribute("P4_JOB_QUERY", fullQuery);
            query.setAttribute("P4_JOB_COMPLEX_QUERY", this.manager.toStorageString());
        } else {
            query.setAttribute("P4_JOB_SEARCH_TYPE", "SIMPLE");
            query.setAttribute("P4_JOB_QUERY", this.queryValueText.getText());
        }
        if (this.limitButton.getSelection()) {
            int limit = this.limitSpinner.getSelection();
            query.setAttribute("P4_JOB_MAX", Integer.toString(limit));
        } else {
            query.setAttribute("P4_JOB_MAX", null);
        }
    }

    public String getQueryTitle() {
        return this.inSearchContainer() ? Messages.P4JobQueryPage_NewSearch : (this.queryTitleText != null ? this.queryTitleText.getText() : null);
    }

    public void setPageComplete(boolean complete) {
        super.setPageComplete(complete);
        ITaskSearchPageContainer container = this.getSearchContainer();
        if (container != null) {
            container.setPerformActionEnabled(complete);
        }
    }

    private void syncBuildable() {
        if (this.buildableButton.getSelection()) {
            String built = this.manager.getQuery();
            this.queryValueText.setText(built);
        }
    }

    private void loadValues() {
        boolean useDefault = true;
        IRepositoryQuery query = this.getQuery();
        if (query != null) {
            String limitValue;
            String type = query.getAttribute("P4_JOB_SEARCH_TYPE");
            if ("COMPLEX".equals(type)) {
                String fullQuery = query.getAttribute("P4_JOB_COMPLEX_QUERY");
                this.manager.fromStorageString(fullQuery);
                useDefault = false;
            } else if ("SIMPLE".equals(type)) {
                String value = query.getAttribute("P4_JOB_QUERY");
                if (value != null) {
                    this.queryValueText.setText(value);
                }
                this.manager.loadDefaults();
            }
            String title = query.getSummary();
            if (title != null) {
                this.queryTitleText.setText(title);
            }
            if ((limitValue = query.getAttribute("P4_JOB_MAX")) != null) {
                try {
                    int limit = Integer.parseInt(limitValue);
                    this.limitButton.setSelection(true);
                    this.limitSpinner.setEnabled(true);
                    this.limitSpinner.setSelection(limit);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else {
            useDefault = false;
            this.manager.loadDefaults();
        }
        if (useDefault) {
            this.manualButton.setSelection(true);
            this.queryValueText.setEnabled(true);
            this.manager.setEnabled(false);
        } else {
            this.buildableButton.setSelection(true);
            this.queryValueText.setEnabled(false);
            this.manager.setEnabled(true);
            this.syncBuildable();
        }
    }

    public void createControl(Composite parent) {
        Composite displayArea = new Composite(parent, 0);
        displayArea.setLayout((Layout)new GridLayout(1, true));
        displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        if (!this.inSearchContainer()) {
            Composite titleArea = new Composite(displayArea, 0);
            GridLayout taLayout = new GridLayout(2, false);
            titleArea.setLayout((Layout)taLayout);
            titleArea.setLayoutData((Object)new GridData(4, 4, true, false));
            Label titleLabel = new Label(titleArea, 0);
            titleLabel.setText(Messages.P4JobQueryPage_QueryTitle);
            this.queryTitleText = new Text(titleArea, 2052);
            this.queryTitleText.setLayoutData((Object)new GridData(4, 4, true, false));
            this.queryTitleText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    P4JobQueryPage.this.setPageComplete(P4JobQueryPage.this.isPageComplete());
                }
            });
        }
        SelectionAdapter buttonAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean manual = P4JobQueryPage.this.manualButton.getSelection();
                P4JobQueryPage.this.queryValueText.setEnabled(manual);
                P4JobQueryPage.this.manager.setEnabled(!manual);
                if (manual) {
                    P4JobQueryPage.this.setErrorMessage(null, null);
                } else {
                    P4JobQueryPage.this.manager.validate();
                }
            }
        };
        this.buildableButton = new Button(displayArea, 16);
        this.buildableButton.setText(Messages.P4JobQueryPage_SearchJobsWithRules);
        this.buildableButton.addSelectionListener((SelectionListener)buttonAdapter);
        IP4Connection connection = P4MylynUtils.getConnection((TaskRepository)this.getTaskRepository());
        this.manager = new FilterManager();
        this.manager.setErrorDisplay(this);
        this.manager.createControl(displayArea, connection);
        this.manager.addListener(new IFilterListener(){

            @Override
            public void removed(FilterEntry removed) {
                P4JobQueryPage.this.syncBuildable();
            }

            @Override
            public void modified(FilterEntry modified) {
                P4JobQueryPage.this.syncBuildable();
            }

            @Override
            public void added(FilterEntry entry) {
                P4JobQueryPage.this.syncBuildable();
            }

            @Override
            public void wordsModified(String words) {
                P4JobQueryPage.this.syncBuildable();
            }
        });
        this.manualButton = new Button(displayArea, 16);
        this.manualButton.setText(Messages.P4JobQueryPage_SeachJobsWithQuery);
        this.manualButton.addSelectionListener((SelectionListener)buttonAdapter);
        this.queryValueText = new Text(displayArea, 2052);
        GridData qvtData = new GridData(4, 4, true, false);
        qvtData.horizontalIndent = 15;
        this.queryValueText.setLayoutData((Object)qvtData);
        Composite limitArea = new Composite(displayArea, 0);
        GridLayout laLayout = new GridLayout(2, false);
        laLayout.marginHeight = 0;
        laLayout.marginWidth = 0;
        limitArea.setLayout((Layout)laLayout);
        limitArea.setLayoutData((Object)new GridData(4, 4, true, false));
        this.limitButton = new Button(limitArea, 32);
        this.limitButton.setText(Messages.P4JobQueryPage_LimitResults);
        this.limitButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                P4JobQueryPage.this.limitSpinner.setEnabled(P4JobQueryPage.this.limitButton.getSelection());
            }
        });
        this.limitSpinner = new Spinner(limitArea, 0);
        this.limitSpinner.setMinimum(1);
        this.limitSpinner.setMaximum(Integer.MAX_VALUE);
        this.limitSpinner.setSelection(100);
        this.limitSpinner.setEnabled(false);
        this.setControl((Control)displayArea);
        this.loadValues();
        if (connection.isOffline()) {
            this.setErrorMessage(Messages.P4JobQueryPage_OfflineError, null);
        }
        this.setPageComplete(this.isPageComplete());
    }

    public boolean isPageComplete() {
        if (this.localErrorMessage != null) {
            this.setErrorMessage(this.localErrorMessage);
            return false;
        }
        return super.isPageComplete();
    }

    public void setErrorMessage(String message, IErrorProvider provider) {
        this.localErrorMessage = message;
        this.setPageComplete(this.isPageComplete());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.setPageComplete(this.isPageComplete());
    }
}

