/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mylyn.job;

import com.perforce.p4java.core.IJobSpec;
import com.perforce.team.ui.DatePicker;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.mylyn.PerforceUiMylynPlugin;
import com.perforce.team.ui.mylyn.job.JobFieldManager;
import com.perforce.team.ui.mylyn.search.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class JobFieldEntry {
    public static final String[] TEXT_OPTIONS = new String[]{Messages.JobFieldEntry_Append, Messages.JobFieldEntry_Prepend, Messages.JobFieldEntry_Replace};
    private Composite displayArea;
    private Combo field;
    private Combo modifier;
    private Text textValue;
    private Combo selectValue;
    private ToolItem add;
    private ToolItem remove;
    private DatePicker date;
    private IJobSpec spec;
    private IJobSpec.IJobSpecField[] fields;
    private Map<String, String[]> sortedValues;
    private JobFieldManager manager;
    private ListenerList listeners = new ListenerList();

    public JobFieldEntry(JobFieldManager manager, IJobSpec spec) {
        this.manager = manager;
        this.spec = spec;
        List jobFields = this.spec.getFields();
        ArrayList<IJobSpec.IJobSpecField> editableFields = new ArrayList<IJobSpec.IJobSpecField>();
        for (IJobSpec.IJobSpecField field : jobFields) {
            String fieldType = field.getFieldType();
            if (101 == field.getCode() || "once".equals(fieldType) || "always".equals(fieldType)) continue;
            editableFields.add(field);
        }
        this.fields = editableFields.toArray(new IJobSpec.IJobSpecField[editableFields.size()]);
        Arrays.sort(this.fields, new Comparator<IJobSpec.IJobSpecField>(){

            @Override
            public int compare(IJobSpec.IJobSpecField o1, IJobSpec.IJobSpecField o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        this.sortedValues = new HashMap<String, String[]>();
    }

    public void setName(String name) {
        if (name != null) {
            this.field.setText(name);
        }
    }

    public void setValue(String value) {
        if (value != null) {
            this.updateValues();
            this.selectValue.setText(value);
        }
    }

    private void updateFields() {
        this.field.removeAll();
        IJobSpec.IJobSpecField[] iJobSpecFieldArray = this.fields;
        int n = this.fields.length;
        int n2 = 0;
        while (n2 < n) {
            IJobSpec.IJobSpecField field = iJobSpecFieldArray[n2];
            this.field.add(field.getName());
            ++n2;
        }
    }

    private boolean shouldSortValues() {
        return PerforceUiMylynPlugin.getDefault().getPreferenceStore().getBoolean("com.perforce.team.ui.mylyn.preferences.SORT_JOB_VALUES");
    }

    private void updateValues() {
        IJobSpec.IJobSpecField selected;
        String data;
        this.selectValue.removeAll();
        int index = this.field.getSelectionIndex();
        if (index >= 0 && "select".equals(data = (selected = this.fields[index]).getDataType())) {
            String[] sorted = this.sortedValues.get(selected.getName());
            if (sorted == null) {
                List values = this.spec.getFieldValues(selected.getName());
                sorted = values.toArray(new String[values.size()]);
                if (this.shouldSortValues()) {
                    Arrays.sort(sorted, new Comparator<String>(){

                        @Override
                        public int compare(String o1, String o2) {
                            return o1.compareToIgnoreCase(o2);
                        }
                    });
                }
                this.sortedValues.put(selected.getName(), sorted);
            }
            String[] stringArray = sorted;
            int n = sorted.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                this.selectValue.add(value);
                ++n2;
            }
        }
    }

    public FieldChange getFilter() {
        FieldChange filter = null;
        String name = null;
        String value = null;
        if (this.selectValue.isVisible()) {
            value = this.selectValue.getText().trim();
        } else if (this.textValue.isVisible()) {
            value = this.textValue.getText();
        }
        if (value != null) {
            int index = this.field.getSelectionIndex();
            IJobSpec.IJobSpecField selected = null;
            if (index >= 0) {
                filter = new FieldChange();
                selected = this.fields[index];
                filter.name = name = selected.getName();
                filter.value = value;
                if (this.modifier.isVisible()) {
                    int modIndex = this.modifier.getSelectionIndex();
                    switch (modIndex) {
                        case 0: {
                            filter.type = FieldChange.Type.APPEND;
                            break;
                        }
                        case 1: {
                            filter.type = FieldChange.Type.PREPEND;
                            break;
                        }
                        case 2: {
                            filter.type = FieldChange.Type.REPLACE;
                            break;
                        }
                    }
                }
            }
        }
        return filter;
    }

    private void updateModifiers() {
        int index = this.field.getSelectionIndex();
        if (index >= 0) {
            IJobSpec.IJobSpecField selected = this.fields[index];
            String data = selected.getDataType();
            boolean isText = "text".equals(data);
            boolean isDate = !isText && "date".equals(data);
            this.selectValue.setVisible(!isText);
            ((GridData)this.selectValue.getLayoutData()).exclude = isText;
            this.date.setVisible(isDate);
            this.modifier.setVisible(isText);
            ((GridData)this.modifier.getLayoutData()).exclude = !isText;
            this.textValue.setVisible(isText);
            ((GridData)this.textValue.getLayoutData()).exclude = !isText;
            this.layout();
        }
    }

    private void createButtonArea(final Composite parent, final Composite displayArea, final Composite layoutParent) {
        ToolBar buttonArea = new ToolBar(parent, 0x800000);
        GridLayout baLayout = new GridLayout(2, true);
        baLayout.marginHeight = 0;
        baLayout.marginWidth = 0;
        baLayout.horizontalSpacing = 0;
        buttonArea.setLayout((Layout)baLayout);
        this.remove = new ToolItem(buttonArea, 0x800008);
        Image removeImage = PerforceUIPlugin.getDescriptor((String)"normal/delete.png").createImage();
        P4UIUtils.registerDisposal((Widget)this.remove, (Resource)removeImage);
        this.remove.setImage(removeImage);
        this.remove.setToolTipText(Messages.FilterEntry_RemoveFilter);
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                parent.setVisible(false);
                ((GridData)parent.getLayoutData()).exclude = true;
                boolean allInvisible = true;
                Control[] controlArray = displayArea.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control control = controlArray[n2];
                    if (control.getVisible()) {
                        allInvisible = false;
                        break;
                    }
                    ++n2;
                }
                if (allInvisible) {
                    displayArea.setVisible(false);
                    ((GridData)displayArea.getLayoutData()).exclude = true;
                }
                layoutParent.layout(true, true);
                JobFieldEntry.this.manager.remove(JobFieldEntry.this);
                JobFieldEntry.this.notifyListeners();
            }
        });
        this.add = new ToolItem(buttonArea, 0x800008);
        Image addImage = PerforceUIPlugin.getDescriptor((String)"normal/add.png").createImage();
        P4UIUtils.registerDisposal((Widget)this.add, (Resource)addImage);
        this.add.setImage(addImage);
        this.add.setToolTipText(Messages.FilterEntry_AddFilter);
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobFieldEntry entry = new JobFieldEntry(JobFieldEntry.this.manager, JobFieldEntry.this.spec);
                entry.createControl(displayArea, layoutParent, true);
                layoutParent.layout(true, true);
                JobFieldEntry.this.manager.add(entry);
            }
        });
    }

    private void layout() {
        this.displayArea.getParent().layout(true, true);
    }

    public void createControl(Composite parent, Composite layoutParent, boolean useParent) {
        if (!useParent) {
            parent = new Composite(parent, 0);
            GridLayout daLayout = new GridLayout(1, true);
            daLayout.marginHeight = 0;
            daLayout.marginWidth = 0;
            parent.setLayout((Layout)daLayout);
            GridData daData = new GridData(4, 0x1000000, true, false);
            parent.setLayoutData((Object)daData);
        }
        this.displayArea = parent;
        Composite filter = new Composite(this.displayArea, 0);
        GridLayout fLayout = new GridLayout(6, false);
        fLayout.marginHeight = 0;
        fLayout.marginWidth = 0;
        filter.setLayout((Layout)fLayout);
        GridData fData = new GridData(4, 0x1000000, true, false);
        filter.setLayoutData((Object)fData);
        this.field = new Combo(filter, 12);
        this.updateFields();
        this.field.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobFieldEntry.this.updateValues();
                JobFieldEntry.this.updateModifiers();
                JobFieldEntry.this.notifyListeners();
            }
        });
        this.date = new DatePicker();
        this.date.createControl(filter);
        this.date.setVisible(false);
        this.modifier = new Combo(filter, 12);
        String[] stringArray = TEXT_OPTIONS;
        int n = TEXT_OPTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String option = stringArray[n2];
            this.modifier.add(option);
            ++n2;
        }
        this.modifier.select(0);
        GridData mData = new GridData();
        mData.exclude = true;
        this.modifier.setLayoutData((Object)mData);
        this.modifier.setVisible(false);
        this.textValue = new Text(filter, 2050);
        this.textValue.setVisible(false);
        GridData tvData = new GridData(4, 4, true, false);
        tvData.heightHint = P4UIUtils.computePixelHeight((Font)this.textValue.getFont(), (int)5);
        tvData.exclude = true;
        this.textValue.setLayoutData((Object)tvData);
        this.selectValue = new Combo(filter, 4);
        this.selectValue.setLayoutData((Object)new GridData(4, 4, true, false));
        this.selectValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JobFieldEntry.this.notifyListeners();
            }
        });
        this.date.setCombo(this.selectValue);
        this.createButtonArea(filter, this.displayArea, layoutParent);
    }

    public void createControl(Composite parent) {
        this.createControl(parent, parent, false);
    }

    public void setRemoveEnabled(boolean enabled) {
        this.remove.setEnabled(enabled);
    }

    private void notifyListeners() {
        Event event = new Event();
        event.data = this;
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((Listener)listener).handleEvent(event);
            ++n2;
        }
    }

    public void addListener(Listener listener) {
        if (listener != null) {
            this.listeners.add((Object)listener);
        }
    }

    public void removeListener(Listener listener) {
        if (listener != null) {
            this.listeners.remove((Object)listener);
        }
    }

    public static class FieldChange {
        public String name;
        public String value;
        public Type type = Type.REPLACE;

        static enum Type {
            APPEND,
            PREPEND,
            REPLACE;

        }
    }
}

