/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mylyn.job;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.ui.mylyn.job.IBulkChange;
import com.perforce.team.ui.mylyn.job.IJobProxy;
import com.perforce.team.ui.mylyn.job.JobProxyContainer;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.TransferData;

public class BulkChangeDropAdapter
extends ViewerDropAdapter {
    private IBulkChange change;

    protected BulkChangeDropAdapter(Viewer viewer, IBulkChange change) {
        super(viewer);
        this.change = change;
    }

    public boolean performDrop(Object data) {
        if (data instanceof IStructuredSelection) {
            ArrayList<IJobProxy> proxies = new ArrayList<IJobProxy>();
            IJobProxy proxy = null;
            IP4Connection connection = this.change.getConnection();
            Object[] objectArray = ((IStructuredSelection)data).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                proxy = (IJobProxy)P4CoreUtils.convert((Object)element, IJobProxy.class);
                if (proxy != null && connection.equals(proxy.getConnection())) {
                    proxies.add(proxy);
                } else {
                    JobProxyContainer container = (JobProxyContainer)((Object)P4CoreUtils.convert((Object)element, JobProxyContainer.class));
                    if (container != null && connection.equals(container.getConnection())) {
                        proxies.addAll(Arrays.asList(container.getJobs()));
                    }
                }
                ++n2;
            }
            if (proxies.size() > 0) {
                this.change.add(proxies.toArray(new IJobProxy[proxies.size()]));
            }
            return true;
        }
        return false;
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        return LocalSelectionTransfer.getTransfer().isSupportedType(transferType) && this.change.getConnection() != null;
    }
}

