/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mylyn.history;

import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4Revision;
import com.perforce.team.ui.mylyn.P4MylynUiUtils;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.mylyn.internal.team.ui.LinkedTaskInfo;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.team.ui.AbstractTaskReference;

public class P4RevisionAdapterFactory
implements IAdapterFactory {
    private static final Class[] CLASSES = new Class[]{AbstractTaskReference.class, TaskRepository.class};

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof IP4Revision) {
            IP4Revision revision = (IP4Revision)adaptableObject;
            if (AbstractTaskReference.class == adapterType) {
                String[] jobIds;
                TaskRepository repository = P4MylynUiUtils.getRepository(revision.getConnection());
                String url = repository != null ? repository.getRepositoryUrl() : null;
                String jobId = null;
                IP4Changelist list = revision.getConnection().getChangelistById(revision.getChangelist(), null, true, false);
                if (list != null && (jobIds = list.getJobIds()) != null && jobIds.length > 0) {
                    jobId = jobIds[0];
                }
                return new LinkedTaskInfo(url, jobId, null, revision.getComment());
            }
            if (TaskRepository.class == adapterType) {
                return P4MylynUiUtils.getRepository(revision.getConnection());
            }
        }
        return null;
    }

    public Class[] getAdapterList() {
        return CLASSES;
    }

    private static String getFileName(String nameWithExtension) {
        String[] segs;
        if (nameWithExtension != null && (segs = nameWithExtension.split("\\.")) != null && segs.length > 0) {
            return segs[0];
        }
        return null;
    }
}

