/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mylyn.editor;

import com.perforce.team.ui.mylyn.PerforceUiMylynPlugin;
import com.perforce.team.ui.mylyn.editor.JobField;
import com.perforce.team.ui.mylyn.editor.JobFieldGroup;
import com.perforce.team.ui.mylyn.editor.Messages;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorAttributePart;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMetaData;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.LayoutHint;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class JobTaskEditorPart
extends TaskEditorAttributePart {
    private static Field ATTRIBUTE_EDITORS_FIELD = null;
    private JobFieldGroup page;
    private Map<String, Integer> fields;

    static {
        try {
            ATTRIBUTE_EDITORS_FIELD = TaskEditorAttributePart.class.getDeclaredField("attributeEditors");
            if (ATTRIBUTE_EDITORS_FIELD != null) {
                ATTRIBUTE_EDITORS_FIELD.setAccessible(true);
            }
        }
        catch (SecurityException securityException) {
            ATTRIBUTE_EDITORS_FIELD = null;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            ATTRIBUTE_EDITORS_FIELD = null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ATTRIBUTE_EDITORS_FIELD = null;
        }
    }

    public JobTaskEditorPart(JobFieldGroup page) {
        this.page = page;
        this.fields = new HashMap<String, Integer>();
        if (this.page != null) {
            JobField[] fields = this.page.getFields();
            int i = 0;
            while (i < fields.length) {
                this.fields.put(fields[i].getField().getName(), i);
                ++i;
            }
        }
    }

    protected Control createContent(FormToolkit toolkit, Composite parent) {
        Control control;
        if (ATTRIBUTE_EDITORS_FIELD != null) {
            try {
                Object reflected = ATTRIBUTE_EDITORS_FIELD.get((Object)this);
                if (reflected instanceof List) {
                    List list = (List)reflected;
                    this.sortAttributeEditors(list);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        if ((control = super.createContent(toolkit, parent)) instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object data;
                Control child = controlArray[n2];
                if ((child instanceof Text || child instanceof Combo) && (data = control.getLayoutData()) instanceof GridData) {
                    ((GridData)data).grabExcessHorizontalSpace = true;
                    ((GridData)data).horizontalAlignment = 4;
                    child.setLayoutData(data);
                }
                ++n2;
            }
        }
        if (this.fields.size() == 0 && control instanceof Composite) {
            Label label = new Label((Composite)control, 0);
            label.setText(Messages.P4JobEditorPage_AdvancedAttributesEmpty);
        }
        return control;
    }

    protected boolean shouldExpandOnCreate() {
        return true;
    }

    private boolean isGroupByType() {
        return PerforceUiMylynPlugin.getDefault().getPreferenceStore().getBoolean("com.perforce.team.ui.mylyn.preferences.GROUP_FIELDS_BY_TYPE");
    }

    private void sortAttributeEditors(List<Object> editors) {
        if (this.isGroupByType()) {
            Collections.sort(editors, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    if (o1 instanceof AbstractAttributeEditor && o2 instanceof AbstractAttributeEditor) {
                        int p2;
                        AbstractAttributeEditor a1 = (AbstractAttributeEditor)o1;
                        AbstractAttributeEditor a2 = (AbstractAttributeEditor)o2;
                        LayoutHint hint1 = a1.getLayoutHint();
                        int p1 = hint1 != null ? hint1.getPriority() : 10;
                        LayoutHint hint2 = a2.getLayoutHint();
                        int n = p2 = hint2 != null ? hint2.getPriority() : 10;
                        if (p1 != p2) {
                            return p1 - p2;
                        }
                        p1 = (Integer)JobTaskEditorPart.this.fields.get(a1.getTaskAttribute().getMetaData().getLabel());
                        p2 = (Integer)JobTaskEditorPart.this.fields.get(a2.getTaskAttribute().getMetaData().getLabel());
                        return p1 - p2;
                    }
                    return 0;
                }
            });
        } else {
            Collections.sort(editors, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    if (o1 instanceof AbstractAttributeEditor && o2 instanceof AbstractAttributeEditor) {
                        AbstractAttributeEditor a1 = (AbstractAttributeEditor)o1;
                        AbstractAttributeEditor a2 = (AbstractAttributeEditor)o2;
                        int p1 = (Integer)JobTaskEditorPart.this.fields.get(a1.getTaskAttribute().getMetaData().getLabel());
                        int p2 = (Integer)JobTaskEditorPart.this.fields.get(a2.getTaskAttribute().getMetaData().getLabel());
                        return p1 - p2;
                    }
                    return 0;
                }
            });
        }
    }

    protected AbstractAttributeEditor createAttributeEditor(TaskAttribute attribute) {
        TaskAttributeMetaData properties;
        AbstractAttributeEditor editor = null;
        if (!"task.common.description".equals(attribute.getId()) && this.fields.containsKey((properties = attribute.getMetaData()).getLabel()) && "task.common.kind.default".equals(properties.getKind())) {
            editor = super.createAttributeEditor(attribute);
        }
        return editor;
    }
}

