/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mylyn.connection;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.ui.PerforceLabelProvider;
import com.perforce.team.ui.dialogs.P4StatusDialog;
import com.perforce.team.ui.mylyn.connection.Messages;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskRepositoryLabelProvider;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ConnectionMappingDialog
extends P4StatusDialog {
    private IP4Connection[] connections = null;
    private TaskRepository[] repositories = null;
    private IP4Connection selectedConnection = null;
    private TaskRepository selectedRepository = null;
    private boolean forceRepository = true;

    public ConnectionMappingDialog(Shell parent, IP4Connection[] connections, TaskRepository[] repositories) {
        this(parent, connections, repositories, null, true);
    }

    public ConnectionMappingDialog(Shell parent, IP4Connection[] connections, TaskRepository[] repositories, TaskRepository selected, boolean forceRepository) {
        super(parent, Messages.ConnectionMappingDialog_NewConnectionMappingTitle);
        this.setModalResizeStyle();
        this.connections = connections;
        this.repositories = repositories;
        this.selectedRepository = selected;
        this.forceRepository = forceRepository;
    }

    public IP4Connection getConnection() {
        return this.selectedConnection;
    }

    public TaskRepository getRepository() {
        return this.selectedRepository;
    }

    private void validate() {
        String message = null;
        if (this.selectedConnection == null) {
            message = Messages.ConnectionMappingDialog_SelectConnection;
        } else if (this.selectedRepository == null && this.forceRepository) {
            message = Messages.ConnectionMappingDialog_SelectTaskRepository;
        }
        this.setErrorMessage(message);
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        Composite displayArea = new Composite(c, 0);
        displayArea.setLayout((Layout)new GridLayout(2, false));
        if (this.connections.length > 1) {
            Label connectionLabel = new Label(displayArea, 0);
            connectionLabel.setText(Messages.ConnectionMappingDialog_Connections);
            GridData clData = new GridData(4, 4, true, true);
            clData.horizontalSpan = 2;
            connectionLabel.setLayoutData((Object)clData);
            final CheckboxTableViewer connectionViewer = CheckboxTableViewer.newCheckList((Composite)displayArea, (int)2816);
            GridData cvData = new GridData(4, 4, true, true);
            cvData.heightHint = 80;
            cvData.horizontalSpan = 2;
            connectionViewer.getTable().setLayoutData((Object)cvData);
            connectionViewer.getTable().setLinesVisible(true);
            connectionViewer.setSorter(new ViewerSorter());
            connectionViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            connectionViewer.setLabelProvider((IBaseLabelProvider)new PerforceLabelProvider());
            connectionViewer.setInput((Object)this.connections);
            connectionViewer.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    if (event.getChecked()) {
                        connectionViewer.setCheckedElements(new Object[]{event.getElement()});
                        ConnectionMappingDialog.this.selectedConnection = (IP4Connection)event.getElement();
                    } else {
                        ConnectionMappingDialog.this.selectedConnection = null;
                    }
                    ConnectionMappingDialog.this.validate();
                }
            });
        } else if (this.connections.length > 0) {
            this.selectedConnection = this.connections[0];
            final PerforceLabelProvider labelProvider = new PerforceLabelProvider();
            Label imageLabel = new Label(displayArea, 0);
            imageLabel.setImage(labelProvider.getImage((Object)this.selectedConnection));
            Label textLabel = new Label(displayArea, 0);
            textLabel.setText(labelProvider.getText((Object)this.selectedConnection));
            imageLabel.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    labelProvider.dispose();
                }
            });
        }
        Label repositoryLabel = new Label(displayArea, 0);
        repositoryLabel.setText(Messages.ConnectionMappingDialog_TaskRepositories);
        GridData rlData = new GridData(4, 4, true, true);
        rlData.horizontalSpan = 2;
        repositoryLabel.setLayoutData((Object)rlData);
        final CheckboxTableViewer repositoryViewer = CheckboxTableViewer.newCheckList((Composite)displayArea, (int)2816);
        GridData rvData = new GridData(4, 4, true, true);
        rvData.heightHint = 80;
        rvData.horizontalSpan = 2;
        repositoryViewer.getTable().setLayoutData((Object)rvData);
        repositoryViewer.getTable().setLinesVisible(true);
        repositoryViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        repositoryViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new TaskRepositoryLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        repositoryViewer.setSorter(new ViewerSorter());
        repositoryViewer.setInput((Object)this.repositories);
        repositoryViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    repositoryViewer.setCheckedElements(new Object[]{event.getElement()});
                    ConnectionMappingDialog.this.selectedRepository = (TaskRepository)event.getElement();
                } else {
                    ConnectionMappingDialog.this.selectedRepository = null;
                }
                ConnectionMappingDialog.this.validate();
            }
        });
        if (this.selectedRepository != null) {
            repositoryViewer.setChecked((Object)this.selectedRepository, true);
        }
        this.validate();
        return c;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okStatusButton = this.createButton(parent, 0, Messages.ConnectionMappingDialog_Link, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }
}

