/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mylyn;

import com.perforce.team.core.ConnectionParameters;
import com.perforce.team.core.mylyn.P4MylynUtils;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceLabelProvider;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.connection.ConnectionWizard;
import com.perforce.team.ui.connection.ConnectionWizardDialog;
import com.perforce.team.ui.mylyn.Messages;
import com.perforce.team.ui.mylyn.P4MylynUiUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.wizards.ITaskRepositoryPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class P4JobSettingsPage
extends WizardPage
implements ITaskRepositoryPage {
    private boolean titleUpdated = false;
    private Text titleText;
    private TableViewer existingConnectionTable;
    private TaskRepository repository;
    private List<TaskRepository> existingRepos = new ArrayList<TaskRepository>();

    public P4JobSettingsPage(TaskRepository taskRepository) {
        super("jobSettings");
        this.setTitle(Messages.P4JobSettingsPage_PerforceJobs);
        this.setDescription(Messages.P4JobSettingsPage_ConfigureJobsRepository);
        this.repository = taskRepository;
    }

    public void applyTo(TaskRepository repository) {
        IP4Connection connection = this.getConnection();
        if (connection != null) {
            P4MylynUiUtils.setTaskSettings(connection, repository);
            String title = this.titleText.getText().trim();
            if (title.length() == 0) {
                title = connection.getParameters().getPort();
            }
            repository.setRepositoryLabel(title);
        }
    }

    public String getRepositoryUrl() {
        IP4Connection connection = this.getConnection();
        return connection != null ? connection.getParameters().getPort() : null;
    }

    private void createExistingArea(Composite displayArea) {
        Label tableLabel = new Label(displayArea, 0);
        tableLabel.setText(Messages.P4JobSettingsPage_ServerConnections);
        tableLabel.setLayoutData((Object)new GridData(4, 4, true, true));
        this.existingConnectionTable = this.createExistingServerArea(displayArea);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                P4JobSettingsPage.this.updateEnablement();
                P4JobSettingsPage.this.setTitleToSelection();
            }
        };
        this.existingConnectionTable.getTable().addSelectionListener((SelectionListener)selectionAdapter);
        Button newConnection = new Button(displayArea, 0);
        Image addImage = PerforceUIPlugin.getDescriptor((String)"normal/add.png").createImage();
        P4UIUtils.registerDisposal((Widget)newConnection, (Resource)addImage);
        newConnection.setImage(addImage);
        newConnection.setText(Messages.P4JobSettingsPage_AddConnection);
        newConnection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionWizardDialog dialog = new ConnectionWizardDialog(P4UIUtils.getDialogShell(), new ConnectionWizard());
                if (dialog.open() == 0) {
                    ConnectionParameters params = dialog.getConnectionParameters();
                    if (P4ConnectionManager.getManager().containsConnection(params)) {
                        P4JobSettingsPage.this.existingConnectionTable.setInput((Object)P4ConnectionManager.getManager().getConnections());
                        IP4Connection select = P4ConnectionManager.getManager().getConnection(params);
                        P4JobSettingsPage.this.existingConnectionTable.setSelection((ISelection)new StructuredSelection((Object)select));
                        P4JobSettingsPage.this.setTitleToSelection();
                        P4JobSettingsPage.this.updateEnablement();
                    }
                }
            }
        });
    }

    public void createControl(Composite parent) {
        Composite displayArea = new Composite(parent, 0);
        displayArea.setLayout((Layout)new GridLayout(1, true));
        displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite titleArea = new Composite(displayArea, 0);
        GridLayout taLayout = new GridLayout(2, false);
        titleArea.setLayout((Layout)taLayout);
        titleArea.setLayoutData((Object)new GridData(4, 4, true, false));
        Label titleLabel = new Label(titleArea, 0);
        titleLabel.setText(Messages.P4JobSettingsPage_Label);
        this.titleText = new Text(titleArea, 2052);
        this.titleText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.titleText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                P4JobSettingsPage.this.updateEnablement();
                P4JobSettingsPage.this.titleUpdated = true;
            }
        });
        this.createExistingArea(displayArea);
        for (TaskRepository repository : TasksUi.getRepositoryManager().getRepositories("perforce")) {
            if (repository.equals((Object)this.repository)) continue;
            this.existingRepos.add(repository);
        }
        if (this.repository == null) {
            if (this.existingRepos.isEmpty() && this.existingConnectionTable.getTable().getItemCount() > 0) {
                this.existingConnectionTable.getTable().setSelection(0);
            }
            this.setPageComplete(false);
        } else {
            IP4Connection connection = P4MylynUtils.getConnection((TaskRepository)this.repository);
            if (connection != null) {
                this.existingConnectionTable.setSelection((ISelection)new StructuredSelection((Object)connection));
            }
            this.fillWidget();
        }
        this.setControl((Control)displayArea);
    }

    private void fillWidget() {
        String label;
        if (this.repository != null && (label = this.repository.getRepositoryLabel()) != null) {
            this.titleText.setText(label);
        }
    }

    private void setTitleToSelection() {
        IP4Connection connection;
        if (!this.titleUpdated && (connection = this.getConnection()) != null) {
            this.titleText.setText(connection.getParameters().getPort());
            this.titleUpdated = false;
        }
    }

    private void updateEnablement() {
        IP4Connection connection;
        String message = null;
        String name = this.titleText.getText().trim();
        for (TaskRepository repo : this.existingRepos) {
            if (!name.equals(repo.getRepositoryLabel())) continue;
            message = Messages.P4JobSettingsPage_RepositoryLabelExists;
            break;
        }
        if (message == null && (connection = this.getConnection()) != null) {
            for (TaskRepository repo : this.existingRepos) {
                if (!repo.equals((Object)P4MylynUiUtils.findRepository(connection, "perforce"))) continue;
                message = Messages.P4JobSettingsPage_RepositoryExists;
                break;
            }
        }
        if (message == null && this.existingConnectionTable != null && this.existingConnectionTable.getTable().getSelectionCount() != 1) {
            message = Messages.P4JobSettingsPage_SelectServer;
        }
        this.setErrorMessage(message);
        this.setPageComplete(this.getErrorMessage() == null);
    }

    private TableViewer createExistingServerArea(Composite parent) {
        Composite existingArea = new Composite(parent, 0);
        existingArea.setLayout((Layout)new GridLayout(1, true));
        existingArea.setLayoutData((Object)new GridData(4, 4, true, true));
        TableViewer viewer = new TableViewer(existingArea, 68356);
        viewer.setLabelProvider((IBaseLabelProvider)new PerforceLabelProvider(false));
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setSorter(new ViewerSorter());
        GridData vData = new GridData(4, 4, true, true);
        vData.heightHint = 100;
        viewer.getTable().setLayoutData((Object)vData);
        viewer.setInput((Object)P4ConnectionManager.getManager().getConnections());
        return viewer;
    }

    private IP4Connection getConnection() {
        IStructuredSelection selection;
        IP4Connection connection = null;
        if (this.existingConnectionTable != null && (selection = (IStructuredSelection)this.existingConnectionTable.getSelection()).getFirstElement() instanceof IP4Connection) {
            connection = (IP4Connection)selection.getFirstElement();
        }
        return connection;
    }

    public void performFinish(TaskRepository repository) {
        this.applyTo(repository);
    }

    public boolean preFinish(TaskRepository repository) {
        return true;
    }
}

