/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.folder.timelapse;

import com.perforce.p4java.core.file.FileAction;
import com.perforce.p4java.core.file.IFileRevisionData;
import com.perforce.team.core.p4java.IP4Revision;
import com.perforce.team.core.p4java.P4File;
import com.perforce.team.ui.folder.timelapse.FileEntry;
import com.perforce.team.ui.timelapse.ITickFormatter;
import java.util.Collection;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;

public class FolderTickFormatter
implements ITickFormatter {
    private Color color;
    private FileEntry entry;
    private Collection<Integer> aheadLists;

    public void setAheads(Collection<Integer> aheads) {
        this.aheadLists = aheads;
    }

    public void setFile(FileEntry file) {
        this.entry = file;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color format(IP4Revision revision, int tickNumber, PaintEvent event) {
        if (this.color != null) {
            if (this.entry != null) {
                IFileRevisionData data = this.entry.getData(revision.getChangelist());
                if (data != null && data.getChangelistId() == revision.getChangelist()) {
                    boolean outOfSync = false;
                    if (this.entry.getHaveRevision() == 0) {
                        outOfSync = !P4File.isActionDelete((FileAction)this.entry.getLast().getAction());
                    } else if (data.getRevision() > this.entry.getHaveRevision()) {
                        outOfSync = true;
                    }
                    if (outOfSync) {
                        return event.display.getSystemColor(4);
                    }
                    if (data.getChangelistId() == revision.getChangelist()) {
                        return this.color;
                    }
                }
            } else if (this.aheadLists != null && this.aheadLists.contains(revision.getChangelist())) {
                return event.display.getSystemColor(4);
            }
        }
        return event.display.getSystemColor(16);
    }
}

