/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.folder.timelapse;

import com.perforce.p4java.core.file.FileAction;
import com.perforce.p4java.core.file.IFileRevisionData;
import com.perforce.p4java.core.file.IRevisionIntegrationData;
import com.perforce.team.core.p4java.IP4Revision;
import com.perforce.team.core.p4java.P4File;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.folder.timelapse.FileEntry;
import com.perforce.team.ui.folder.timelapse.FolderEntry;
import com.perforce.team.ui.folder.timelapse.Messages;
import com.perforce.team.ui.text.PerforceUiTextPlugin;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class FolderLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private IP4Revision revision = null;
    private Color changeColor;
    private String root = null;
    private WorkbenchLabelProvider provider = new WorkbenchLabelProvider();

    public FolderLabelProvider() {
        this.changeColor = new Color((Device)P4UIUtils.getDisplay(), PreferenceConverter.getColor((IPreferenceStore)PerforceUiTextPlugin.getDefault().getPreferenceStore(), (String)"com.perforce.team.ui.text.timelapse.TICK_CHANGE_COLOR"));
    }

    public void setRevision(IP4Revision revision, String root) {
        this.revision = revision;
        this.root = root;
    }

    public Image getImage(Object element) {
        return this.provider.getImage(element);
    }

    public StyledString getStyledText(Object element) {
        if (this.revision != null) {
            int revisionId = this.revision.getChangelist();
            if (element instanceof FileEntry) {
                FileEntry revisionFile = (FileEntry)element;
                final IFileRevisionData file = revisionFile.getData(revisionId);
                int id = file.getChangelistId();
                if (revisionId == id) {
                    StyledString text = new StyledString(revisionFile.getLabel(revisionFile), new StyledString.Styler(){

                        public void applyStyles(TextStyle textStyle) {
                            textStyle.foreground = FolderLabelProvider.this.changeColor;
                            if (P4File.isActionDelete((FileAction)file.getAction())) {
                                textStyle.strikeout = true;
                            }
                        }
                    });
                    List integs = file.getRevisionIntegrationData();
                    if (integs != null && integs.size() > 0) {
                        for (IRevisionIntegrationData integ : integs) {
                            String from;
                            if (integ.getHowFrom().equals("moved from")) {
                                from = integ.getFromFile();
                                if (from != null && from.startsWith(this.root)) {
                                    from = from.substring(this.root.length() + 1);
                                }
                                text.append(MessageFormat.format(Messages.FolderLabelProvider_From, from));
                                continue;
                            }
                            if (!integ.getHowFrom().equals("branch from")) continue;
                            from = integ.getFromFile();
                            if (from != null && from.startsWith(this.root)) {
                                from = from.substring(this.root.length() + 1);
                            }
                            text.append(MessageFormat.format(Messages.FolderLabelProvider_From, from));
                        }
                    }
                    return text;
                }
                if (!revisionFile.isSynced(revisionId)) {
                    StyledString text = new StyledString(revisionFile.getLabel(revisionFile), new StyledString.Styler(){

                        public void applyStyles(TextStyle textStyle) {
                            textStyle.foreground = P4UIUtils.getDisplay().getSystemColor(4);
                        }
                    });
                    return text;
                }
                return new StyledString(revisionFile.getLabel(revisionFile));
            }
            if (element instanceof FolderEntry) {
                String from;
                FolderEntry revisionFolder = (FolderEntry)element;
                StyledString text = new StyledString(this.provider.getText(element));
                if (revisionFolder.isMoveAdd(revisionId) && (from = revisionFolder.getMoveFrom(revisionId)) != null) {
                    text.append(" ");
                    text.append(from, new StyledString.Styler(){

                        public void applyStyles(TextStyle textStyle) {
                            textStyle.strikeout = true;
                        }
                    });
                }
                return text;
            }
        }
        return new StyledString(this.provider.getText(element));
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        this.provider.dispose();
        this.changeColor.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

