/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.folder.diff.editor;

import com.perforce.p4java.core.IFileDiff;
import com.perforce.team.core.folder.IP4DiffFile;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.P4Storage;
import com.perforce.team.ui.diff.DiffContentProvider;
import com.perforce.team.ui.diff.IFileDiffer;
import com.perforce.team.ui.folder.diff.model.FileDiffContainer;
import com.perforce.team.ui.folder.diff.model.FileDiffElement;
import com.perforce.team.ui.folder.diff.model.FileEntry;
import java.io.InputStream;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.StructuredViewer;

public class FileDiffContentProvider
extends DiffContentProvider {
    private FileDiffContainer container = new FileDiffContainer();
    private ListenerList listeners = new ListenerList();

    public FileDiffContentProvider(StructuredViewer viewer, boolean async) {
        super(viewer, async);
    }

    public void addDiffListener(IDiffListener listener) {
        if (listener != null) {
            this.listeners.add((Object)listener);
        }
    }

    public void removeDiffListener(IDiffListener listener) {
        if (listener != null) {
            this.listeners.remove((Object)listener);
        }
    }

    public void setContainer(FileDiffContainer container) {
        if (container != null) {
            this.clearDiffers();
            this.container = container;
        }
    }

    protected void updateResource(IP4Resource resource) {
        super.updateResource(resource);
        if (resource instanceof IP4DiffFile) {
            IP4DiffFile diffFile = (IP4DiffFile)resource;
            Object[] objectArray = this.listeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ((IDiffListener)listener).update(diffFile);
                ++n2;
            }
        }
    }

    public Object getParent(Object element) {
        FileEntry entry;
        if (element instanceof IP4DiffFile && (entry = this.container.getEntry((IP4DiffFile)element)) != null) {
            return entry.getParent(element);
        }
        return super.getParent(element);
    }

    public boolean canDiff(IP4Resource file) {
        if (file instanceof IP4DiffFile) {
            return IFileDiff.Status.CONTENT == ((IP4DiffFile)file).getStatus();
        }
        return false;
    }

    public IStorage getLeftStorage(IP4Resource resource, IP4File file) {
        IP4DiffFile diffFile;
        int revision;
        if (resource instanceof IP4DiffFile && (revision = (diffFile = (IP4DiffFile)resource).getDiff().getRevision1()) > 0) {
            return new P4Storage(){

                public InputStream getContents() throws CoreException {
                    return diffFile.getFile1Contents();
                }
            };
        }
        return null;
    }

    public IStorage getRightStorage(IP4Resource resource, IP4File file) {
        IP4DiffFile diffFile;
        int revision;
        if (resource instanceof IP4DiffFile && (revision = (diffFile = (IP4DiffFile)resource).getDiff().getRevision2()) > 0) {
            return new P4Storage(){

                public InputStream getContents() throws CoreException {
                    return diffFile.getFile2Contents();
                }
            };
        }
        return null;
    }

    protected Object[] getDiffs(IFileDiffer differ, IP4Resource resource) {
        Object[] diffs = super.getDiffs(differ, resource);
        if (diffs.length > 0 && resource instanceof IP4DiffFile) {
            Object[] converted = new Object[diffs.length];
            int index = 0;
            IP4DiffFile file = (IP4DiffFile)resource;
            Object[] objectArray = diffs;
            int n = diffs.length;
            int n2 = 0;
            while (n2 < n) {
                Object diff = objectArray[n2];
                if (diff instanceof IDiffElement) {
                    diff = new FileDiffElement((IDiffElement)diff, file);
                }
                converted[index] = diff;
                ++index;
                ++n2;
            }
            diffs = converted;
        }
        return diffs;
    }

    public static interface IDiffListener {
        public void load(IP4DiffFile var1);

        public void update(IP4DiffFile var1);
    }
}

