/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.folder.diff.actions;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.mergequest.model.Branch;
import com.perforce.team.core.mergequest.model.BranchSpecMapping;
import com.perforce.team.core.mergequest.model.DepotPathMapping;
import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.core.mergequest.model.Mapping;
import com.perforce.team.core.p4java.IP4Branch;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Folder;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.folder.diff.actions.DiffBranchAction;
import com.perforce.team.ui.folder.diff.actions.DiffFoldersAction;
import com.perforce.team.ui.folder.diff.actions.Messages;
import com.perforce.team.ui.folder.diff.editor.input.BranchDiffInput;
import com.perforce.team.ui.folder.diff.editor.input.DiffConfiguration;
import com.perforce.team.ui.folder.diff.editor.input.FolderDiffInput;
import com.perforce.team.ui.folder.diff.editor.input.IDiffConfiguration;
import com.perforce.team.ui.folder.diff.editor.input.IFolderDiffInput;
import com.perforce.team.ui.p4java.actions.P4Action;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IPersistableElement;

public class DiffMappingAction
extends P4Action {
    protected void runAction() {
        IP4Connection connection;
        IBranchGraph graph;
        Object first;
        Mapping mapping;
        if (this.getSelection() != null && (mapping = (Mapping)P4CoreUtils.convert((Object)(first = this.getSelection().getFirstElement()), Mapping.class)) != null && (graph = mapping.getGraph()) != null && (connection = graph.getConnection()) != null) {
            if (mapping instanceof BranchSpecMapping) {
                this.runDiffAction((BranchSpecMapping)mapping, connection);
            } else if (mapping instanceof DepotPathMapping) {
                final DepotPathMapping depotMapping = (DepotPathMapping)mapping;
                final String source = depotMapping.getSourcePath();
                final String target = depotMapping.getTargetPath();
                if (source != null && target != null) {
                    P4Runnable runnable = new P4Runnable(){

                        public void run(IProgressMonitor monitor) {
                            monitor.beginTask("", 3);
                            monitor.subTask(source);
                            IP4Folder folder1 = connection.getFolder(DiffMappingAction.this.getPath(source));
                            monitor.worked(1);
                            monitor.subTask(target);
                            IP4Folder folder2 = connection.getFolder(DiffMappingAction.this.getPath(target));
                            monitor.worked(1);
                            if (folder1 != null && folder2 != null) {
                                DiffMappingAction.this.runDiffAction(depotMapping, folder1, folder2);
                            }
                            monitor.worked(1);
                            monitor.done();
                        }

                        public String getTitle() {
                            return Messages.DiffMappingAction_LoadingFolders;
                        }
                    };
                    this.runRunnable((IP4Runnable)runnable);
                }
            }
        }
    }

    private IDiffConfiguration createHeaderConfiguration(Mapping mapping) {
        return new DiffConfiguration(MessageFormat.format(Messages.DiffMappingAction_Comparing, mapping.getName()), P4UIUtils.getImageDescriptor((Object)mapping));
    }

    private IDiffConfiguration createBranchConfiguration(Branch branch) {
        return branch != null ? new DiffConfiguration(branch.getName(), P4UIUtils.getImageDescriptor((Object)branch)){

            @Override
            public void setLabel(String label) {
            }
        } : null;
    }

    private void runDiffAction(final BranchSpecMapping mapping, IP4Connection connection) {
        IP4Branch branch = mapping.generateBranch(connection);
        if (branch != null) {
            DiffBranchAction branchAction = new DiffBranchAction(){

                @Override
                protected IFolderDiffInput generateInput(IP4Branch branch) {
                    IDiffConfiguration leftConfig = DiffMappingAction.this.createBranchConfiguration(mapping.getSource());
                    IDiffConfiguration rightConfig = DiffMappingAction.this.createBranchConfiguration(mapping.getTarget());
                    IDiffConfiguration headerConfig = DiffMappingAction.this.createHeaderConfiguration((Mapping)mapping);
                    BranchDiffInput input = new BranchDiffInput(branch.getName(), branch.getConnection(), headerConfig, leftConfig, rightConfig){

                        @Override
                        public boolean exists() {
                            return false;
                        }

                        @Override
                        public IPersistableElement getPersistable() {
                            return null;
                        }
                    };
                    return input;
                }
            };
            branchAction.selectionChanged(null, (ISelection)new StructuredSelection((Object)branch));
            branchAction.run(null);
        }
    }

    private void runDiffAction(final DepotPathMapping depotMapping, final IP4Folder left, final IP4Folder right) {
        DiffFoldersAction action = new DiffFoldersAction(){

            @Override
            protected IFolderDiffInput generateInput(IP4Folder folder1, IP4Folder folder2) {
                IDiffConfiguration leftConfig = DiffMappingAction.this.createBranchConfiguration(depotMapping.getSource());
                IDiffConfiguration rightConfig = DiffMappingAction.this.createBranchConfiguration(depotMapping.getTarget());
                IDiffConfiguration headerConfig = DiffMappingAction.this.createHeaderConfiguration((Mapping)depotMapping);
                FolderDiffInput input = new FolderDiffInput(left.getConnection(), leftConfig, rightConfig, headerConfig){

                    @Override
                    public boolean exists() {
                        return false;
                    }

                    @Override
                    public IPersistableElement getPersistable() {
                        return null;
                    }
                };
                input.addPaths(left.getActionPath(), right.getActionPath());
                return input;
            }
        };
        action.selectionChanged(null, (ISelection)new StructuredSelection(new Object[]{left, right}));
        action.run(null);
    }

    private String getPath(String actionPath) {
        if (actionPath.endsWith("/...")) {
            return actionPath.substring(0, actionPath.length() - "/...".length());
        }
        return actionPath;
    }
}

