/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.folder.diff.actions;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Folder;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.folder.diff.actions.Messages;
import com.perforce.team.ui.folder.diff.editor.input.FolderDiffInput;
import com.perforce.team.ui.folder.diff.editor.input.IFolderDiffInput;
import com.perforce.team.ui.p4java.actions.P4Action;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class DiffFoldersAction
extends P4Action {
    protected boolean isEnabledEx() throws TeamException {
        P4Collection collection = this.getResourceSelection();
        return collection.size() == 1 || collection.size() == 2;
    }

    protected IP4Folder[] getFolders() {
        IP4Resource[] resources = this.getResourceSelection().members();
        if (resources.length == 1 && resources[0] instanceof IP4Folder) {
            IP4Folder folder = (IP4Folder)resources[0];
            return new IP4Folder[]{folder, folder};
        }
        if (resources.length == 2 && resources[0] instanceof IP4Folder && resources[1] instanceof IP4Folder && resources[0].getConnection().equals(resources[1].getConnection())) {
            return new IP4Folder[]{(IP4Folder)resources[0], (IP4Folder)resources[1]};
        }
        return null;
    }

    protected void runAction() {
        final IP4Folder[] folders = this.getFolders();
        if (folders != null) {
            P4Runnable runnable = new P4Runnable(){

                public void run(IProgressMonitor monitor) {
                    DiffFoldersAction.this.compareFolders(folders[0], folders[1]);
                }

                public String getTitle() {
                    return Messages.DiffFoldersAction_OpeningEditor;
                }
            };
            this.runRunnable((IP4Runnable)runnable);
        }
    }

    protected IFolderDiffInput generateInput(IP4Folder folder1, IP4Folder folder2) {
        String action2;
        String action1 = folder1.getActionPath();
        if (action1.compareToIgnoreCase(action2 = folder2.getActionPath()) > 0) {
            String temp = action1;
            action1 = action2;
            action2 = temp;
        }
        FolderDiffInput input = new FolderDiffInput(folder1.getConnection());
        input.addPaths(action1, action2);
        return input;
    }

    protected void compareFolders(IP4Folder folder1, IP4Folder folder2) {
        IFolderDiffInput input;
        if (!folder1.getConnection().isOffline() && (input = this.generateInput(folder1, folder2)) != null) {
            PerforceUIPlugin.syncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        IDE.openEditor((IWorkbenchPage)PerforceUIPlugin.getActivePage(), (IEditorInput)input, (String)"com.perforce.team.ui.editors.folderdiff");
                    }
                    catch (PartInitException e) {
                        PerforceProviderPlugin.logError((Throwable)e);
                    }
                }
            });
        }
    }
}

