/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.folder.diff.actions;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Branch;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.folder.diff.actions.Messages;
import com.perforce.team.ui.folder.diff.editor.input.BranchDiffInput;
import com.perforce.team.ui.folder.diff.editor.input.IFolderDiffInput;
import com.perforce.team.ui.p4java.actions.P4Action;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.UIJob;

public class DiffBranchAction
extends P4Action {
    protected void runAction() {
        IP4Resource resource = this.getSingleOnlineResourceSelection();
        if (resource instanceof IP4Branch) {
            final IP4Branch branch = (IP4Branch)resource;
            P4Runnable runnable = new P4Runnable(){

                public String getTitle() {
                    return Messages.DiffBranchAction_OpeningBranchDiff;
                }

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask("", 1);
                    monitor.subTask(Messages.DiffBranchAction_OpeningDiffEditor);
                    new UIJob(Messages.DiffBranchAction_OpeningDiffEditor){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            IFolderDiffInput input = DiffBranchAction.this.generateInput(branch);
                            try {
                                IDE.openEditor((IWorkbenchPage)PerforceUIPlugin.getActivePage(), (IEditorInput)input, (String)"com.perforce.team.ui.editors.folderdiff");
                            }
                            catch (PartInitException e) {
                                PerforceProviderPlugin.logError((Throwable)e);
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                    monitor.done();
                }
            };
            this.runRunnable((IP4Runnable)runnable);
        }
    }

    protected IFolderDiffInput generateInput(IP4Branch branch) {
        return new BranchDiffInput(branch.getName(), branch.getConnection());
    }
}

