/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.p4java.builder;

import com.perforce.p4java.core.file.FileSpecBuilder;
import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.team.core.p4java.P4Connection;
import java.util.ArrayList;
import java.util.List;

public class P4FileSpecBuilder {
    public static List<IFileSpec> makeFileSpecList(String[] pathArray) {
        String[] convertedPathArray = null;
        if (pathArray != null) {
            convertedPathArray = new String[pathArray.length];
            int i = 0;
            while (i < pathArray.length) {
                if (pathArray[i] != null) {
                    convertedPathArray[i] = P4Connection.convertDiskLabel(pathArray[i]);
                }
                ++i;
            }
        }
        return FileSpecBuilder.makeFileSpecList(convertedPathArray);
    }

    public static List<IFileSpec> makeFileSpecList(String path) {
        return P4FileSpecBuilder.makeFileSpecList(new String[]{path});
    }

    public static List<IFileSpec> getValidFileSpecs(List<IFileSpec> fileSpecs) {
        return FileSpecBuilder.getValidFileSpecs(fileSpecs);
    }

    public static List<IFileSpec> getInvalidFileSpecs(List<IFileSpec> fileSpecs) {
        ArrayList<IFileSpec> invalidList = new ArrayList<IFileSpec>();
        if (fileSpecs != null) {
            for (IFileSpec fSpec : fileSpecs) {
                if (fSpec == null || fSpec.getOpStatus() == FileSpecOpStatus.VALID) continue;
                invalidList.add(fSpec);
            }
        }
        return invalidList;
    }
}

