/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.p4java;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.IStream;
import com.perforce.p4java.core.IStreamSummary;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Container;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Stream;
import com.perforce.team.core.p4java.P4Connection;
import com.perforce.team.core.p4java.P4Container;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.eclipse.core.runtime.Assert;

public class P4Stream
extends P4Container
implements IP4Stream {
    private IP4Connection connection;
    private IStreamSummary streamSummary;
    List<IP4Stream> children = new ArrayList<IP4Stream>();

    @Override
    public String getName() {
        return this.getStreamSummary().getName();
    }

    @Override
    public String getLocalPath() {
        return null;
    }

    @Override
    public String getClientPath() {
        return null;
    }

    @Override
    public String getRemotePath() {
        return null;
    }

    @Override
    public String getActionPath() {
        return null;
    }

    @Override
    public String getActionPath(IP4Resource.Type preferredType) {
        return null;
    }

    @Override
    public IP4Container getParent() {
        return null;
    }

    @Override
    public IClient getClient() {
        IClient client = null;
        if (this.connection != null) {
            client = this.connection.getClient();
        }
        return client;
    }

    @Override
    public IP4Connection getConnection() {
        return this.connection;
    }

    @Override
    public void refresh(int depth) {
    }

    @Override
    public void refresh() {
        try {
            this.fetchDetail();
        }
        catch (P4JavaException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isContainer() {
        return false;
    }

    public P4Stream(IP4Connection connection, IStreamSummary streamSummary) {
        Assert.isNotNull((Object)connection);
        Assert.isNotNull((Object)streamSummary);
        this.connection = connection;
        this.streamSummary = streamSummary;
    }

    private P4Stream() {
    }

    @Override
    public boolean needsRefresh() {
        if (this.streamSummary instanceof IStream) {
            return false;
        }
        return super.needsRefresh();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IStreamSummary.class) {
            return this.streamSummary;
        }
        if (adapter == IStream.class) {
            if (this.streamSummary instanceof IStream) {
                return this.streamSummary;
            }
            if (this.streamSummary != null) {
                try {
                    return this.fetchDetail();
                }
                catch (P4JavaException e) {
                    e.printStackTrace();
                }
            }
        } else if (adapter == IP4Stream.class) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    @Override
    public IStreamSummary getStreamSummary() {
        return this.streamSummary;
    }

    @Override
    public IStream fetchDetail() throws P4JavaException {
        this.streamSummary = this.connection.getStreamSummary(this.streamSummary.getStream());
        return (IStream)this.streamSummary;
    }

    @Override
    public List<String> getClientView() {
        return this.connection.getStreamViewMapping(this.streamSummary.getStream());
    }

    @Override
    public boolean equals(Object obj) {
        boolean eq = super.equals(obj);
        if (!eq && obj != null && obj instanceof IP4Stream) {
            IStreamSummary sum = ((IP4Stream)obj).getStreamSummary();
            IP4Connection conn = ((IP4Stream)obj).getConnection();
            if (P4Connection.testEqual(conn, this.getConnection())) {
                if (sum == this.getStreamSummary()) {
                    return true;
                }
                if (sum != null && this.getStreamSummary() != null) {
                    return sum.getStream().equals(this.getStreamSummary().getStream());
                }
            }
        }
        return eq;
    }

    @Override
    public int hashCode() {
        String streamId;
        StringBuilder sb = new StringBuilder();
        if (this.getConnection() != null) {
            sb.append(this.getConnection().getName());
        }
        if (this.getStreamSummary() != null && (streamId = this.getStreamSummary().getStream()) != null && sb.length() > 0) {
            sb.append(streamId);
            return sb.toString().hashCode();
        }
        return super.hashCode();
    }

    public static boolean testEquals(IP4Stream s1, IP4Stream s2) {
        return EqualsBuilder.reflectionEquals((Object)s1, (Object)s2, (String[])new String[0]);
    }

    public static String toString(String indent, IP4Stream stream) {
        IStreamSummary summary = stream.getStreamSummary();
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(indent) + "stream=" + (summary != null ? summary.getStream() : null) + "\n");
        String DELTA = "  ";
        IP4Resource[] iP4ResourceArray = stream.members();
        int n = iP4ResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Resource child = iP4ResourceArray[n2];
            Assert.isTrue((boolean)(child instanceof IP4Stream));
            sb.append(P4Stream.toString(String.valueOf(indent) + "  ", (IP4Stream)child));
            ++n2;
        }
        return sb.toString();
    }

    @Override
    public IP4Resource[] members() {
        return this.getChildren().toArray(new P4Stream[0]);
    }

    @Override
    public List<IP4Stream> getChildren() {
        return this.children;
    }

    public static VirturalRoot constructTree(List<IP4Stream> summaries, StreamCache cache) {
        VirturalRoot root = new VirturalRoot();
        for (IP4Stream sum : summaries) {
            P4Stream.constructTreeNode(sum, cache, root);
        }
        return root;
    }

    private static IP4Stream constructTreeNode(IP4Stream sum, StreamCache cache, VirturalRoot root) {
        String pstream = sum.getStreamSummary().getParent();
        String stream = sum.getStreamSummary().getStream();
        IP4Stream p = cache.get(sum.getConnection(), pstream);
        IP4Stream node = null;
        IP4Stream pnode = root;
        if (p != null) {
            pnode = P4Stream.constructTreeNode(p, cache, root);
        }
        if ((node = root.get(stream)) == null) {
            node = new P4Stream(sum.getConnection(), sum.getStreamSummary());
            pnode.getChildren().add(node);
            root.put(stream, node);
        }
        return node;
    }

    /* synthetic */ P4Stream(P4Stream p4Stream) {
        this();
    }

    public static class StreamCache {
        private Map<IP4Connection, Map<String, IP4Stream>> cache = Collections.synchronizedMap(new HashMap());

        public void clear(IP4Connection connection) {
            Map<String, IP4Stream> map;
            if (connection != null && (map = this.cache.remove(connection)) != null) {
                map.clear();
            }
        }

        public void add(IP4Connection connection, List<IP4Stream> streams) {
            Map<String, IP4Stream> map = this.cache.get(connection);
            if (map == null) {
                map = new HashMap<String, IP4Stream>();
                this.cache.put(connection, map);
            }
            for (IP4Stream sum : streams) {
                map.put(sum.getStreamSummary().getStream(), sum);
            }
        }

        public void add(IP4Stream sum) {
            Map<String, IP4Stream> map = this.cache.get(sum.getConnection());
            if (map == null) {
                map = new HashMap<String, IP4Stream>();
                this.cache.put(sum.getConnection(), map);
            }
            map.put(sum.getStreamSummary().getStream(), sum);
        }

        public IP4Stream get(IP4Connection connection, String streamId) {
            Map<String, IP4Stream> map = this.cache.get(connection);
            if (map != null) {
                return map.get(streamId);
            }
            return null;
        }

        public IP4Stream[] getSummaries(IP4Connection connection) {
            return this.cache.get(connection).values().toArray(new IP4Stream[0]);
        }

        public boolean isEmpty(IP4Connection conn) {
            Map<String, IP4Stream> map = this.cache.get(conn);
            return map == null || map.isEmpty();
        }
    }

    public static class VirturalRoot
    extends P4Stream {
        Map<String, IP4Stream> map = new HashMap<String, IP4Stream>();

        public VirturalRoot() {
            super(null);
        }

        public void clear() {
            this.map.clear();
        }

        public IP4Stream get(String stream) {
            return this.map.get(stream);
        }

        public void put(String stream, IP4Stream node) {
            this.map.put(stream, node);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof VirturalRoot && super.equals(obj);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }
}

