/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.p4java;

import com.perforce.p4java.core.file.FileAction;
import com.perforce.p4java.core.file.IFileRevisionData;
import com.perforce.p4java.core.file.IRevisionIntegrationData;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Revision;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileRevision;

public class P4Revision
extends FileRevision
implements IP4Revision {
    private IP4Connection connection;
    private IFileRevisionData data;

    public P4Revision(IP4Connection connection, IFileRevisionData data) {
        this.connection = connection;
        this.data = data;
    }

    public String getAuthor() {
        return this.data.getUserName();
    }

    public String getComment() {
        return this.data.getDescription();
    }

    public String getContentIdentifier() {
        return String.valueOf(this.getRemotePath()) + "#" + this.data.getRevision();
    }

    public long getTimestamp() {
        return this.data.getDate().getTime();
    }

    public String getName() {
        String path = this.getRemotePath();
        if (path != null) {
            int index = path.lastIndexOf(47);
            return path.substring(index + 1);
        }
        return null;
    }

    public IStorage getStorage(IProgressMonitor monitor) throws CoreException {
        return new IStorage(){

            public Object getAdapter(Class adapter) {
                return null;
            }

            public boolean isReadOnly() {
                return true;
            }

            public String getName() {
                return P4Revision.this.getName();
            }

            public IPath getFullPath() {
                return null;
            }

            public InputStream getContents() throws CoreException {
                IP4File file = P4Revision.this.connection.getFile(P4Revision.this.getRemotePath());
                if (file != null) {
                    return file.getRemoteContents(P4Revision.this.getRevision());
                }
                return null;
            }
        };
    }

    public boolean isPropertyMissing() {
        return false;
    }

    public IFileRevision withAllProperties(IProgressMonitor monitor) throws CoreException {
        return null;
    }

    @Override
    public int getChangelist() {
        return this.data.getChangelistId();
    }

    @Override
    public FileAction getAction() {
        return this.data.getAction();
    }

    @Override
    public String getRemotePath() {
        return this.data.getDepotFileName();
    }

    @Override
    public String getType() {
        return this.data.getFileType();
    }

    @Override
    public int getRevision() {
        return this.data.getRevision();
    }

    @Override
    public IRevisionIntegrationData[] getIntegrationData() {
        List integs = this.data.getRevisionIntegrationData();
        if (integs != null) {
            return integs.toArray(new IRevisionIntegrationData[integs.size()]);
        }
        return new IRevisionIntegrationData[0];
    }

    @Override
    public String getClient() {
        return this.data.getClientName();
    }

    @Override
    public String getCharset() {
        return this.connection.getParameters().getCharsetNoNone();
    }

    @Override
    public int compareTo(IP4Revision revision) {
        if (this.getChangelist() > 0) {
            return this.getChangelist() - revision.getChangelist();
        }
        return this.getRevision() - revision.getRevision();
    }

    @Override
    public IP4Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean isModifiedByOwner() {
        return this.connection.isOwner(this.getAuthor());
    }

    public boolean equals(Object obj) {
        return obj instanceof P4Revision && P4CoreUtils.equals(this.connection, ((P4Revision)obj).getConnection()) && this.getRevision() == ((P4Revision)obj).getRevision();
    }

    public int hashCode() {
        int hash = 0;
        hash += P4CoreUtils.hashCode(this.connection);
        if ((hash += this.getRevision() * 31) > 0) {
            return hash;
        }
        return super.hashCode();
    }
}

