/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.p4java;

import com.perforce.p4java.impl.generic.sys.ISystemFileCommandsHelper;
import java.io.File;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;

public class P4JavaSysFileCommandsHelper
implements ISystemFileCommandsHelper {
    public static final int ATTRIBUTE_SYMLINK = 32;

    public boolean canExecute(String fileName) {
        IFileStore lfNative = EFS.getLocalFileSystem().fromLocalFile(new File(fileName));
        IFileInfo info = lfNative.fetchInfo();
        return info != null && info.getAttribute(4);
    }

    public boolean setExecutable(String fileName, boolean executable, boolean ownerOnly) {
        IFileStore lfNative = EFS.getLocalFileSystem().fromLocalFile(new File(fileName));
        IFileInfo info = lfNative.fetchInfo();
        boolean set = false;
        if (info != null) {
            info.setAttribute(4, executable);
            try {
                lfNative.putInfo(info, 1024, null);
            }
            catch (CoreException e) {
                set = false;
            }
            set = true;
        }
        return set;
    }

    public boolean setWritable(String fileName, boolean writable) {
        String os = Platform.getOS();
        if (os.toLowerCase().contains("solaris")) {
            new File(fileName).setWritable(writable);
        }
        IFileStore lfNative = EFS.getLocalFileSystem().fromLocalFile(new File(fileName));
        IFileInfo info = lfNative.fetchInfo();
        boolean set = false;
        if (info != null) {
            info.setAttribute(2, !writable);
            try {
                lfNative.putInfo(info, 1024, null);
            }
            catch (CoreException e) {
                set = false;
            }
            set = true;
        }
        return set;
    }

    public boolean isSymlink(String fileName) {
        IFileStore lfNative = EFS.getLocalFileSystem().fromLocalFile(new File(fileName));
        IFileInfo info = lfNative.fetchInfo();
        return info != null && info.getAttribute(32);
    }

    public boolean setReadable(String fileName, boolean readable, boolean ownerOnly) {
        IFileStore lfNative = EFS.getLocalFileSystem().fromLocalFile(new File(fileName));
        IFileInfo info = lfNative.fetchInfo();
        boolean set = false;
        if (info != null) {
            info.setAttribute(2, readable);
            try {
                lfNative.putInfo(info, 1024, null);
            }
            catch (CoreException e) {
                set = false;
            }
            set = true;
        }
        return set;
    }

    public boolean setOwnerReadOnly(String fileName) {
        return false;
    }
}

