/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.p4java;

import com.perforce.p4java.core.file.FileAction;
import com.perforce.p4java.core.file.IFileRevisionData;
import com.perforce.p4java.core.file.IRevisionIntegrationData;
import com.perforce.team.core.p4java.IP4ChangelistRevision;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Revision;
import com.perforce.team.core.p4java.Messages;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileRevision;

public class P4ChangelistRevision
extends FileRevision
implements IP4ChangelistRevision {
    private IP4Connection connection;
    private Map<String, IFileRevisionData> files;
    private int id = -1;
    private long time = -1L;
    private String client;
    private String user;
    private String description;

    public P4ChangelistRevision(IP4Connection connection) {
        this.connection = connection;
        this.files = new HashMap<String, IFileRevisionData>();
    }

    public void add(IFileRevisionData data) {
        if (data != null) {
            this.files.put(data.getDepotFileName(), data);
            this.client = data.getClientName();
            this.user = data.getUserName();
            this.id = data.getChangelistId();
            this.description = data.getDescription();
            this.time = data.getDate().getTime();
        }
    }

    public long getTimestamp() {
        return this.time;
    }

    @Override
    public FileAction getAction() {
        return null;
    }

    @Override
    public int getChangelist() {
        return this.id;
    }

    @Override
    public String getCharset() {
        return this.connection.getParameters().getCharset();
    }

    @Override
    public String getClient() {
        return this.client;
    }

    @Override
    public IP4Connection getConnection() {
        return this.connection;
    }

    @Override
    public IRevisionIntegrationData[] getIntegrationData() {
        return null;
    }

    @Override
    public String getRemotePath() {
        return null;
    }

    @Override
    public int getRevision() {
        return 0;
    }

    public String getAuthor() {
        return this.user;
    }

    @Override
    public String getType() {
        return "";
    }

    @Override
    public boolean isModifiedByOwner() {
        return this.connection.isOwner(this.getAuthor());
    }

    public String getName() {
        return "";
    }

    public String getComment() {
        return this.description;
    }

    public IStorage getStorage(IProgressMonitor monitor) throws CoreException {
        return null;
    }

    public boolean isPropertyMissing() {
        return false;
    }

    public IFileRevision withAllProperties(IProgressMonitor monitor) throws CoreException {
        return null;
    }

    @Override
    public int compareTo(IP4Revision revision) {
        return this.getChangelist() - revision.getChangelist();
    }

    public String getContentIdentifier() {
        return MessageFormat.format(Messages.P4ChangelistRevision_0, this.getChangelist());
    }

    @Override
    public IFileRevisionData[] getRevisions() {
        return this.files.values().toArray(new IFileRevisionData[this.files.size()]);
    }

    public boolean equals(Object obj) {
        return obj instanceof P4ChangelistRevision && this.connection.equals(((P4ChangelistRevision)obj).getConnection()) && this.getChangelist() == ((P4ChangelistRevision)obj).getChangelist();
    }

    public int hashCode() {
        int hash = 0;
        if (this.connection != null) {
            hash += this.connection.hashCode();
        }
        if (this.getChangelist() > 0) {
            hash += this.getChangelist() * 31;
        }
        if (hash > 0) {
            return hash;
        }
        return super.hashCode();
    }
}

