/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core;

import com.perforce.team.core.Policy;
import java.text.MessageFormat;
import java.util.Calendar;

public final class Tracing {
    public static final String SEPARATOR = " >>> ";

    public static String getTimestamp() {
        String timestamp = "";
        Calendar cal = Calendar.getInstance();
        timestamp = String.format("%1$tI:%1$tM:%1$tS:%1$tL %1$tp ", cal).toUpperCase();
        return timestamp;
    }

    public static final void printTrace(boolean debug, String component, String message) {
        if (debug) {
            String output = Tracing.constructMessage(component, message);
            System.out.println("TRACE " + output);
        }
    }

    public static final void printTrace(String component, String message) {
        Tracing.printTrace(Policy.DEBUG, component, message);
    }

    private static String constructMessage(String component, String message) {
        StringBuffer buffer = new StringBuffer();
        if (component != null) {
            buffer.append(component);
        }
        if (component != null && message != null) {
            buffer.append(SEPARATOR);
        }
        if (message != null) {
            buffer.append(message);
        }
        String output = buffer.toString();
        return output;
    }

    public static final void printExecTime(boolean debug, String component, String message, Runnable runnable) {
        if (debug) {
            String msg = Tracing.constructMessage(component, message);
            long start = System.nanoTime();
            System.out.println(MessageFormat.format("EXEC  START v {0} [{1}]", start, msg));
            runnable.run();
            long end = System.nanoTime();
            System.out.println(MessageFormat.format("EXEC  END   ^ {0} [{1}] time={2}ns", start, msg, end - start));
            System.out.println();
        } else {
            runnable.run();
        }
    }

    public static final void printExecTime2(boolean debug, String component, String message, IRunnable runnable) throws Throwable {
        if (debug) {
            String msg = Tracing.constructMessage(component, message);
            long start = System.nanoTime();
            System.out.println(MessageFormat.format("EXEC  START v {0} [{1}]", start, msg));
            runnable.run();
            long end = System.nanoTime();
            System.out.println(MessageFormat.format("EXEC  END   ^ {0} [{1}] time={2}ns", start, msg, end - start));
            System.out.println();
        } else {
            runnable.run();
        }
    }

    public static final void printExecTime3(boolean debug, String component, String message, IRunnable runnable) {
        try {
            Tracing.printExecTime2(debug, component, message, runnable);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Tracing() {
    }

    public static interface IRunnable {
        public void run() throws Throwable;
    }
}

