/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core;

import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.server.callback.ISSOCallback;
import com.perforce.team.core.IP4JavaCallback;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4CommandListener;
import com.perforce.team.core.p4java.IP4ProgressListener;
import com.perforce.team.core.p4java.P4Workspace;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;

public class P4JavaCallback
implements IP4JavaCallback {
    public static final String SSO_CMD_ENV_KEY = "P4LOGINSSO";
    private ListenerList commandListeners = new ListenerList();
    private ListenerList progressListeners = new ListenerList();
    private String currentCommand = null;

    public void addCommandListener(IP4CommandListener listener) {
        if (listener != null) {
            this.commandListeners.add((Object)listener);
        }
    }

    public void removeCommandListener(IP4CommandListener listener) {
        if (listener != null) {
            this.commandListeners.remove((Object)listener);
        }
    }

    public void addProgressListener(IP4ProgressListener listener) {
        if (listener != null) {
            this.progressListeners.add((Object)listener);
        }
    }

    public void removeProgressListener(IP4ProgressListener listener) {
        if (listener != null) {
            this.progressListeners.remove((Object)listener);
        }
    }

    public boolean startResults(int key) throws P4JavaException {
        Object[] listeners = this.progressListeners.getListeners();
        boolean moveon = true;
        int i = 0;
        while (i < listeners.length) {
            moveon = ((IP4ProgressListener)listeners[i]).startResults(key);
            if (!moveon) break;
            ++i;
        }
        return moveon;
    }

    public boolean endResults(int key) throws P4JavaException {
        Object[] listeners = this.progressListeners.getListeners();
        boolean moveon = true;
        int i = 0;
        while (i < listeners.length) {
            moveon = ((IP4ProgressListener)listeners[i]).endResults(key);
            if (!moveon) break;
            ++i;
        }
        return moveon;
    }

    public boolean handleResult(Map<String, Object> resultMap, int key) throws P4JavaException {
        Object[] listeners = this.progressListeners.getListeners();
        boolean moveon = true;
        int i = 0;
        while (i < listeners.length) {
            moveon = ((IP4ProgressListener)listeners[i]).handleResult(resultMap, key);
            if (!moveon) break;
            ++i;
        }
        return moveon;
    }

    public void issuingServerCommand(int key, String commandString) {
        if (commandString == null) {
            return;
        }
        this.currentCommand = commandString;
        Object[] listeners = this.commandListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IP4CommandListener)listeners[i]).command(key, this.currentCommand);
            ++i;
        }
    }

    public void completedServerCommand(int key, long millisecsTaken) {
        this.currentCommand = null;
    }

    public void receivedServerErrorLine(int key, String errorLine) {
        if (errorLine == null) {
            return;
        }
        Object[] listeners = this.commandListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IP4CommandListener)listeners[i]).error(key, errorLine);
            ++i;
        }
    }

    public void receivedServerInfoLine(int key, String infoLine) {
        if (infoLine == null) {
            return;
        }
        Object[] listeners = this.commandListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IP4CommandListener)listeners[i]).info(key, infoLine);
            ++i;
        }
    }

    public void receivedServerMessage(int key, int genericCode, int severityCode, String message) {
        if (message == null) {
            return;
        }
        if (2 == severityCode) {
            Object[] listeners = this.commandListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IP4CommandListener)listeners[i]).info(key, message);
                ++i;
            }
        }
    }

    private void stripTrailingNewline(StringBuffer buffer) {
        int length = buffer.length();
        if (length > 0 && buffer.charAt(length - 1) == '\n') {
            buffer.deleteCharAt(length - 1);
        }
        if ((length = buffer.length()) > 0 && buffer.charAt(length - 1) == '\r') {
            buffer.deleteCharAt(length - 1);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ISSOCallback.Status getSSOCredentials(StringBuffer credBuffer, String ssoKey, String userName) {
        String USER = "%user%";
        String SERVER_ADDRESS = "%serverAddress%";
        ISSOCallback.Status status = ISSOCallback.Status.UNSET;
        if (credBuffer == null) {
            throw new NullPointerException("null credBuffer passed to SSO callback");
        }
        String execCmd = System.getenv(SSO_CMD_ENV_KEY);
        if (execCmd == null) {
            execCmd = P4Workspace.getWorkspace().getAdvancedProperties().getProperty(SSO_CMD_ENV_KEY);
        }
        if (execCmd != null && execCmd.length() > 0) {
            boolean hasServer;
            boolean hasUser = execCmd.contains("%user%");
            if (hasUser && userName != null) {
                execCmd = execCmd.replaceAll("%user%", userName);
            }
            if ((hasServer = execCmd.contains("%serverAddress%")) && ssoKey != null) {
                execCmd = execCmd.replaceAll("%serverAddress%", ssoKey);
            }
            ArrayList<String> cmdList = new ArrayList<String>();
            String[] args = execCmd.split(" ");
            int i = 0;
            while (i < args.length) {
                cmdList.add(args[i]);
                ++i;
            }
            if (userName != null) {
                cmdList.add(userName);
            }
            if (ssoKey != null) {
                cmdList.add(ssoKey);
            }
            ProcessBuilder processBuilder = new ProcessBuilder(cmdList);
            Process proc = null;
            InputStream inStream = null;
            int exitCode = 0;
            try {
                try {
                    proc = processBuilder.start();
                    inStream = proc.getInputStream();
                    int bytesRead = 0;
                    byte[] bytes = new byte[1024];
                    while ((bytesRead = inStream.read(bytes)) >= 0) {
                        credBuffer.append(new String(bytes, 0, bytesRead, Charset.defaultCharset()));
                    }
                    this.stripTrailingNewline(credBuffer);
                    exitCode = proc.waitFor();
                    status = exitCode == 0 ? ISSOCallback.Status.PASS : ISSOCallback.Status.FAIL;
                    return status;
                }
                catch (IOException exc) {
                    PerforceProviderPlugin.logError("Error running P4LOGINSSO executable", exc);
                    status = ISSOCallback.Status.PASS;
                    if (inStream == null) return status;
                    try {
                        inStream.close();
                        return status;
                    }
                    catch (IOException iOException) {}
                    return status;
                }
                catch (InterruptedException exc) {
                    PerforceProviderPlugin.logError("Error running P4LOGINSSO executable", exc);
                    status = ISSOCallback.Status.PASS;
                    if (inStream == null) return status;
                    try {
                        inStream.close();
                        return status;
                    }
                    catch (IOException iOException) {}
                    return status;
                }
            }
            finally {
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        PerforceProviderPlugin.logError("SSO login not attempted because P4LOGINSSO is not a set environment variable");
        return status;
    }
}

