/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.client.IClientViewMapping;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.impl.generic.client.ClientView;
import com.perforce.team.core.P4LogUtils;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class P4ClientUtil {
    public static boolean isViewMappingChanged(ClientView oldView, ClientView newView) {
        boolean mappingChanged = false;
        if (oldView != newView) {
            IClientViewMapping[] oldMappings = null;
            IClientViewMapping[] newMappings = null;
            IClientViewMapping[] EMPTY = new IClientViewMapping[]{};
            if (oldView != null) {
                oldMappings = oldView.getEntryList().toArray(EMPTY);
            }
            if (newView != null) {
                newMappings = newView.getEntryList().toArray(EMPTY);
            }
            if (oldMappings == null) {
                oldMappings = EMPTY;
            }
            if (newMappings == null) {
                newMappings = EMPTY;
            }
            if (oldMappings != newMappings) {
                if (oldMappings.length != newMappings.length) {
                    mappingChanged = true;
                } else {
                    int i = 0;
                    while (i < oldMappings.length) {
                        IClientViewMapping om = oldMappings[i];
                        IClientViewMapping nm = newMappings[i];
                        if (om != nm) {
                            if (om == null || nm == null) {
                                mappingChanged = true;
                                break;
                            }
                            if (!om.getLeft().equals(nm.getLeft()) || !om.getRight().equals(nm.getRight()) || om.getType() != nm.getType()) {
                                mappingChanged = true;
                                break;
                            }
                        }
                        ++i;
                    }
                }
            }
        }
        return mappingChanged;
    }

    public static boolean isRootDiff(String oldRoot, String newRoot) {
        boolean rootChanged = false;
        if (oldRoot != null || newRoot != null) {
            rootChanged = oldRoot != null ? !oldRoot.equals(newRoot) : !newRoot.equals(oldRoot);
        }
        return rootChanged;
    }

    public static boolean isAtChangeDiff(int oldAtChange, int newAtChange) {
        return oldAtChange != newAtChange;
    }

    public static boolean isStreamDifferent(String oldStream, String newStream) {
        if (StringUtils.isEmpty((CharSequence)oldStream) && StringUtils.isEmpty((CharSequence)newStream)) {
            return false;
        }
        boolean streamChanged = false;
        if (oldStream != null || newStream != null) {
            streamChanged = oldStream != null ? !oldStream.equals(newStream) : !newStream.equals(oldStream);
        }
        return streamChanged;
    }

    public static boolean shouldSyncClient(IClient oldClient, IClient newClient) {
        String oldStream = oldClient.getStream();
        String newStream = newClient.getStream();
        int oldAtChange = oldClient.getStreamAtChange();
        int newAtChange = newClient.getStreamAtChange();
        String oldRoot = oldClient.getRoot();
        String newRoot = newClient.getRoot();
        ClientView oldView = oldClient.getClientView();
        ClientView newView = newClient.getClientView();
        boolean streamChanged = P4ClientUtil.isStreamDifferent(oldStream, newStream);
        boolean atChangeChanged = P4ClientUtil.isAtChangeDiff(oldAtChange, newAtChange);
        boolean rootChanged = P4ClientUtil.isRootDiff(oldRoot, newRoot);
        boolean mappingChanged = P4ClientUtil.isViewMappingChanged(oldView, newView);
        return rootChanged || streamChanged || atChangeChanged || mappingChanged;
    }

    public static boolean isClientChanged(IClient oldSpec, IClient newSpec) {
        List altRootsNew;
        if (oldSpec == newSpec) {
            return false;
        }
        if (oldSpec == null || newSpec == null) {
            return true;
        }
        if (!P4LogUtils.testEquals(oldSpec.getName(), newSpec.getName())) {
            return true;
        }
        if (!P4LogUtils.testEquals(oldSpec.getHostName(), newSpec.getHostName())) {
            return true;
        }
        if (!P4LogUtils.testEquals(oldSpec.getDescription(), newSpec.getDescription())) {
            return true;
        }
        if (!P4LogUtils.testEquals(oldSpec.getOwnerName(), newSpec.getOwnerName())) {
            return true;
        }
        if (!P4LogUtils.reflectiveEquals(oldSpec.getSubmitOptions(), newSpec.getSubmitOptions())) {
            return true;
        }
        if (!P4LogUtils.reflectiveEquals(oldSpec.getLineEnd(), newSpec.getLineEnd())) {
            return true;
        }
        List altRootsOld = oldSpec.getAlternateRoots();
        if (!P4LogUtils.reflectiveEquals(altRootsOld, altRootsNew = newSpec.getAlternateRoots())) {
            return true;
        }
        if (P4ClientUtil.isStreamDifferent(oldSpec.getStream(), newSpec.getStream())) {
            return newSpec.getClientView() == null || !newSpec.getClientView().getEntryList().isEmpty() || !StringUtils.isEmpty((CharSequence)newSpec.getStream());
        }
        if (P4ClientUtil.isRootDiff(oldSpec.getRoot(), newSpec.getRoot())) {
            return true;
        }
        if (P4ClientUtil.isAtChangeDiff(oldSpec.getStreamAtChange(), newSpec.getStreamAtChange())) {
            return true;
        }
        if (StringUtils.isEmpty((CharSequence)oldSpec.getStream()) && StringUtils.isEmpty((CharSequence)newSpec.getStream()) && P4ClientUtil.isViewMappingChanged(oldSpec.getClientView(), newSpec.getClientView())) {
            return true;
        }
        if (!P4LogUtils.reflectiveEquals(oldSpec.getOptions(), newSpec.getOptions())) {
            return true;
        }
        if (!P4LogUtils.testEquals(oldSpec.getServerId(), newSpec.getServerId())) {
            return true;
        }
        if (StringUtils.isEmpty((CharSequence)newSpec.getStream()) && newSpec.getClientView().getEntryList() != null && newSpec.getClientView().getEntryList().isEmpty()) {
            return false;
        }
        return false;
    }

    public static String computeTheirRev(IFileSpec spec) {
        String toRev = "#" + Math.max(1, spec.getEndFromRev());
        int shelvedChange = spec.getShelvedChange();
        if (P4ClientUtil.isResolveShelvedChange(spec)) {
            toRev = "@=" + shelvedChange;
        }
        return toRev;
    }

    public static boolean isResolveShelvedChange(IFileSpec spec) {
        String fromFile = spec.getFromFile();
        String baseFile = P4ClientUtil.getBaseFile(spec);
        int shelvedChange = spec.getShelvedChange();
        return !StringUtils.isEmpty((CharSequence)fromFile) && !StringUtils.isEmpty((CharSequence)baseFile) && fromFile.equals(baseFile) && -1 != shelvedChange;
    }

    public static int getBaseRev(IFileSpec integSpec) {
        int baseRev = integSpec.getBaseRev();
        if (baseRev != -1) {
            return baseRev;
        }
        baseRev = integSpec.getStartFromRev();
        baseRev = baseRev > 0 ? --baseRev : 0;
        return baseRev;
    }

    public static String getBaseFile(IFileSpec integSpec) {
        return integSpec.getBaseFile() != null ? integSpec.getBaseFile() : integSpec.getFromFile();
    }
}

