/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core;

import com.perforce.p4java.CharsetDefs;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.PerforceCharsets;
import com.perforce.team.core.P4SecureStore;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import java.nio.charset.Charset;
import java.util.StringTokenizer;
import org.eclipse.equinox.security.storage.StorageException;

public class ConnectionParameters {
    public static final String P4PORT = "P4PORT";
    public static final String P4CLIENT = "P4CLIENT";
    public static final String P4USER = "P4USER";
    public static final String P4CHARSET = "P4CHARSET";
    public static final String P4PASSWD = "P4PASSWD";
    public static final String SAVEPASS = "SAVEPASS";
    public static final String OFFLINE = "OFFLINE";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String IGNORE_SSL = "IGNORE_SSL";
    private String port;
    private String client;
    private String user;
    private String charset;
    private String password;
    private String authTicket = null;
    private boolean savePassword = false;
    private boolean ignoreSSLValidation = false;
    private boolean offline = false;

    public ConnectionParameters() {
    }

    public ConnectionParameters(String connectString) {
        StringTokenizer tokens = new StringTokenizer(connectString, " ");
        while (tokens.hasMoreTokens()) {
            String key = tokens.nextToken();
            String value = this.unescapeSpaces(tokens.nextToken());
            if (P4PORT.equals(key)) {
                this.setPort(value);
                continue;
            }
            if (P4CLIENT.equals(key)) {
                this.setClient(value);
                continue;
            }
            if (P4USER.equals(key)) {
                this.setUser(value);
                continue;
            }
            if (P4CHARSET.equals(key)) {
                this.setCharset(value);
                continue;
            }
            if (P4PASSWD.equals(key)) {
                this.setPassword(value);
                continue;
            }
            if (IGNORE_SSL.equals(key)) {
                this.setIgnoreSSLValidation(Boolean.parseBoolean(value));
                continue;
            }
            if (SAVEPASS.equals(key)) {
                if (TRUE.equals(value)) {
                    this.savePassword = true;
                    continue;
                }
                this.savePassword = false;
                continue;
            }
            if (!OFFLINE.equals(key)) continue;
            this.offline = TRUE.equals(value);
        }
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    public void setIgnoreSSLValidation(boolean ignoreSSL) {
        this.ignoreSSLValidation = ignoreSSL;
    }

    public boolean isIgnoreSSLValidation() {
        return this.ignoreSSLValidation;
    }

    public void setSavePassword(boolean savePassword) {
        this.savePassword = savePassword;
    }

    public boolean savePassword() {
        return this.savePassword;
    }

    public void setPort(String port) {
        this.port = this.checkValue(port);
    }

    public String getPort() {
        return this.port;
    }

    public String getPortNoNull() {
        return this.port == null ? "" : this.port;
    }

    public void setClient(String client) {
        this.client = this.checkValue(client);
    }

    public String getClient() {
        return this.client;
    }

    public String getClientNoNull() {
        return this.client == null ? "" : this.client;
    }

    public void setUser(String user) {
        this.user = this.checkValue(user);
    }

    public String getUser() {
        return this.user;
    }

    public String getUserNoNull() {
        return this.user == null ? "" : this.user;
    }

    public void setCharset(String charset) {
        this.charset = this.checkValue(charset);
    }

    public String getCharset() {
        return this.charset;
    }

    public String getCharsetNoNone() {
        if (!"none".equals(this.charset)) {
            return this.charset;
        }
        return null;
    }

    public String getCharsetNoNull() {
        return this.charset == null ? "" : this.charset;
    }

    public void setPassword(String password) {
        this.password = this.checkValue(password);
    }

    public String getPassword() {
        if ((this.password == null || this.password.isEmpty()) && this.savePassword) {
            try {
                this.setPassword(P4SecureStore.INSTANCE.get(this.getStorageKey(), ""));
            }
            catch (StorageException e) {
                PerforceProviderPlugin.logError(e);
            }
        }
        return this.password;
    }

    public String peekPassword() {
        return this.password;
    }

    public String getPasswordNoNull() {
        String pw = this.getPassword();
        return pw == null ? "" : pw;
    }

    public String getAuthTicket() {
        return this.authTicket;
    }

    public void setAuthTicket(String authTicket) {
        this.authTicket = authTicket;
    }

    private String checkValue(String value) {
        if (value != null && (value = value.trim()).equals("")) {
            value = null;
        }
        return value;
    }

    public String getDisplayString() {
        StringBuilder display = new StringBuilder(this.getPortNoNull());
        display.append(',');
        display.append(' ');
        display.append(this.getClientNoNull());
        display.append(',');
        display.append(' ');
        display.append(this.getUserNoNull());
        String charset = this.getCharsetNoNone();
        if (charset != null) {
            display.append(',');
            display.append(' ');
            display.append(charset);
        }
        return display.toString();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.port != null) {
            s.append("P4PORT " + this.escapeSpaces(this.port) + " ");
        }
        if (this.client != null) {
            s.append("P4CLIENT " + this.escapeSpaces(this.client) + " ");
        }
        if (this.user != null) {
            s.append("P4USER " + this.escapeSpaces(this.user) + " ");
        }
        if (this.charset != null) {
            s.append("P4CHARSET " + this.escapeSpaces(this.charset) + " ");
        }
        s.append("IGNORE_SSL " + Boolean.toString(this.ignoreSSLValidation) + " ");
        s.append("SAVEPASS " + (this.savePassword ? TRUE : FALSE) + " ");
        s.append("OFFLINE " + (this.offline ? TRUE : FALSE) + " ");
        return s.toString();
    }

    public void copy(ConnectionParameters params) {
        params.setPort(this.getPort());
        params.setClient(this.getClient());
        params.setUser(this.getUser());
        params.setCharset(this.getCharset());
        params.setPassword(this.getPassword());
        params.setSavePassword(this.savePassword());
        params.setIgnoreSSLValidation(this.isIgnoreSSLValidation());
        params.setOffline(this.isOffline());
        params.setAuthTicket(this.getAuthTicket());
    }

    public int hashCode() {
        String s = String.valueOf(this.getPortNoNull()) + this.getClientNoNull() + this.getUserNoNull() + this.getCharsetNoNull();
        return s.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ConnectionParameters)) {
            return false;
        }
        ConnectionParameters params = (ConnectionParameters)obj;
        if (!params.getPortNoNull().equals(this.getPortNoNull())) {
            return false;
        }
        if (!params.getClientNoNull().equals(this.getClientNoNull())) {
            return false;
        }
        if (!params.getUserNoNull().equals(this.getUserNoNull())) {
            return false;
        }
        return params.getCharsetNoNull().equals(this.getCharsetNoNull());
    }

    private String escapeSpaces(String s) {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            switch (ch) {
                case ' ': {
                    buff.append("\\s");
                    break;
                }
                case '\\': {
                    buff.append("\\\\");
                    break;
                }
                default: {
                    buff.append(ch);
                }
            }
            ++i;
        }
        return buff.toString();
    }

    private String unescapeSpaces(String s) {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (ch == '\\') {
                if (s.charAt(++i) == '\\') {
                    buff.append('\\');
                } else {
                    buff.append(' ');
                }
            } else {
                buff.append(ch);
            }
            ++i;
        }
        return buff.toString();
    }

    public String getStorageKey() {
        return String.valueOf(this.getUserNoNull()) + "@" + this.getPort();
    }

    public static String getTicketUser(ConnectionParameters param, IServer server) {
        if (server == null) {
            return param.getUserNoNull();
        }
        if (server.isCaseSensitive()) {
            return param.getUserNoNull();
        }
        return param.getUserNoNull().toLowerCase();
    }

    public static Charset getJavaCharset(IP4Resource resource) {
        try {
            IP4Connection conn = resource.getConnection();
            if (conn != null) {
                ConnectionParameters p = conn.getParameters();
                String cs = PerforceCharsets.getJavaCharsetName((String)p.getCharset());
                return Charset.forName(cs);
            }
        }
        catch (Exception e) {
            PerforceProviderPlugin.logWarning(e);
        }
        return CharsetDefs.DEFAULT;
    }
}

