/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.mylyn;

import com.perforce.team.core.ConnectionParameters;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.mylyn.Messages;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.P4Workspace;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class P4MylynUtils {
    private static final DateFormat P4_FORMATTER = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private static final DateFormat MYLYN_FORMATTER = DateFormat.getDateTimeInstance(2, 3);
    private static final SimpleDateFormat COMMENT_FORMATTER1 = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
    public static final String VALUE_REGEX = "([=<>&\\^\\|\\)\\(\\*])";
    public static final String VALUE_REPLACE_REGEX = "\\\\$1";

    public static String escapeJobQueryValue(String value) {
        return value != null ? value.replaceAll(VALUE_REGEX, VALUE_REPLACE_REGEX) : null;
    }

    public static ITask getTask(Object object) {
        return (ITask)P4CoreUtils.convert((Object)object, ITask.class);
    }

    public static synchronized Date parseCommentDate(String date) {
        Date parsed = null;
        if (date != null) {
            try {
                parsed = COMMENT_FORMATTER1.parse(date);
            }
            catch (ParseException parseException) {
                parsed = null;
            }
        }
        return parsed;
    }

    public static synchronized Date parseDate(String date) {
        Date parsed = null;
        if (date != null) {
            try {
                parsed = P4_FORMATTER.parse(date);
            }
            catch (ParseException parseException) {
                parsed = null;
            }
        }
        return parsed;
    }

    public static synchronized String formatToP4Date(Date date) {
        String formatted = null;
        if (date != null) {
            formatted = P4_FORMATTER.format(date);
        }
        return formatted;
    }

    public static synchronized String formatToMylynDate(Date date) {
        String formatted = null;
        if (date != null) {
            formatted = MYLYN_FORMATTER.format(date);
        }
        return formatted;
    }

    public static synchronized String formatCommentDate(Date date) {
        String formatted = null;
        if (date != null) {
            formatted = COMMENT_FORMATTER1.format(date);
        }
        return formatted;
    }

    public static IP4Connection getConnection(TaskRepository repository) {
        IP4Connection connection = null;
        if (repository != null) {
            String client;
            String user;
            String port = repository.getProperty("P4_PORT");
            if (port != null) {
                port = port.trim();
            }
            if ((user = repository.getProperty("P4_USER")) != null) {
                user = user.trim();
            }
            if ((client = repository.getProperty("P4_CLIENT")) != null) {
                client = client.trim();
            }
            if (port != null && port.length() > 0 && user != null && user.length() > 0 && client != null && client.length() > 0) {
                ConnectionParameters params = new ConnectionParameters();
                params.setPort(port);
                params.setUser(user);
                params.setClient(client);
                params.setCharset(repository.getProperty("P4_CHARSET"));
                connection = P4Workspace.getWorkspace().getConnection(params);
            }
        }
        return connection;
    }

    public static IStatus getConnectionErrorStatus() {
        return P4MylynUtils.getErrorStatus(Messages.P4MylynUtils_ConnectionRetrievalFailed);
    }

    public static IStatus getConnectionOfflineStatus() {
        return P4MylynUtils.getErrorStatus(Messages.P4MylynUtils_ConnectionOffline);
    }

    public static IStatus getErrorStatus(String message, Throwable throwable) {
        return new Status(4, "com.perforce.team.core.mylyn", 0, message, throwable);
    }

    public static IStatus getErrorStatus(String message) {
        return P4MylynUtils.getErrorStatus(message, null);
    }
}

