/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.mylyn;

import com.perforce.team.core.mylyn.IP4JobConfiguration;
import com.perforce.team.core.mylyn.JobCache;
import com.perforce.team.core.mylyn.Messages;
import com.perforce.team.core.mylyn.P4JobConfigurationManager;
import com.perforce.team.core.mylyn.P4JobDataHandler;
import com.perforce.team.core.mylyn.P4MylynUtils;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Job;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import java.text.MessageFormat;
import java.util.Date;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.mylyn.commons.core.CoreUtil;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.mylyn.tasks.core.data.TaskMapper;
import org.eclipse.mylyn.tasks.core.sync.ISynchronizationSession;

public class P4JobConnector
extends AbstractRepositoryConnector {
    private P4JobConfigurationManager manager;
    private P4JobDataHandler dataHandler;
    private JobCache jobCache;
    private ISchedulingRule jobCacheRule = P4Runner.createRule();

    public P4JobConnector() {
        this.manager = new P4JobConfigurationManager();
        this.dataHandler = new P4JobDataHandler(this.manager, this);
        this.jobCache = new JobCache();
    }

    public String getTaskIdPrefix() {
        return Messages.P4JobConnector_Job;
    }

    public IP4Job getCachedJob(String id, IP4Connection connection) {
        return this.getCachedJob(id, connection, false, null);
    }

    public IP4Job getCachedJob(String id, IP4Connection connection, boolean load) {
        return this.getCachedJob(id, connection, load, null);
    }

    public IP4Job getCachedJob(final String id, final IP4Connection connection, boolean load, final IJobCallback async) {
        IP4Job job = this.jobCache.get(id, connection);
        if (job == null && id != null && connection != null && load) {
            if (async == null) {
                job = connection.getJob(id);
                this.jobCache.add(job);
            } else {
                P4Runner.schedule((IP4Runnable)new P4Runnable(){

                    public void run(IProgressMonitor monitor) {
                        IP4Job loaded = connection.getJob(id);
                        P4JobConnector.this.jobCache.add(loaded);
                        if (loaded != null) {
                            async.loaded(loaded);
                        }
                    }

                    public String getTitle() {
                        return String.valueOf(Messages.P4JobConnector_LoadingJob) + id;
                    }
                }, (ISchedulingRule)this.jobCacheRule);
            }
        }
        return job;
    }

    public boolean canCreateNewTask(TaskRepository repository) {
        return true;
    }

    public boolean canCreateTaskFromKey(TaskRepository repository) {
        return true;
    }

    public String getConnectorKind() {
        return "perforce";
    }

    public String getLabel() {
        return Messages.P4JobConnector_PerforceJobs;
    }

    public String getRepositoryUrlFromTaskUrl(String taskFullUrl) {
        int index;
        if (taskFullUrl != null && (index = taskFullUrl.lastIndexOf(47)) > 0) {
            return taskFullUrl.substring(0, index);
        }
        return null;
    }

    public String[] getTaskIdsFromComment(TaskRepository repository, String comment) {
        if (comment != null) {
            IP4JobConfiguration config = this.manager.getConfiguration(repository);
            return config.getTaskIdsFromComment(repository, comment);
        }
        return null;
    }

    public TaskData getTaskData(TaskRepository taskRepository, String taskId, IProgressMonitor monitor) throws CoreException {
        IP4Connection connection = P4MylynUtils.getConnection(taskRepository);
        if (connection == null) {
            throw new CoreException(P4MylynUtils.getConnectionErrorStatus());
        }
        try {
            taskId = CoreUtil.decode((String)taskId);
        }
        catch (Throwable throwable) {}
        IP4Job job = connection.getJob(taskId);
        if (job == null) {
            throw new CoreException(P4MylynUtils.getErrorStatus(MessageFormat.format(Messages.P4JobConnector_JobRetrievalFailed, taskId)));
        }
        this.jobCache.add(job);
        return this.dataHandler.generateTaskData(taskRepository, job);
    }

    public String getTaskIdFromTaskUrl(String taskFullUrl) {
        int index;
        if (taskFullUrl != null && (index = taskFullUrl.lastIndexOf(47)) > -1 && index + 1 < taskFullUrl.length()) {
            return taskFullUrl.substring(index + 1);
        }
        return null;
    }

    public String getTaskUrl(String repositoryUrl, String taskId) {
        if (repositoryUrl != null && taskId != null) {
            return String.valueOf(repositoryUrl) + "/" + taskId;
        }
        return null;
    }

    public boolean hasTaskChanged(TaskRepository repository, ITask task, TaskData taskData) {
        boolean changed = true;
        TaskMapper mapper = new TaskMapper(taskData);
        if (taskData.isPartial()) {
            changed = mapper.hasChanges(task);
        } else {
            Date last = task.getModificationDate();
            Date current = mapper.getModificationDate();
            if (last != null && current != null) {
                changed = !last.equals(current);
            }
        }
        return changed;
    }

    public boolean canQuery(TaskRepository repository) {
        IP4Connection connection = P4MylynUtils.getConnection(repository);
        return connection != null && !connection.isOffline();
    }

    public boolean canSynchronizeTask(TaskRepository taskRepository, ITask task) {
        return this.canQuery(taskRepository) && super.canSynchronizeTask(taskRepository, task);
    }

    public IStatus performQuery(TaskRepository repository, IRepositoryQuery query, TaskDataCollector collector, ISynchronizationSession session, IProgressMonitor monitor) {
        IP4Connection connection = P4MylynUtils.getConnection(repository);
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            if (connection == null) {
                IStatus iStatus = P4MylynUtils.getConnectionErrorStatus();
                return iStatus;
            }
            monitor.beginTask(MessageFormat.format(Messages.P4JobConnector_FetchingJobs, connection.getParameters().getPortNoNull()), -1);
            String value = query.getAttribute("P4_JOB_QUERY");
            if (value != null && (value = value.trim()).length() == 0) {
                value = null;
            }
            int max = -1;
            String limit = query.getAttribute("P4_JOB_MAX");
            if (limit != null) {
                try {
                    max = Integer.parseInt(limit);
                    if (max <= 0) {
                        max = -1;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    max = -1;
                }
            }
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            SubProgressMonitor fetchMonitor = new SubProgressMonitor(monitor, 10);
            IP4Job[] jobs = null;
            try {
                fetchMonitor.beginTask("", 1);
                jobs = connection.getJobs(new String[0], max, value);
                fetchMonitor.worked(1);
            }
            finally {
                fetchMonitor.done();
            }
            if (monitor.isCanceled() || connection.isOffline()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            SubProgressMonitor buildMonitor = new SubProgressMonitor(monitor, 10);
            try {
                buildMonitor.beginTask("", jobs.length);
                IP4Job[] iP4JobArray = jobs;
                int n = jobs.length;
                int n2 = 0;
                while (n2 < n) {
                    IP4Job job = iP4JobArray[n2];
                    if (monitor.isCanceled() || connection.isOffline()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    try {
                        this.jobCache.add(job);
                        buildMonitor.subTask(MessageFormat.format(Messages.P4JobConnector_GeneratingTaskData, job.getId()));
                        TaskData data = this.dataHandler.generateTaskData(repository, job);
                        if (data != null) {
                            collector.accept(data);
                        }
                    }
                    catch (CoreException e) {
                        IStatus iStatus = e.getStatus();
                        buildMonitor.done();
                        monitor.done();
                        return iStatus;
                    }
                    buildMonitor.worked(1);
                    ++n2;
                }
            }
            finally {
                buildMonitor.done();
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    JobCache getCache() {
        return this.jobCache;
    }

    public AbstractTaskDataHandler getTaskDataHandler() {
        return this.dataHandler;
    }

    public void updateRepositoryConfiguration(TaskRepository repository, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        IP4Connection connection = P4MylynUtils.getConnection(repository);
        if (connection == null) {
            throw new CoreException(P4MylynUtils.getConnectionErrorStatus());
        }
        monitor.beginTask(MessageFormat.format(Messages.P4JobConnector_UpdatingJobspec, connection.getParameters().getPortNoNull()), 1);
        connection.refreshJobSpec();
        monitor.worked(1);
        monitor.done();
    }

    public void updateTaskFromTaskData(TaskRepository taskRepository, ITask task, TaskData taskData) {
        TaskMapper mapper = new TaskMapper(taskData);
        mapper.applyTo(task);
        this.manager.getConfiguration(taskRepository).updateTaskFromTaskData(taskRepository, task, taskData);
    }

    public static interface IJobCallback {
        public void loaded(IP4Job var1);
    }
}

