/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.text.timelapse.form;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.text.PerforceUiTextPlugin;
import com.perforce.team.ui.text.TextUtils;
import com.perforce.team.ui.text.timelapse.IFilterNodeModel;
import com.perforce.team.ui.text.timelapse.INodeModel;
import com.perforce.team.ui.text.timelapse.ITextAnnotateModel;
import com.perforce.team.ui.text.timelapse.NodeModelTimeLapseEditor;
import com.perforce.team.ui.text.timelapse.NodeOutlinePage;
import com.perforce.team.ui.text.timelapse.NodeTickDecorator;
import com.perforce.team.ui.text.timelapse.NodeTimeLapseEditor;
import com.perforce.team.ui.text.timelapse.form.Form;
import com.perforce.team.ui.text.timelapse.form.FormField;
import com.perforce.team.ui.text.timelapse.form.FormNodeModel;
import com.perforce.team.ui.text.timelapse.form.FormOutlinePage;
import com.perforce.team.ui.text.timelapse.form.FormTextAnnotateModel;
import com.perforce.team.ui.text.timelapse.form.FormTickDecorator;
import com.perforce.team.ui.text.timelapse.form.Messages;
import com.perforce.team.ui.timelapse.IRevisionInputCache;
import com.perforce.team.ui.timelapse.TimeLapseInput;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;

public class FormTimeLapseEditor
extends NodeModelTimeLapseEditor {
    public static final String HIDE_COMMENTS = "com.perforce.team.ui.text.timelapse.form.HIDE_COMMENTS";
    public static final String ID = "com.perforce.team.ui.text.timelapse.form.FormTimeLapseEditor";
    private TextFileDocumentProvider provider;
    private ProjectionViewer viewer;
    private boolean hideComments = true;

    @Override
    protected void fillToolbar(ToolBar toolbar) {
        super.fillToolbar(toolbar);
        this.configureLinking(toolbar, Messages.FormTimeLapseEditor_LinkWithOutlineViewSelection);
        final ToolItem showComments = new ToolItem(toolbar, 32);
        showComments.setToolTipText(Messages.FormTimeLapseEditor_DisplayComments);
        Image commentImage = PerforceUiTextPlugin.getImageDescriptor("icons/comment.png").createImage();
        P4UIUtils.registerDisposal((Widget)showComments, (Resource)commentImage);
        showComments.setImage(commentImage);
        showComments.setSelection(!this.hideComments);
        showComments.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormTimeLapseEditor.this.hideComments = !showComments.getSelection();
                PerforceUiTextPlugin.getDefault().getPreferenceStore().setValue(FormTimeLapseEditor.HIDE_COMMENTS, FormTimeLapseEditor.this.hideComments);
                FormTimeLapseEditor.this.filter(false);
            }
        });
    }

    @Override
    protected void addBuildItem(ToolBar toolbar) {
    }

    @Override
    protected ITextAnnotateModel createTextAnnotateModel(IP4File file) {
        return new FormTextAnnotateModel(file, null, ((TimeLapseInput)this.getEditorInput()).useChangelistKeys());
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.hideComments = PerforceUiTextPlugin.getDefault().getPreferenceStore().getBoolean(HIDE_COMMENTS);
        super.init(site, input);
    }

    @Override
    protected void showEntireDocument() {
        if (this.hideComments) {
            FormNodeModel formModel = (FormNodeModel)this.getModel();
            FormField element = formModel.getFirstFormField(this.getRevision());
            if (element != null) {
                int length = this.getViewer().getDocument().getLength();
                this.getViewer().setVisibleRegion(element.getOffset(), length - element.getOffset());
            }
        } else {
            super.showEntireDocument();
        }
    }

    @Override
    public void showNode(Object node) {
        super.showNode(node);
        if (node instanceof FormField) {
            FormField field = (FormField)node;
            String id = this.getModel().getHandle(node);
            this.getFormatter().setFilter(id);
            this.getDecorator().setNodeId(id);
            this.showRange(new NodeTimeLapseEditor.Range(field.getOffset(), field.getLength()));
            this.selectRange(new NodeTimeLapseEditor.Range(field.getOffset(), field.getName().length()));
        } else {
            this.getFormatter().setFilter(null);
            this.getDecorator().setNodeId(null);
        }
    }

    @Override
    protected void updateVisibleRange() {
        FormNodeModel formModel;
        FormField element;
        if (this.isLinking() && !this.isFiltering() && this.selected != null && (element = (formModel = (FormNodeModel)this.getModel()).getFormField(formModel.getHandle(this.selected), this.getRevision())) != null) {
            if (this.outlinePage != null) {
                if (!this.outlinePage.isDisposed()) {
                    this.outlinePage.setSelection((ISelection)new StructuredSelection((Object)element));
                } else {
                    this.outlinePage = null;
                }
            }
            this.showNode(element);
            return;
        }
        super.updateVisibleRange();
    }

    @Override
    protected NodeOutlinePage createOutlinePage() {
        return new FormOutlinePage((Form)this.getRoot(), (INodeModel)this.getModel());
    }

    @Override
    protected NodeTickDecorator createNodeDecorator() {
        FormTickDecorator decorator = new FormTickDecorator(this.getModel());
        decorator.setAuthorProvider((FormTextAnnotateModel)this.getAnnotateModel());
        return decorator;
    }

    @Override
    protected IFilterNodeModel createNodeModel() {
        FormNodeModel model = new FormNodeModel(this.getRevisions(), (IRevisionInputCache)this);
        ((FormTextAnnotateModel)this.getAnnotateModel()).setNodeAuthorProvider(model);
        return model;
    }

    @Override
    protected IDocument getDocument(IEditorInput input) {
        try {
            this.provider.connect((Object)input);
        }
        catch (CoreException e) {
            PerforceProviderPlugin.logError((Throwable)e);
        }
        return this.provider.getDocument((Object)input);
    }

    @Override
    protected String getNodeLabel() {
        return "field";
    }

    @Override
    protected String getFilterLabel() {
        return Messages.FormTimeLapseEditor_Fields;
    }

    @Override
    protected NodeTimeLapseEditor.Range getRange(String filterKey) {
        NodeTimeLapseEditor.Range range = null;
        FormField field = ((FormNodeModel)this.getModel()).getFormField(filterKey, this.getRevision());
        if (field != null) {
            range = new NodeTimeLapseEditor.Range(field.getOffset(), field.getLength());
        }
        return range;
    }

    @Override
    protected ITextViewer getViewer() {
        return this.viewer;
    }

    protected void createViewer(Composite parent) {
        CompositeRuler ruler = this.configureRulers(true);
        this.viewer = new ProjectionViewer(parent, (IVerticalRuler)ruler, null, false, 0x2000300);
        this.viewer.getTextWidget().setBackground(this.getEditorColor("AbstractTextEditor.Color.Background"));
        this.viewer.getTextWidget().setForeground(this.getEditorColor("AbstractTextEditor.Color.Foreground"));
        if (!TextUtils.getEditorStore().getBoolean("AbstractTextEditor.Color.SelectionBackground.SystemDefault")) {
            this.viewer.getTextWidget().setSelectionBackground(this.getEditorColor("AbstractTextEditor.Color.SelectionBackground"));
        }
        if (!TextUtils.getEditorStore().getBoolean("AbstractTextEditor.Color.SelectionForeground.SystemDefault")) {
            this.viewer.getTextWidget().setSelectionForeground(this.getEditorColor("AbstractTextEditor.Color.SelectionForeground"));
        }
        this.provider = new TextFileDocumentProvider();
        this.configureViewer("org.eclipse.jface.textfont");
    }

    protected void dispose(IEditorInput input) {
        super.dispose(input);
        this.provider.disconnect((Object)input);
    }

    @Override
    protected boolean isBuild() {
        return true;
    }
}

