/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.search.results.tree;

import com.perforce.p4java.core.IFileLineMatch;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.ui.LabelProviderAdapter;
import com.perforce.team.ui.search.results.FileMatch;
import com.perforce.team.ui.search.results.ISearchResultProvider;
import com.perforce.team.ui.search.results.P4SearchResult;
import com.perforce.team.ui.search.results.RevisionMatch;
import com.perforce.team.ui.search.results.tree.Messages;
import java.text.MessageFormat;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.DeviceResourceManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class SearchTreeLabelProvider
extends LabelProviderAdapter {
    protected DeviceResourceManager imageManager;
    protected ISearchResultProvider page;
    private boolean showFileNames = false;

    public SearchTreeLabelProvider(ISearchResultProvider page, Display display) {
        this.page = page;
        this.imageManager = new DeviceResourceManager((Device)display);
    }

    private int getRevisionCount(IP4File file) {
        int count = 0;
        P4SearchResult result = this.page.getResult();
        if (result != null) {
            count = result.getRevisions(file).length;
        }
        return count;
    }

    private int getLineCount(RevisionMatch revision) {
        int count = 0;
        P4SearchResult result = this.page.getResult();
        if (result != null) {
            Match[] matches;
            Match[] matchArray = matches = result.getMatches(revision);
            int n = matches.length;
            int n2 = 0;
            while (n2 < n) {
                Match match = matchArray[n2];
                if (IFileLineMatch.MatchType.MATCH == ((FileMatch)match).getMatch().getType()) {
                    ++count;
                }
                ++n2;
            }
        }
        return count;
    }

    private StyledString getFileMatchText(IP4File file) {
        StyledString styled = new StyledString(this.getText(file));
        int matches = this.getRevisionCount(file);
        styled.append(MessageFormat.format(Messages.SearchTreeLabelProvider_NumRevisions, matches), StyledString.COUNTER_STYLER);
        return styled;
    }

    private StyledString getRevisionMatchText(RevisionMatch revision) {
        StyledString styled = new StyledString(this.getText(revision));
        int matches = this.getLineCount(revision);
        styled.append(MessageFormat.format(Messages.SearchTreeLabelProvider_NumMatches, matches), StyledString.COUNTER_STYLER);
        return styled;
    }

    private StyledString getLineMatchText(FileMatch result) {
        IFileLineMatch match = result.getMatch();
        StyledString styled = new StyledString(String.valueOf(match.getLineNumber()) + ":", StyledString.QUALIFIER_STYLER);
        styled.append(' ');
        styled.append(P4CoreUtils.removeWhitespace((String)match.getLine()));
        return styled;
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof RevisionMatch) {
            return this.getRevisionMatchText((RevisionMatch)element);
        }
        if (element instanceof FileMatch) {
            return this.getLineMatchText((FileMatch)element);
        }
        if (element instanceof IP4File) {
            return this.getFileMatchText((IP4File)element);
        }
        return super.getStyledText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof IP4File) {
            String name = ((IP4File)element).getName();
            ImageDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(name);
            if (desc != null) {
                return (Image)this.imageManager.get((DeviceResourceDescriptor)desc);
            }
        } else {
            ImageDescriptor desc;
            IWorkbenchAdapter adapter = (IWorkbenchAdapter)P4CoreUtils.convert((Object)element, IWorkbenchAdapter.class);
            if (adapter != null && (desc = adapter.getImageDescriptor(element)) != null) {
                return (Image)this.imageManager.get((DeviceResourceDescriptor)desc);
            }
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof IP4File) {
            if (this.showFileNames) {
                return ((IP4File)element).getName();
            }
            return ((IP4File)element).getRemotePath();
        }
        IWorkbenchAdapter adapter = (IWorkbenchAdapter)P4CoreUtils.convert((Object)element, IWorkbenchAdapter.class);
        if (adapter != null) {
            return adapter.getLabel(element);
        }
        return "";
    }

    public void dispose() {
        super.dispose();
        this.imageManager.dispose();
    }

    public void setShowFileNames(boolean show) {
        this.showFileNames = show;
    }
}

