/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.search.results;

import com.perforce.p4java.core.IFileLineMatch;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.editor.DepotFileEditorInput;
import com.perforce.team.ui.search.P4UiSearchPlugin;
import com.perforce.team.ui.search.results.IDepotMatch;
import com.perforce.team.ui.search.results.LineSelectionListener;
import com.perforce.team.ui.search.results.RevisionMatch;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class FileMatch
extends Match
implements IWorkbenchAdapter,
IDepotMatch,
IAdaptable {
    private IFileLineMatch match;
    private IP4Connection connection;
    private int lineNumber;

    public FileMatch(IP4Connection connection, RevisionMatch revision, IFileLineMatch match) {
        super((Object)revision, 0, 0);
        this.connection = connection;
        this.match = match;
        this.lineNumber = this.match.getLineNumber();
    }

    public String getLabel(Object object) {
        return MessageFormat.format("{0}: {1}", this.lineNumber, P4CoreUtils.removeWhitespace((String)this.match.getLine()));
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        switch (this.match.getType()) {
            case BEFORE: 
            case AFTER: {
                return P4UiSearchPlugin.getDescriptor("icons/line_other.png");
            }
        }
        return P4UiSearchPlugin.getDescriptor("icons/line_match.png");
    }

    public IFileLineMatch getMatch() {
        return this.match;
    }

    public RevisionMatch getRevisionMatch() {
        return (RevisionMatch)this.getElement();
    }

    @Override
    public String getDepotPath() {
        return this.getRevisionMatch().getDepotPath();
    }

    @Override
    public void openInEditor() {
        if (this.connection != null) {
            P4Runner.schedule((IP4Runnable)new P4Runnable(){

                public void run(IProgressMonitor monitor) {
                    IP4File file = FileMatch.this.connection.getFile(FileMatch.this.match.getDepotFile());
                    if (file != null) {
                        DepotFileEditorInput input = new DepotFileEditorInput(file, "#" + FileMatch.this.match.getRevision());
                        LineSelectionListener listener = new LineSelectionListener(FileMatch.this.lineNumber - 1);
                        P4UIUtils.openEditor((IStorageEditorInput)input, (IPartListener)listener);
                    }
                }
            });
        }
    }

    public Object[] getChildren(Object o) {
        return new Object[0];
    }

    public Object getParent(Object o) {
        return null;
    }

    @Override
    public int getRevision() {
        return this.getRevisionMatch().getRevision();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public IP4File getFile() {
        return this.getRevisionMatch().getFile();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return String.valueOf(this.getDepotPath()) + "#" + this.getRevision() + ":" + this.getLineNumber();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FileMatch) {
            FileMatch other = (FileMatch)obj;
            return this.getLineNumber() == other.getLineNumber() && this.getRevisionMatch().equals(other.getRevisionMatch());
        }
        return false;
    }

    public Object getAdapter(Class adapter) {
        IP4Connection adapted = null;
        if (IP4Connection.class == adapter) {
            adapted = this.connection;
        } else if (IP4Resource.class == adapter || IP4File.class == adapter) {
            adapted = this.getFile();
        }
        return adapted;
    }
}

