/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.search.query;

import com.perforce.team.core.search.query.QueryOptions;
import com.perforce.team.ui.search.query.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public class SearchOptionsArea {
    private Composite displayArea = null;
    private Button allRevisions = null;
    private Button searchBinaries = null;
    private Button caseInsensitive = null;
    private Button leadingContextButton = null;
    private Button trailingContextButton = null;
    private Spinner leadingContextSpinner = null;
    private Spinner trailingContextSpinner = null;

    public void fillOptions(QueryOptions options) {
        if (this.allRevisions != null) {
            options.setAllRevisions(this.allRevisions.getSelection());
        } else {
            options.setAllRevisions(false);
        }
        options.setCaseInsensitive(this.caseInsensitive.getSelection());
        options.setSearchBinaries(this.searchBinaries.getSelection());
        if (this.leadingContextButton.getSelection()) {
            options.setLeadingContext(this.leadingContextSpinner.getSelection());
        }
        if (this.trailingContextButton.getSelection()) {
            options.setTrailingContext(this.trailingContextSpinner.getSelection());
        }
    }

    protected Button createButton(Composite parent, String text, int style) {
        Button button = new Button(parent, style);
        if (text != null) {
            button.setText(text);
        }
        return button;
    }

    public void createControl(Composite parent, boolean showSearchAll) {
        this.displayArea = new Composite(parent, 0);
        GridLayout daLayout = new GridLayout(3, false);
        daLayout.marginHeight = 0;
        daLayout.marginWidth = 0;
        this.displayArea.setLayout((Layout)daLayout);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, false));
        if (showSearchAll) {
            this.allRevisions = this.createButton(this.displayArea, Messages.SearchOptionsArea_SearchAllRevs, 32);
        }
        this.caseInsensitive = this.createButton(this.displayArea, Messages.SearchOptionsArea_CaseInsensitive, 32);
        this.searchBinaries = this.createButton(this.displayArea, Messages.SearchOptionsArea_IncludeBinaryFiles, 32);
        this.createContextOptions(this.displayArea);
    }

    private void createContextOptions(Composite parent) {
        Composite leadingArea = new Composite(parent, 0);
        leadingArea.setLayoutData((Object)new GridData(1, 4, false, false));
        GridLayout laLayout = new GridLayout(2, false);
        laLayout.marginHeight = 0;
        laLayout.marginWidth = 0;
        leadingArea.setLayout((Layout)laLayout);
        this.leadingContextButton = this.createButton(leadingArea, Messages.SearchOptionsArea_LeadingContextLines, 32);
        this.leadingContextSpinner = new Spinner(leadingArea, 0);
        this.leadingContextSpinner.setMinimum(1);
        this.leadingContextSpinner.setSelection(1);
        this.leadingContextSpinner.setEnabled(false);
        this.leadingContextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchOptionsArea.this.leadingContextSpinner.setEnabled(SearchOptionsArea.this.leadingContextButton.getSelection());
            }
        });
        Composite trailingArea = new Composite(parent, 0);
        trailingArea.setLayoutData((Object)new GridData(1, 4, false, false));
        GridLayout taLayout = new GridLayout(2, false);
        taLayout.marginHeight = 0;
        taLayout.marginWidth = 0;
        trailingArea.setLayout((Layout)taLayout);
        this.trailingContextButton = this.createButton(trailingArea, Messages.SearchOptionsArea_TrailingContextLines, 32);
        this.trailingContextSpinner = new Spinner(trailingArea, 0);
        this.trailingContextSpinner.setMinimum(1);
        this.trailingContextSpinner.setSelection(1);
        this.trailingContextSpinner.setEnabled(false);
        this.trailingContextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchOptionsArea.this.trailingContextSpinner.setEnabled(SearchOptionsArea.this.trailingContextButton.getSelection());
            }
        });
    }

    public void createControl(Composite parent) {
        this.createControl(parent, true);
    }

    public void setEnabled(boolean enabled) {
        this.allRevisions.setEnabled(enabled);
        this.searchBinaries.setEnabled(enabled);
        this.caseInsensitive.setEnabled(enabled);
        this.leadingContextButton.setEnabled(enabled);
        this.trailingContextButton.setEnabled(enabled);
        this.leadingContextSpinner.setEnabled(enabled);
        this.trailingContextSpinner.setEnabled(enabled);
    }
}

