/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.patch.wizard;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4JavaSysFileCommandsHelper;
import com.perforce.team.ui.IErrorDisplay;
import com.perforce.team.ui.IErrorProvider;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.patch.P4PatchUiPlugin;
import com.perforce.team.ui.patch.model.ClipboardStream;
import com.perforce.team.ui.patch.model.FileSystemStream;
import com.perforce.team.ui.patch.model.IPatchStream;
import com.perforce.team.ui.patch.model.WorkspaceStream;
import com.perforce.team.ui.patch.wizard.Messages;
import com.perforce.team.ui.patch.wizard.PendingViewer;
import com.perforce.team.ui.patch.wizard.WorkspaceDialog;
import com.perforce.team.ui.views.SessionManager;
import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class LocationPage
extends WizardPage
implements IErrorProvider {
    private Composite displayArea;
    private Button clipboardButton;
    private Button fileButton;
    private Combo fileText;
    private ToolBar fileToolbar;
    private Button workspaceButton;
    private Combo workspaceText;
    private ToolBar workspaceToolbar;
    private PendingViewer viewer;
    private P4JavaSysFileCommandsHelper helper = new P4JavaSysFileCommandsHelper();
    private Text p4Text;
    private IResource[] resources;
    private ClipboardStream clipboardStream = new ClipboardStream();
    private FileSystemStream fileStream = new FileSystemStream();
    private WorkspaceStream workspaceStream = new WorkspaceStream();
    private IPatchStream selected = null;
    private P4Collection collection = null;
    private String p4Path = null;

    protected LocationPage(P4Collection collection) {
        super("locationPage");
        this.setTitle(Messages.LocationPage_Title);
        this.setDescription(Messages.LocationPage_Description);
        this.collection = collection;
        this.p4Path = P4PatchUiPlugin.getDefault().getPreferenceStore().getString("P4_PATH");
    }

    public void saveHistory() {
        if (P4UIUtils.okToUse((Widget)this.displayArea)) {
            IPreferenceStore store = P4PatchUiPlugin.getDefault().getPreferenceStore();
            SessionManager.saveComboHistory((Combo)this.fileText, (int)10, (String)"FILE_PATHS", (IPreferenceStore)store);
            SessionManager.saveComboHistory((Combo)this.workspaceText, (int)10, (String)"WORKSPACE_PATHS", (IPreferenceStore)store);
            if (this.clipboardButton.getSelection()) {
                store.setValue("PATCH_TYPE", "CLIPBOARD");
            } else if (this.workspaceButton.getSelection()) {
                store.setValue("PATCH_TYPE", "WORKSPACE");
            } else if (this.fileButton.getSelection()) {
                store.setValue("PATCH_TYPE", "FILE");
            }
            store.setValue("P4_PATH", this.p4Path);
        }
    }

    private void createFileArea(Composite parent) {
        this.fileButton = new Button(parent, 16);
        this.fileButton.setText(Messages.LocationPage_FilePath);
        this.fileText = new Combo(parent, 4);
        this.fileText.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).create());
        final Runnable updateText = new Runnable(){

            @Override
            public void run() {
                LocationPage.this.validate();
            }
        };
        this.fileText.addSelectionListener(P4UIUtils.createComboSelectionListener((Runnable)updateText));
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                updateText.run();
            }
        });
        SessionManager.loadComboHistory((Combo)this.fileText, (String)"FILE_PATHS", (IPreferenceStore)P4PatchUiPlugin.getDefault().getPreferenceStore());
        this.fileToolbar = new ToolBar(parent, 0x800000);
        ToolItem browseItem = new ToolItem(this.fileToolbar, 8);
        Image browseImage = PerforceUIPlugin.getDescriptor((String)"normal/find.png").createImage();
        P4UIUtils.registerDisposal((Widget)browseItem, (Resource)browseImage);
        browseItem.setImage(browseImage);
        browseItem.setToolTipText(Messages.LocationPage_Browse);
        browseItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(LocationPage.this.fileToolbar.getShell(), 8192);
                String selected = dialog.open();
                if (selected != null) {
                    LocationPage.this.fileText.setText(selected);
                    LocationPage.this.validate();
                }
            }
        });
    }

    private void createWorkspaceArea(Composite parent) {
        this.workspaceButton = new Button(parent, 16);
        this.workspaceButton.setText(Messages.LocationPage_WorkspacePath);
        this.workspaceText = new Combo(parent, 4);
        this.workspaceText.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).create());
        SessionManager.loadComboHistory((Combo)this.workspaceText, (String)"WORKSPACE_PATHS", (IPreferenceStore)P4PatchUiPlugin.getDefault().getPreferenceStore());
        final Runnable updateText = new Runnable(){

            @Override
            public void run() {
                LocationPage.this.validate();
            }
        };
        this.workspaceText.addSelectionListener(P4UIUtils.createComboSelectionListener((Runnable)updateText));
        this.workspaceText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                updateText.run();
            }
        });
        this.workspaceToolbar = new ToolBar(parent, 0x800000);
        ToolItem browseItem = new ToolItem(this.workspaceToolbar, 8);
        Image browseImage = PerforceUIPlugin.getDescriptor((String)"normal/find.png").createImage();
        P4UIUtils.registerDisposal((Widget)browseItem, (Resource)browseImage);
        browseItem.setImage(browseImage);
        browseItem.setToolTipText(Messages.LocationPage_Browse);
        browseItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IFile file;
                WorkspaceDialog dialog = new WorkspaceDialog(LocationPage.this.getShell());
                dialog.setTitleImage(LocationPage.this.getImage());
                dialog.setInitialTitle(Messages.LocationPage_WorkspaceDialogTitle);
                dialog.setInitialMessage(Messages.LocationPage_WorkspaceDialogMessage);
                if (dialog.open() == 0 && (file = dialog.getFile()) != null) {
                    LocationPage.this.workspaceText.setText(file.getFullPath().toString());
                    LocationPage.this.validate();
                }
            }
        });
    }

    private void createP4Area(Composite parent, int span) {
        Composite p4Area = new Composite(parent, 0);
        p4Area.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).create());
        p4Area.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(3, 1).create());
        new Label(p4Area, 0).setText(Messages.LocationPage_P4Path);
        this.p4Text = new Text(p4Area, 2052);
        this.p4Text.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).create());
        this.p4Text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LocationPage.this.validate();
            }
        });
        this.p4Text.setText(this.p4Path);
        final ToolBar toolbar = new ToolBar(p4Area, 0x800000);
        ToolItem browseItem = new ToolItem(toolbar, 8);
        Image browseImage = PerforceUIPlugin.getDescriptor((String)"normal/find.png").createImage();
        P4UIUtils.registerDisposal((Widget)browseItem, (Resource)browseImage);
        browseItem.setImage(browseImage);
        browseItem.setToolTipText(Messages.LocationPage_Browse);
        browseItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(toolbar.getShell(), 4096);
                String selected = dialog.open();
                if (selected != null) {
                    LocationPage.this.p4Text.setText(selected);
                    LocationPage.this.validate();
                }
            }
        });
    }

    private void createSeparator(Composite parent, int span) {
        new Label(parent, 258).setLayoutData((Object)GridDataFactory.fillDefaults().span(3, 1).grab(true, false).create());
    }

    public void createControl(Composite parent) {
        this.displayArea = new Composite(parent, 0);
        this.displayArea.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(3).equalWidth(false).create());
        this.displayArea.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        Label locationLabel = new Label(this.displayArea, 0);
        locationLabel.setText(Messages.LocationPage_SelectExportLocation);
        locationLabel.setLayoutData((Object)GridDataFactory.fillDefaults().span(3, 1).create());
        this.clipboardButton = new Button(this.displayArea, 16);
        this.clipboardButton.setText(Messages.LocationPage_Clipboard);
        this.clipboardButton.setLayoutData((Object)GridDataFactory.swtDefaults().span(3, 1).create());
        this.createFileArea(this.displayArea);
        this.createWorkspaceArea(this.displayArea);
        this.createSeparator(this.displayArea, 3);
        Label pendingLabel = new Label(this.displayArea, 0);
        pendingLabel.setLayoutData((Object)GridDataFactory.swtDefaults().span(3, 1).create());
        pendingLabel.setText(Messages.LocationPage_PendingProjectFiles);
        this.viewer = new PendingViewer(this.collection);
        this.viewer.createControl(this.displayArea, new Runnable(){

            @Override
            public void run() {
                LocationPage.this.validate();
            }
        });
        CheckboxTreeViewer checkTree = this.viewer.getViewer();
        if (checkTree != null) {
            checkTree.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    LocationPage.this.validate();
                }
            });
        }
        ((GridData)checkTree.getTree().getLayoutData()).horizontalSpan = 3;
        this.createSeparator(this.displayArea, 3);
        this.createP4Area(this.displayArea, 3);
        SelectionAdapter buttonListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocationPage.this.updateEnablement();
                LocationPage.this.updateFocus();
                LocationPage.this.validate();
            }
        };
        this.clipboardButton.addSelectionListener((SelectionListener)buttonListener);
        this.fileButton.addSelectionListener((SelectionListener)buttonListener);
        this.workspaceButton.addSelectionListener((SelectionListener)buttonListener);
        this.setInitialType();
        this.updateEnablement();
        this.validate();
        this.setControl((Control)this.displayArea);
        this.setErrorMessage(null);
        this.setPageComplete(false);
    }

    private void setInitialType() {
        String initialType = P4PatchUiPlugin.getDefault().getPreferenceStore().getString("PATCH_TYPE");
        if (initialType.length() > 0) {
            if ("CLIPBOARD".equals(initialType)) {
                this.clipboardButton.setSelection(true);
            } else if ("WORKSPACE".equals(initialType)) {
                this.workspaceButton.setSelection(true);
            } else if ("FILE".equals(initialType)) {
                this.fileButton.setSelection(true);
            } else {
                this.clipboardButton.setSelection(true);
            }
        } else {
            this.clipboardButton.setSelection(true);
        }
        if (this.fileText.getItemCount() > 0) {
            this.fileText.select(0);
        }
        if (this.workspaceText.getItemCount() > 0) {
            this.workspaceText.select(0);
        }
    }

    private void updateFocus() {
        if (this.fileButton.getSelection()) {
            this.fileText.setFocus();
        } else if (this.workspaceButton.getSelection()) {
            this.workspaceText.setFocus();
        }
    }

    private void updateEnablement() {
        boolean file = this.fileButton.getSelection();
        this.fileText.setEnabled(file);
        this.fileToolbar.setEnabled(file);
        boolean workspace = this.workspaceButton.getSelection();
        this.workspaceText.setEnabled(workspace);
        this.workspaceToolbar.setEnabled(workspace);
    }

    public void setErrorDisplay(IErrorDisplay display) {
    }

    public void validate() {
        String text;
        String message = null;
        this.resources = this.viewer.getSelectedResources();
        if (this.clipboardButton.getSelection()) {
            this.selected = this.clipboardStream;
        } else if (this.fileButton.getSelection()) {
            this.selected = this.fileStream;
            text = this.fileText.getText().trim();
            if (text.length() > 0) {
                File file = new File(text);
                if (message == null && file.exists() && !file.canWrite()) {
                    message = Messages.LocationPage_FileNotWritable;
                }
                if (message == null && !file.isAbsolute()) {
                    message = Messages.LocationPage_AbsolutePath;
                }
                if (message == null && file.isDirectory()) {
                    message = Messages.LocationPage_DirectoryPath;
                }
            } else if (message == null) {
                message = Messages.LocationPage_AbsolutePath;
            }
            this.fileStream.setPath(text);
        } else if (this.workspaceButton.getSelection()) {
            IFile file;
            block27: {
                this.selected = this.workspaceStream;
                text = this.workspaceText.getText().trim();
                file = null;
                if (text.length() > 0 && Path.EMPTY.isValidPath(text)) {
                    try {
                        Path path = new Path(text);
                        file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
                        if (file != null) {
                            File localFile;
                            if (message == null && !file.getProject().exists()) {
                                message = MessageFormat.format(Messages.LocationPage_ProjectDoesNotExist, file.getProject().getName());
                            }
                            if (message == null && !file.getParent().exists()) {
                                message = MessageFormat.format(Messages.LocationPage_FolderDoesNotExist, file.getParent().getName());
                            }
                            if (message == null && (localFile = file.getLocation().toFile()) != null && localFile.exists() && !localFile.canWrite()) {
                                message = Messages.LocationPage_FileNotWritable;
                            }
                        }
                    }
                    catch (Exception e) {
                        if (message != null) break block27;
                        message = e.getLocalizedMessage();
                    }
                }
            }
            this.workspaceStream.setFile(file);
            if (message == null && file == null) {
                message = Messages.LocationPage_ValidWorkspacePath;
            }
        }
        if (message == null && this.resources.length == 0) {
            message = Messages.LocationPage_SelectResource;
        }
        this.p4Path = this.p4Text.getText().trim();
        if (this.p4Path.length() > 0) {
            File file = new File(this.p4Path);
            if (message == null && !file.exists()) {
                message = Messages.LocationPage_EnterP4Path;
            }
            if (message == null && !file.isAbsolute()) {
                message = Messages.LocationPage_EnterAbsoluteP4Path;
            }
            if (message == null && file.isDirectory()) {
                message = Messages.LocationPage_DirectoryP4Path;
            }
            if (message == null && !P4CoreUtils.isWindows() && !this.helper.canExecute(file.getAbsolutePath())) {
                message = Messages.LocationPage_NonExecutableP4Path;
            }
        } else if (message == null) {
            message = Messages.LocationPage_EnterP4Path;
        }
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public IResource[] getResources() {
        return this.resources;
    }

    public IPatchStream getStream() {
        return this.selected;
    }

    public String getP4Path() {
        return this.p4Path;
    }
}

