/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.views;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.ui.PerforceUIPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class SessionManager {
    public static String[] getEntries(String preference) {
        return SessionManager.getEntries(preference, true);
    }

    public static String[] getEntries(String preference, IPreferenceStore store) {
        return SessionManager.getEntries(preference, true, store);
    }

    public static String[] getEntries(String preference, boolean trim) {
        return SessionManager.getEntries(preference, trim, PerforceUIPlugin.getPlugin().getPreferenceStore());
    }

    public static String[] getEntries(String preference, boolean trim, IPreferenceStore store) {
        ArrayList<String> splitItems;
        block6: {
            splitItems = new ArrayList<String>();
            if (preference == null || store == null) break block6;
            String items = store.getString(preference);
            String[] splitStrings = items.split("###");
            if (trim) {
                String[] stringArray = splitStrings;
                int n = splitStrings.length;
                int n2 = 0;
                while (n2 < n) {
                    String split = stringArray[n2];
                    if (split != null && (split = split.trim()).length() > 0) {
                        splitItems.add(split);
                    }
                    ++n2;
                }
            } else {
                String[] stringArray = splitStrings;
                int n = splitStrings.length;
                int n3 = 0;
                while (n3 < n) {
                    String split = stringArray[n3];
                    if (split != null && split.length() > 0) {
                        splitItems.add(split);
                    }
                    ++n3;
                }
            }
        }
        return splitItems.toArray(new String[0]);
    }

    public static void saveEntries(List<String> entries, String preference) {
        if (entries != null && preference != null) {
            StringBuilder entriesValue = new StringBuilder();
            for (String entry : entries) {
                entriesValue.append(entry);
                entriesValue.append("###");
            }
            PerforceUIPlugin.getPlugin().getPreferenceStore().setValue(preference, entriesValue.toString());
        }
    }

    public static void saveComboHistory(Combo combo, int max, String preference, IPreferenceStore store) {
        if (combo == null || max < 1 || preference == null || store == null) {
            return;
        }
        String current = combo.getText();
        ArrayList<String> entries = new ArrayList<String>();
        if (current.length() > 0) {
            entries.add(current);
        }
        String[] stringArray = combo.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (!entries.contains(item)) {
                entries.add(item);
            }
            if (entries.size() == max) break;
            ++n2;
        }
        combo.removeAll();
        StringBuilder value = new StringBuilder();
        for (String item : entries) {
            combo.add(item, combo.getItemCount());
            value.append(item).append("###");
        }
        store.setValue(preference, value.toString());
        combo.select(0);
    }

    public static void saveComboHistory(Combo combo, int max, String preference) {
        SessionManager.saveComboHistory(combo, max, preference, PerforceUIPlugin.getPlugin().getPreferenceStore());
    }

    public static void loadComboHistory(Combo combo, String preference) {
        SessionManager.loadComboHistory(combo, preference, PerforceUIPlugin.getPlugin().getPreferenceStore());
    }

    public static void loadComboHistory(Combo combo, String preference, IPreferenceStore store) {
        String[] entries;
        if (combo == null || preference == null || store == null) {
            return;
        }
        String[] stringArray = entries = SessionManager.getEntries(preference, store);
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            combo.add(entry);
            ++n2;
        }
    }

    public static void saveHistory(List<String> items, String preference) {
        if (items != null && preference != null) {
            StringBuilder usersBuffer = new StringBuilder();
            for (String item : items) {
                usersBuffer.append(item).append("###");
            }
            PerforceUIPlugin.getPlugin().getPreferenceStore().setValue(preference, usersBuffer.toString());
        }
    }

    public static void saveColumnPreferences(Tree tree, String preference) {
        if (preference != null && tree != null && !tree.isDisposed()) {
            StringBuilder buffer = new StringBuilder();
            TreeColumn[] treeColumnArray = tree.getColumns();
            int n = treeColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeColumn column = treeColumnArray[n2];
                buffer.append(String.valueOf(column.getText()) + "=" + column.getWidth() + "###");
                ++n2;
            }
            PerforceUIPlugin.getPlugin().getPreferenceStore().setValue(preference, buffer.toString());
        }
    }

    public static void saveColumnPreferences(Table table, String preference) {
        if (preference != null && table != null && !table.isDisposed()) {
            StringBuffer buffer = new StringBuffer();
            TableColumn[] tableColumnArray = table.getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn column = tableColumnArray[n2];
                buffer.append(String.valueOf(column.getText()) + "=" + column.getWidth() + "###");
                ++n2;
            }
            PerforceUIPlugin.getPlugin().getPreferenceStore().setValue(preference, buffer.toString());
        }
    }

    public static Map<String, Integer> loadColumnSizes(String preference) {
        String columns;
        HashMap<String, Integer> columnSizes = new HashMap<String, Integer>();
        if (preference != null && (columns = PerforceUIPlugin.getPlugin().getPreferenceStore().getString(preference)).length() > 0) {
            String[] pairs;
            String[] stringArray = pairs = columns.split("###");
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                String pair = stringArray[n2];
                String[] nameValue = pair.split("=");
                if (nameValue.length == 2) {
                    try {
                        Integer value = Integer.parseInt(nameValue[1]);
                        columnSizes.put(nameValue[0], value);
                    }
                    catch (NumberFormatException nfe) {
                        PerforceProviderPlugin.logError((Throwable)nfe);
                    }
                }
                ++n2;
            }
        }
        return columnSizes;
    }
}

