/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.views;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.views.DragData;
import java.util.ArrayList;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.FileTransfer;

public class DepotDragAdapter
extends DragSourceAdapter {
    private IStructuredSelection currentSelection;
    private ISelectionProvider selectionProvider;

    public DepotDragAdapter(ISelectionProvider provider) {
        this.selectionProvider = provider;
    }

    public void dragStart(DragSourceEvent event) {
        ISelection selection = this.selectionProvider.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            this.currentSelection = (IStructuredSelection)selection;
            LocalSelectionTransfer.getTransfer().setSelection((ISelection)this.currentSelection);
        } else {
            this.currentSelection = null;
        }
        event.doit = true;
    }

    public void dragSetData(DragSourceEvent event) {
        if (this.currentSelection != null && LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
            event.data = this.currentSelection;
            DragData.setConnection(this.getConnection());
            DragData.setSource((Object)this);
            return;
        }
        String[] paths = this.getSelectedPaths();
        if (paths == null || paths.length == 0) {
            return;
        }
        if (!FileTransfer.getInstance().isSupportedType(event.dataType)) {
            return;
        }
        event.data = paths;
        DragData.setConnection(this.getConnection());
        DragData.setSource((Object)this);
    }

    public void dragFinished(DragSourceEvent event) {
        this.currentSelection = null;
    }

    private IP4Connection getConnection() {
        IStructuredSelection structuredSelection = (IStructuredSelection)this.selectionProvider.getSelection();
        Object element = structuredSelection.getFirstElement();
        if (element instanceof IP4Resource) {
            return ((IP4Resource)element).getConnection();
        }
        return null;
    }

    private String[] getSelectedPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        ISelection selection = this.selectionProvider.getSelection();
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return null;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Object[] objectArray = structuredSelection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof IP4Resource) {
                String path = ((IP4Resource)obj).getLocalPath();
                if (path == null) {
                    path = ((IP4Resource)obj).getRemotePath();
                }
                if (path != null) {
                    paths.add(path);
                }
            }
            ++n2;
        }
        return paths.toArray(new String[paths.size()]);
    }
}

