/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.timelapse;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Revision;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.timelapse.ActionTickDecorator;
import com.perforce.team.ui.timelapse.IAnnotateModel;
import com.perforce.team.ui.timelapse.IRevisionInputCache;
import com.perforce.team.ui.timelapse.ITickDecorator;
import com.perforce.team.ui.timelapse.ITimeLapseListener;
import com.perforce.team.ui.timelapse.Messages;
import com.perforce.team.ui.timelapse.TimeLapseChangelistWidget;
import com.perforce.team.ui.timelapse.TimeLapseInput;
import com.perforce.team.ui.timelapse.TimeLapseSlider;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public abstract class TimeLapseEditor
extends EditorPart
implements IRevisionInputCache {
    public static final String SHOW_CHANGELIST = "com.perforce.team.ui.timelapse.SHOW_CHANGELIST";
    public static final String SHOW_BRANCH_HISTORY = "com.perforce.team.ui.timelapse.SHOW_BRANCH_HISTORY";
    public static final String SHOW_FILE_ACTIONS = "com.perforce.team.ui.timelapse.SHOW_FILE_ACTIONS";
    private static final int[] SASH_WEIGHTS = new int[]{80, 20};
    private SashForm displayArea;
    private Composite loadingArea;
    private Composite mainArea;
    private Composite outer;
    private TimeLapseSlider slider;
    private TimeLapseChangelistWidget changelistArea;
    private IP4Revision revision = null;
    private IP4Revision[] history;
    private Map<IP4Revision, IStorageEditorInput> inputCache;
    private boolean branch = false;
    private boolean showActions = false;
    private IAnnotateModel.Type type = IAnnotateModel.Type.REVISION;
    private boolean settingInput = false;
    private ITickDecorator decorator;
    private ListenerList listeners;

    public TimeLapseEditor() {
        this.inputCache = Collections.synchronizedMap(new HashMap());
        this.listeners = new ListenerList();
    }

    public Composite getControl() {
        return this.displayArea;
    }

    protected IP4Revision getRevision() {
        return this.revision;
    }

    protected IP4Revision[] getRevisions() {
        return this.history;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof TimeLapseInput)) {
            throw new PartInitException(Messages.TimeLapseEditor_WrongInputType);
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        IPreferenceStore store = PerforceUIPlugin.getPlugin().getPreferenceStore();
        this.branch = store.getBoolean(SHOW_BRANCH_HISTORY);
        this.showActions = store.getBoolean(SHOW_FILE_ACTIONS);
    }

    private void startEditorLoad(final Runnable uiCallback) {
        final IP4File file = this.getFile();
        P4Runner.schedule((IP4Runnable)new P4Runnable(){

            public String getTitle() {
                return MessageFormat.format(Messages.TimeLapseEditor_LoadingTimelapseViewFor, file.getActionPath());
            }

            public void run(IProgressMonitor monitor) {
                TimeLapseEditor.this.loadEditor(file, monitor);
                if (TimeLapseEditor.this.history != null && uiCallback != null) {
                    PerforceUIPlugin.syncExec(uiCallback);
                }
                TimeLapseEditor.this.notifyLoaded();
            }
        });
    }

    public boolean isLoading() {
        return this.loadingArea == ((StackLayout)this.outer.getLayout()).topControl;
    }

    protected boolean showBranches() {
        return this.branch;
    }

    protected void loadEditor(IP4File file, IProgressMonitor monitor) {
        this.clear();
        IFileRevision[] allHistory = file.getCompleteHistory(this.showBranches(), (IProgressMonitor)new NullProgressMonitor());
        monitor.setTaskName(Messages.TimeLapseEditor_LoadingHistory);
        ArrayList<IP4Revision> depotRevisions = new ArrayList<IP4Revision>();
        IFileRevision[] iFileRevisionArray = allHistory;
        int n = allHistory.length;
        int n2 = 0;
        while (n2 < n) {
            IFileRevision rev = iFileRevisionArray[n2];
            if (rev instanceof IP4Revision) {
                depotRevisions.add(0, (IP4Revision)rev);
            }
            ++n2;
        }
        Collections.sort(depotRevisions);
        this.history = depotRevisions.toArray(new IP4Revision[depotRevisions.size()]);
    }

    private void displayLoading() {
        ((StackLayout)this.outer.getLayout()).topControl = this.loadingArea;
        this.outer.layout(true, true);
    }

    private void displayEditor() {
        GridLayout maLayout = new GridLayout(1, true);
        maLayout.marginHeight = 0;
        maLayout.marginWidth = 0;
        maLayout.verticalSpacing = 2;
        this.mainArea = new Composite((Composite)this.displayArea, 0);
        this.mainArea.setLayout((Layout)maLayout);
        this.mainArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.slider = this.createSlider(this.mainArea, this.getFile());
        this.configureSlider(this.slider);
        this.fillToolbar(this.slider.getToolbar());
        this.createHeader(this.mainArea);
        this.createViewer(this.mainArea);
        this.changelistArea = new TimeLapseChangelistWidget((Composite)this.displayArea);
        this.displayArea.setWeights(SASH_WEIGHTS);
        boolean showChangelist = PerforceUIPlugin.getPlugin().getPreferenceStore().getBoolean(SHOW_CHANGELIST);
        if (showChangelist) {
            this.displayArea.setMaximizedControl(null);
        } else {
            this.displayArea.setMaximizedControl((Control)this.mainArea);
        }
        this.showEditor();
    }

    private void showEditor() {
        ((StackLayout)this.outer.getLayout()).topControl = this.displayArea;
        this.outer.layout(true, true);
    }

    protected TimeLapseSlider getSlider() {
        return this.slider;
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    private TimeLapseSlider createSlider(Composite parent, IP4File file) {
        TimeLapseSlider slider = new TimeLapseSlider(this.history);
        slider.setDrawDecorations(this.showActions);
        slider.createControl(parent);
        slider.setListener(new TimeLapseSlider.IRevisionListener(){

            @Override
            public void revisionChanged(IP4Revision revision) {
                TimeLapseEditor.this.showRevision(revision);
            }

            @Override
            public void displayChanged(IAnnotateModel.Type type) {
                TimeLapseEditor.this.updateDisplay(type);
            }
        });
        return slider;
    }

    protected void updateDisplay(IAnnotateModel.Type type) {
        this.type = type;
    }

    protected IAnnotateModel.Type getDisplayType() {
        return this.type;
    }

    public boolean isSettingInput() {
        return this.settingInput;
    }

    private void showRevision(IP4Revision newRevision) {
        if (newRevision != this.revision) {
            this.settingInput = true;
            try {
                this.revision = newRevision;
                if (this.displayArea.getMaximizedControl() == null) {
                    this.changelistArea.showRevision(this.revision);
                }
                IStorageEditorInput input = this.getRevisionInput(this.revision);
                this.updateDocument((IEditorInput)input);
            }
            finally {
                this.settingInput = false;
            }
        }
    }

    protected abstract IStorageEditorInput generateInput(IP4Revision var1);

    @Override
    public IStorageEditorInput getRevisionInput(IP4Revision revision) {
        IStorageEditorInput input = null;
        Map<IP4Revision, IStorageEditorInput> cache = this.inputCache;
        if (cache != null && (input = cache.get(revision)) == null) {
            block15: {
                input = this.generateInput(revision);
                InputStream in = null;
                try {
                    try {
                        in = input.getStorage().getContents();
                    }
                    catch (CoreException e) {
                        PerforceProviderPlugin.logError((Throwable)e);
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException e2) {
                                PerforceProviderPlugin.logError((Throwable)e2);
                            }
                        }
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            PerforceProviderPlugin.logError((Throwable)e);
                        }
                    }
                    throw throwable;
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        PerforceProviderPlugin.logError((Throwable)e);
                    }
                }
            }
            cache.put(revision, input);
        }
        return input;
    }

    protected void dispose(IEditorInput input) {
    }

    @Override
    public void clear() {
        if (this.inputCache != null) {
            for (IEditorInput iEditorInput : this.inputCache.values()) {
                this.dispose(iEditorInput);
            }
            this.inputCache.clear();
        }
    }

    public void dispose() {
        super.dispose();
        this.clear();
        this.inputCache = null;
        if (this.decorator != null) {
            this.decorator.dispose();
        }
    }

    private void setImage() {
        ImageDescriptor descriptor = this.getEditorInput().getImageDescriptor();
        if (descriptor != null) {
            Image editorImage = descriptor.createImage();
            this.setTitleImage(editorImage);
            P4UIUtils.registerDisposal((Widget)this.displayArea, (Resource)editorImage);
        }
    }

    private void createLoadingArea(Composite parent) {
        this.loadingArea = new Composite(parent, 0);
        ((StackLayout)parent.getLayout()).topControl = this.loadingArea;
        this.loadingArea.setLayout((Layout)new GridLayout(1, true));
        this.loadingArea.setLayoutData((Object)new GridData(4, 4, true, true));
        Label loadingLabel = new Label(this.loadingArea, 0);
        loadingLabel.setText(Messages.TimeLapseEditor_LoadingTimelapseView);
        ProgressBar loadingBar = new ProgressBar(this.loadingArea, 258);
        loadingBar.setLayoutData((Object)new GridData(4, 4, true, false));
        loadingBar.setEnabled(true);
    }

    protected abstract void createHeader(Composite var1);

    public void createPartControl(Composite parent) {
        this.setImage();
        this.setPartName(this.getFile().getName());
        this.outer = new Composite(parent, 0);
        StackLayout oLayout = new StackLayout();
        oLayout.marginHeight = 0;
        oLayout.marginWidth = 0;
        this.outer.setLayout((Layout)oLayout);
        this.outer.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createLoadingArea(this.outer);
        this.displayArea = new SashForm(this.outer, 512);
        this.displayArea.setBackground(this.displayArea.getDisplay().getSystemColor(16));
        GridLayout daLayout = new GridLayout(1, true);
        daLayout.marginHeight = 0;
        daLayout.marginWidth = 0;
        this.displayArea.setLayout((Layout)daLayout);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.startEditorLoad(new Runnable(){

            @Override
            public void run() {
                if (!TimeLapseEditor.this.displayArea.isDisposed()) {
                    TimeLapseEditor.this.preUpdateEditor();
                    TimeLapseEditor.this.displayEditor();
                    TimeLapseEditor.this.updateEditor();
                    TimeLapseEditor.this.showRevision(TimeLapseEditor.this.history[TimeLapseEditor.this.history.length - 1]);
                } else {
                    TimeLapseEditor.this.clear();
                }
            }
        });
    }

    private IP4Revision findRevision(IP4Revision revision) {
        if (revision != null) {
            IP4Revision[] revisions = this.getRevisions();
            int i = 0;
            while (i < revisions.length) {
                if (revision.getContentIdentifier().equals(revisions[i].getContentIdentifier())) {
                    return revisions[i];
                }
                ++i;
            }
        }
        return null;
    }

    protected void configureSlider(TimeLapseSlider slider) {
        if (this.decorator != null) {
            this.decorator.dispose();
        }
        this.decorator = new ActionTickDecorator();
        slider.setDecorator(this.decorator);
    }

    protected void fillToolbar(ToolBar toolbar) {
        final ToolItem branchesItem = new ToolItem(toolbar, 32);
        Image branchesImage = PerforceUIPlugin.getPlugin().getImageDescriptor("normal/branches.png").createImage();
        P4UIUtils.registerDisposal((Widget)branchesItem, (Resource)branchesImage);
        branchesItem.setToolTipText(Messages.TimeLapseEditor_ShowBranchingHistory);
        branchesItem.setImage(branchesImage);
        branchesItem.setSelection(this.branch);
        if (!((TimeLapseInput)this.getEditorInput()).enableBranchHistoy()) {
            branchesItem.setSelection(false);
            branchesItem.setEnabled(false);
        }
        branchesItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimeLapseEditor.this.branch = branchesItem.getSelection();
                PerforceUIPlugin.getPlugin().getPreferenceStore().setValue(TimeLapseEditor.SHOW_BRANCH_HISTORY, TimeLapseEditor.this.branch);
                TimeLapseEditor.this.preserveSelectionLoad();
            }
        });
        final ToolItem changelistItem = new ToolItem(toolbar, 32);
        Image submittedImage = PerforceUIPlugin.getPlugin().getImageDescriptor("perforce/submitted.png").createImage();
        P4UIUtils.registerDisposal((Widget)changelistItem, (Resource)submittedImage);
        changelistItem.setToolTipText(Messages.TimeLapseEditor_DisplayRevisionDetails);
        changelistItem.setImage(submittedImage);
        changelistItem.setSelection(PerforceUIPlugin.getPlugin().getPreferenceStore().getBoolean(SHOW_CHANGELIST));
        changelistItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (changelistItem.getSelection()) {
                    TimeLapseEditor.this.changelistArea.showRevision(TimeLapseEditor.this.getRevision());
                    TimeLapseEditor.this.displayArea.setMaximizedControl(null);
                } else {
                    TimeLapseEditor.this.displayArea.setMaximizedControl((Control)TimeLapseEditor.this.mainArea);
                }
                PerforceUIPlugin.getPlugin().getPreferenceStore().setValue(TimeLapseEditor.SHOW_CHANGELIST, changelistItem.getSelection());
            }
        });
        final ToolItem actionsItem = new ToolItem(toolbar, 32);
        Image actionsImage = PerforceUIPlugin.getPlugin().getImageDescriptor("normal/show_actions.png").createImage();
        P4UIUtils.registerDisposal((Widget)actionsItem, (Resource)actionsImage);
        actionsItem.setToolTipText(Messages.TimeLapseEditor_DisplayActionIcons);
        actionsItem.setImage(actionsImage);
        actionsItem.setSelection(PerforceUIPlugin.getPlugin().getPreferenceStore().getBoolean(SHOW_FILE_ACTIONS));
        actionsItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimeLapseEditor.this.showActions = actionsItem.getSelection();
                TimeLapseEditor.this.getSlider().setDrawDecorations(TimeLapseEditor.this.showActions);
                PerforceUIPlugin.getPlugin().getPreferenceStore().setValue(TimeLapseEditor.SHOW_FILE_ACTIONS, TimeLapseEditor.this.showActions);
            }
        });
    }

    protected abstract void updateDocument(IEditorInput var1);

    protected abstract void createViewer(Composite var1);

    public void setFocus() {
        this.displayArea.setFocus();
    }

    protected void preserveSelectionLoad() {
        this.displayLoading();
        this.startEditorLoad(new Runnable(){

            @Override
            public void run() {
                if (!TimeLapseEditor.this.displayArea.isDisposed()) {
                    IP4Revision newRevision = TimeLapseEditor.this.findRevision(TimeLapseEditor.this.getRevision());
                    TimeLapseEditor.this.preUpdateEditor();
                    TimeLapseEditor.this.configureSlider(TimeLapseEditor.this.slider);
                    TimeLapseEditor.this.slider.resetRevisions(TimeLapseEditor.this.history, newRevision);
                    if (newRevision != null) {
                        TimeLapseEditor.this.showRevision(newRevision);
                    } else {
                        TimeLapseEditor.this.showRevision(TimeLapseEditor.this.history[TimeLapseEditor.this.history.length - 1]);
                    }
                    TimeLapseEditor.this.showEditor();
                    TimeLapseEditor.this.updateEditor();
                } else {
                    TimeLapseEditor.this.clear();
                }
            }
        });
    }

    protected void preUpdateEditor() {
    }

    protected void updateEditor() {
    }

    protected IP4File getFile() {
        return ((TimeLapseInput)this.getEditorInput()).getFile();
    }

    public void addListener(ITimeLapseListener listener) {
        if (listener != null) {
            this.listeners.add((Object)listener);
        }
    }

    public void removeListener(ITimeLapseListener listener) {
        if (listener != null) {
            this.listeners.remove((Object)listener);
        }
    }

    private void notifyLoaded() {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ITimeLapseListener)listener).loaded(this);
            ++n2;
        }
    }
}

