/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.synchronize;

import com.perforce.team.core.PerforceProviderPlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;

public class SyncActionGroupRegistry {
    public static final String SYNCHRONIZE_POINT = "com.perforce.team.ui.synchronize";
    public static final String ACTIONS_ELEMENT = "actions";
    public static final String CLASS_ATTRIBUTE = "class";
    private static SyncActionGroupRegistry registry = null;
    private List<IConfigurationElement> actionGroups = new ArrayList<IConfigurationElement>();

    public static SyncActionGroupRegistry getRegistry() {
        if (registry == null) {
            registry = new SyncActionGroupRegistry();
        }
        return registry;
    }

    public SyncActionGroupRegistry() {
        this(SYNCHRONIZE_POINT);
    }

    public SyncActionGroupRegistry(String extensionPoint) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(extensionPoint);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String className;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (ACTIONS_ELEMENT.equals(element.getName()) && (className = element.getAttribute(CLASS_ATTRIBUTE)) != null) {
                try {
                    Object group = element.createExecutableExtension(CLASS_ATTRIBUTE);
                    if (group instanceof SynchronizePageActionGroup) {
                        this.actionGroups.add(element);
                    }
                }
                catch (CoreException e) {
                    PerforceProviderPlugin.logError((Throwable)e);
                }
            }
            ++n2;
        }
    }

    public SynchronizePageActionGroup[] generateGroups() {
        ArrayList<SynchronizePageActionGroup> groups = new ArrayList<SynchronizePageActionGroup>();
        for (IConfigurationElement element : this.actionGroups) {
            try {
                SynchronizePageActionGroup group = (SynchronizePageActionGroup)element.createExecutableExtension(CLASS_ATTRIBUTE);
                if (group == null) continue;
                groups.add(group);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return groups.toArray(new SynchronizePageActionGroup[groups.size()]);
    }
}

