/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.synchronize;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.synchronize.P4PendingChangeSet;
import com.perforce.team.core.p4java.synchronize.PerforceSyncInfo;
import com.perforce.team.ui.changelists.ISubmitMessageProvider;
import com.perforce.team.ui.p4java.actions.SubmitAction;
import com.perforce.team.ui.synchronize.PerforceSyncModelOperation;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class CommitModelOperation
extends PerforceSyncModelOperation {
    private boolean showDialog = true;
    private boolean reopen = false;
    private String description = null;
    private IStructuredSelection selection = null;

    public CommitModelOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        this(configuration, elements, null);
    }

    public CommitModelOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements, IStructuredSelection selection) {
        super(configuration, elements);
        this.selection = selection;
    }

    private ISubmitMessageProvider generateMessageProvider() {
        if (this.selection != null) {
            final HashMap<IP4PendingChangelist, P4PendingChangeSet> changesets = new HashMap<IP4PendingChangelist, P4PendingChangeSet>();
            ChangeSet set = null;
            Object[] objectArray = this.selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IP4PendingChangelist list;
                P4PendingChangeSet pendingSet;
                Object element = objectArray[n2];
                set = (ChangeSet)P4CoreUtils.convert((Object)element, ChangeSet.class);
                if (set instanceof P4PendingChangeSet && (pendingSet = (P4PendingChangeSet)set).useCommentOnSubmit() && (list = pendingSet.getChangelist()) != null) {
                    changesets.put(list, pendingSet);
                }
                ++n2;
            }
            if (changesets.size() > 0) {
                return new ISubmitMessageProvider(){

                    @Override
                    public String getDescription(IP4PendingChangelist list) {
                        P4PendingChangeSet set = (P4PendingChangeSet)changesets.get(list);
                        return set != null ? set.getComment() : null;
                    }
                };
            }
        }
        return null;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        P4Collection collection = this.createCollection();
        SyncInfo[] syncInfoArray = this.getSyncInfoSet().getSyncInfos();
        int n = syncInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            SyncInfo element = syncInfoArray[n2];
            if (element instanceof PerforceSyncInfo) {
                collection.add((IP4Resource)((PerforceSyncInfo)element).getP4File());
            }
            ++n2;
        }
        HashSet<IP4Connection> connections = new HashSet<IP4Connection>();
        IP4Resource[] iP4ResourceArray = collection.members();
        int n3 = iP4ResourceArray.length;
        n = 0;
        while (n < n3) {
            IP4Resource resource = iP4ResourceArray[n];
            IP4Connection connection = resource.getConnection();
            if (connection != null) {
                connections.add(connection);
            }
            ++n;
        }
        SubmitAction action = new SubmitAction();
        action.setAsync(false);
        action.setCollection(collection);
        action.setDescription(this.description);
        action.setReopen(this.reopen);
        action.setMonitor(monitor);
        action.setMessageProvider(this.generateMessageProvider());
        action.runAction(this.showDialog);
        P4Collection selectionCollection = action.getSelected();
        if (selectionCollection != null) {
            SyncInfo[] syncInfoArray2 = this.getSyncInfoSet().getSyncInfos();
            int n4 = syncInfoArray2.length;
            int n5 = 0;
            while (n5 < n4) {
                IP4File file;
                SyncInfo element = syncInfoArray2[n5];
                if (element instanceof PerforceSyncInfo && (file = ((PerforceSyncInfo)element).getP4File()) != null && !file.isOpened() && selectionCollection.contains((IP4Resource)file)) {
                    try {
                        element.getLocal().refreshLocal(1, null);
                    }
                    catch (CoreException e) {
                        PerforceProviderPlugin.logError((Throwable)e);
                    }
                    this.updateSyncState(element.getLocal());
                }
                ++n5;
            }
        }
    }

    public boolean isShowDialog() {
        return this.showDialog;
    }

    public void setShowDialog(boolean showDialog) {
        this.showDialog = showDialog;
    }

    public boolean isReopen() {
        return this.reopen;
    }

    public void setReopen(boolean reopen) {
        this.reopen = reopen;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

