/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.swarmreview.restapi;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.perforce.team.ui.swarmreview.restapi.APIConnector;
import com.perforce.team.ui.swarmreview.restapi.APIException;
import com.perforce.team.ui.swarmreview.restapi.AuthScheme;
import com.perforce.team.ui.swarmreview.restapi.JsonString;
import com.perforce.team.ui.swarmreview.restapi.Response;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.SSLHandshakeException;
import javax.xml.bind.DatatypeConverter;

public class APIClient {
    private String URL;
    private String authScheme;
    private String authValue;
    private String method;
    private String body;
    private String disableAuth = System.getProperty("disableAuth", "false");
    private APIConnector connector = APIConnector.getConnector();

    public APIClient get(String URL2) {
        this.URL = URL2;
        this.method = "GET";
        return this;
    }

    public APIClient post(String URL2, String body) {
        this.URL = URL2;
        this.method = "POST";
        this.body = body;
        return this;
    }

    public APIClient head(String URL2) {
        this.URL = URL2;
        this.method = "HEAD";
        return this;
    }

    public APIClient withValues(String method, String URL2, String params, String filter) {
        this.method = method;
        this.URL = URL2;
        return this.withQueryParams(params).withFilter(filter);
    }

    private APIClient withQueryParams(String params) {
        if ("GET".equals(this.method) && params != null && !params.isEmpty()) {
            this.URL = String.valueOf(this.URL) + "?" + params;
        }
        if ("POST".equals(this.method) && params != null && !params.isEmpty()) {
            this.body = params;
        }
        return this;
    }

    private APIClient withFilter(String filter) {
        if ("GET".equals(this.method) && filter != null && !filter.isEmpty()) {
            this.URL = String.valueOf(this.URL) + "&" + filter;
        }
        return this;
    }

    public APIClient withAuth(AuthScheme scheme, String value) {
        if (!Boolean.parseBoolean(this.disableAuth)) {
            this.authScheme = scheme.getSchemeName();
            this.authValue = value;
        }
        return this;
    }

    public APIClient secure(boolean secure) {
        this.connector.setIgnoreSSLValidation(secure);
        return this;
    }

    public Response<String> doHEAD() throws IOException {
        HttpURLConnection connection = this.connect(this.URL);
        connection.setRequestMethod(this.method);
        int rescode = connection.getResponseCode();
        Response<Object> response = new Response<Object>(rescode, connection.getResponseMessage(), null);
        return response;
    }

    public Response<JsonString> ping(String URL2) throws Exception {
        Response<JsonString> response = new Response<JsonString>(200, "", new JsonString(""));
        response = this.get(URL2).asJsonStringResponse();
        return response;
    }

    private void doPost(HttpURLConnection connection) throws IOException {
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        connection.setRequestProperty("Accept", "application/json");
        OutputStream os = connection.getOutputStream();
        os.write(this.body.getBytes());
        os.flush();
    }

    private void doGet(HttpURLConnection connection) throws IOException {
        connection.setRequestProperty("Accept", "/");
    }

    private Response<JsonString> generateJSONResponse(HttpURLConnection connection, Integer ... expectedResponse) throws IOException {
        Response<JsonString> response;
        int rescode = connection.getResponseCode();
        String resMsg = connection.getResponseMessage();
        boolean validResponse = new ArrayList<Integer>(Arrays.asList(expectedResponse)).contains(rescode);
        if (!validResponse) {
            JsonString js = this.prepareJsonString(connection.getErrorStream());
            response = new Response<JsonString>(rescode, resMsg, js);
        } else {
            JsonString js = this.prepareJsonString(connection.getInputStream());
            response = new Response<JsonString>(rescode, resMsg, js);
        }
        return response;
    }

    private Response<String> generateStringResponse(HttpURLConnection connection, Integer ... expectedResponse) throws IOException {
        Response<String> response;
        int rescode = connection.getResponseCode();
        String resMsg = connection.getResponseMessage();
        boolean validResponse = new ArrayList<Integer>(Arrays.asList(expectedResponse)).contains(rescode);
        if (!validResponse) {
            String js = this.prepareString(connection.getErrorStream());
            response = new Response<String>(rescode, resMsg, js);
        } else {
            String js = this.prepareString(connection.getInputStream());
            response = new Response<String>(rescode, resMsg, js);
        }
        return response;
    }

    private JsonString prepareJsonString(InputStream is) throws IOException {
        JsonString js = new JsonString("");
        if (is != null) {
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            try {
                Gson gson = new Gson();
                String jsonStr = ((JsonElement)gson.fromJson((Reader)br, JsonElement.class)).toString();
                js = new JsonString(jsonStr);
            }
            catch (JsonSyntaxException jsex) {
                js = new JsonString("Not in JSON format : " + this.prepareString(is));
            }
            catch (JsonIOException jioex) {
                js = new JsonString("Not in JSON format : " + this.prepareString(is));
            }
        }
        return js;
    }

    private String prepareString(InputStream is) throws IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String streamVal = "";
        while ((streamVal = br.readLine()) != null) {
            sb.append(streamVal);
        }
        return streamVal;
    }

    private HttpURLConnection connect(String URL2) throws IOException {
        this.connector.connect(URL2);
        HttpURLConnection connection = this.connector.getConnection();
        if (connection == null) {
            throw new RuntimeException("Unable to connect");
        }
        return connection;
    }

    public Response<JsonString> asJsonStringResponse() throws APIException {
        Response<JsonString> response;
        block11: {
            response = null;
            try {
                HttpURLConnection connection = this.connect(this.URL);
                connection.setRequestMethod(this.method);
                if (this.authScheme != null && this.authValue != null && !Boolean.parseBoolean(this.disableAuth)) {
                    String authEncoded = DatatypeConverter.printBase64Binary((byte[])this.authValue.getBytes());
                    connection.setRequestProperty("Authorization", String.valueOf(this.authScheme) + " " + authEncoded);
                }
                if ("POST".equalsIgnoreCase(this.method)) {
                    this.doPost(connection);
                    response = this.generateJSONResponse(connection, 201, 200);
                    break block11;
                }
                this.doGet(connection);
                Response<JsonString> response2 = response = this.generateJSONResponse(connection, 200);
                return response2;
            }
            catch (ConnectException cex) {
                throw new APIException("Could not connect to P4 Code Review server. ", cex, 0);
            }
            catch (ProtocolException ex) {
                throw new APIException("Invalid protocol", ex, 0);
            }
            catch (SSLHandshakeException ex) {
                throw new APIException("Unable to execute request over SSL. SSL handshake failed", ex, 0);
            }
            catch (IOException ex) {
                throw new APIException("Unable to talk to server", ex, 0);
            }
            finally {
                if (this.connector != null && this.connector.getConnection() != null) {
                    this.connector.getConnection().disconnect();
                }
            }
        }
        return response;
    }

    public Response<String> asStringResponse() throws APIException {
        Response<String> response = null;
        try {
            try {
                HttpURLConnection connection = this.connect(this.URL);
                connection.setRequestMethod(this.method);
                if (this.authScheme != null && this.authValue != null) {
                    String authEncoded = DatatypeConverter.printBase64Binary((byte[])this.authValue.getBytes());
                    connection.setRequestProperty("Authorization", String.valueOf(this.authScheme) + " " + authEncoded);
                }
                if ("POST".equalsIgnoreCase(this.method)) {
                    this.doPost(connection);
                    response = this.generateStringResponse(connection, 201, 200);
                } else {
                    this.doGet(connection);
                    response = this.generateStringResponse(connection, 200);
                }
            }
            catch (ConnectException ex) {
                throw new APIException("Could not connect to P4 Code Review server. ", ex, 0);
            }
            catch (ProtocolException ex) {
                throw new APIException("Invalid protocol", ex, 0);
            }
            catch (SSLHandshakeException ex) {
                throw new APIException("Unable to execute request over SSL. SSL handshake failed", ex, 0);
            }
            catch (IOException ex) {
                throw new APIException("Unable to talk to server", ex, 0);
            }
        }
        finally {
            if (this.connector != null && this.connector.getConnection() != null) {
                this.connector.getConnection().disconnect();
            }
        }
        return response;
    }
}

