/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.swarmreview.dialogs;

import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.ui.swarmreview.ReviewManager;
import com.perforce.team.ui.swarmreview.ReviewerUser;
import com.perforce.team.ui.swarmreview.ReviewerUserList;
import com.perforce.team.ui.swarmreview.dialogs.NewReviewDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class SelectUsersDialog<T extends IP4Changelist>
extends Dialog {
    private Table reviewerTable;
    private ReviewManager<T> controller;
    private NewReviewDialog<T> parent;

    public SelectUsersDialog(NewReviewDialog<T> parent) {
        super(parent.getShell());
        this.parent = parent;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        this.createUsersGrid(container);
        return container;
    }

    public void setSwarmReviewDialogController(ReviewManager<T> controller) {
        this.controller = controller;
        controller.initReviewers();
    }

    private void createOutlineDataComposite(Composite parent) {
        Composite outlineDataComposite = new Composite(parent, 0);
        outlineDataComposite.setLayout((Layout)new GridLayout(4, false));
        GridData gd_outlineDataComposite = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_outlineDataComposite.widthHint = 831;
        gd_outlineDataComposite.heightHint = 168;
        outlineDataComposite.setLayoutData((Object)gd_outlineDataComposite);
        Label lblUser = new Label(outlineDataComposite, 0);
        lblUser.setText("User:");
        Label lblNewLabel = new Label(outlineDataComposite, 0);
        GridData gd_lblNewLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblNewLabel.widthHint = 228;
        gd_lblNewLabel.minimumWidth = 500;
        lblNewLabel.setLayoutData((Object)gd_lblNewLabel);
        Label lblFullBame = new Label(outlineDataComposite, 0);
        lblFullBame.setText("Full name:");
        Label lblNewLabel_1 = new Label(outlineDataComposite, 0);
        GridData gd_lblNewLabel_1 = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblNewLabel_1.widthHint = 145;
        lblNewLabel_1.setLayoutData((Object)gd_lblNewLabel_1);
        Label lblEmail = new Label(outlineDataComposite, 0);
        lblEmail.setText("Email:");
        Label lblNewLabel_5 = new Label(outlineDataComposite, 0);
        Label lblAuthMethod = new Label(outlineDataComposite, 0);
        lblAuthMethod.setText("Auth method:");
        Label lblNewLabel_7 = new Label(outlineDataComposite, 0);
        Label lblDateModified = new Label(outlineDataComposite, 0);
        lblDateModified.setText("Date modified:");
        Label lblNewLabel_2 = new Label(outlineDataComposite, 0);
        Label lblType = new Label(outlineDataComposite, 0);
        lblType.setText("Type:");
        Label lblNewLabel_3 = new Label(outlineDataComposite, 0);
        Label lblDateAccessd = new Label(outlineDataComposite, 0);
        lblDateAccessd.setText("Date Accessd:");
        Label lblNewLabel_6 = new Label(outlineDataComposite, 0);
        Label lblNewLabel_4 = new Label(outlineDataComposite, 0);
        lblNewLabel_4.setText("New Label");
        Label lblNewLabel_8 = new Label(outlineDataComposite, 0);
    }

    private TableViewerColumn createTableViewerColumn(TableViewer viewer, String title, int bound, int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    private void createUsersGrid(Composite parent) {
        String[] titles = new String[]{"User", "Email", "Full Name"};
        int[] bounds = new int[]{100, 300, 300};
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData gd_composite = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_composite.widthHint = 828;
        composite.setLayoutData((Object)gd_composite);
        TableViewer tableViewer = new TableViewer(composite, 67586);
        this.reviewerTable = tableViewer.getTable();
        this.reviewerTable.setHeaderVisible(true);
        GridData gd_table = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_table.heightHint = 230;
        gd_table.widthHint = 800;
        this.reviewerTable.setLayoutData((Object)gd_table);
        TableViewerColumn col = this.createTableViewerColumn(tableViewer, titles[0], bounds[0], 0);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ReviewerUser) {
                    return ((ReviewerUser)element).getLogin();
                }
                return null;
            }
        });
        col = this.createTableViewerColumn(tableViewer, titles[1], bounds[1], 1);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ReviewerUser) {
                    return ((ReviewerUser)element).getEmail();
                }
                return null;
            }
        });
        col = this.createTableViewerColumn(tableViewer, titles[2], bounds[2], 2);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ReviewerUser) {
                    return ((ReviewerUser)element).getFullName();
                }
                return null;
            }
        });
        tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        tableViewer.setInput((Object)this.controller.getReviewerUsers().toArray());
    }

    public void okPressed() {
        TableItem[] selectedItems = this.reviewerTable.getSelection();
        if (selectedItems != null && selectedItems.length > 0) {
            ReviewerUserList reviewers = new ReviewerUserList();
            if (selectedItems != null && selectedItems.length > 0) {
                TableItem[] tableItemArray = selectedItems;
                int n = selectedItems.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem tableItem = tableItemArray[n2];
                    ReviewerUser userSummary = (ReviewerUser)tableItem.getData();
                    reviewers.addReviewer(userSummary);
                    ++n2;
                }
            }
            this.controller.addReviewerUsers(reviewers);
            this.parent.updateReviewerGrid(this.controller.getSelectedReviewerUsers().toArray());
        }
        super.okPressed();
        this.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(838, 331);
    }
}

