/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.swarmreview;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4SubmittedChangelist;
import com.perforce.team.core.p4java.P4SubmittedFile;
import com.perforce.team.ui.swarmreview.ReviewManager;
import com.perforce.team.ui.swarmreview.SubmittedReviewModel;
import com.perforce.team.ui.swarmreview.restapi.APIException;
import com.perforce.team.ui.swarmreview.restapi.Result;
import java.util.ArrayList;

public class SubmittedReviewManager
extends ReviewManager<IP4SubmittedChangelist> {
    private static ReviewManager<IP4SubmittedChangelist> managerInstance = new SubmittedReviewManager();

    public static ReviewManager<IP4SubmittedChangelist> getInstance(IP4Connection connection) {
        SubmittedReviewManager.managerInstance.connection = connection;
        return managerInstance;
    }

    @Override
    public void init(IP4SubmittedChangelist pendingChangeList, boolean clearState) {
        if (this.model == null) {
            this.model = SubmittedReviewModel.getNewInstance();
        }
        this.clearState();
        this.populateCurrentChangelistItems(pendingChangeList);
        if (this.connection == null && pendingChangeList != null) {
            this.connection = pendingChangeList.getConnection();
        }
        this.ignoreSSL = this.connection.getParameters().isIgnoreSSLValidation();
    }

    @Override
    void populateCurrentChangelistItems(IP4SubmittedChangelist pendingChangeList) {
        ArrayList<P4SubmittedFile> ip4Changes = new ArrayList<P4SubmittedFile>();
        if (pendingChangeList != null) {
            IP4Resource[] changeListData = pendingChangeList.getFiles();
            if (changeListData != null) {
                IP4Resource[] iP4ResourceArray = changeListData;
                int n = changeListData.length;
                int n2 = 0;
                while (n2 < n) {
                    IP4Resource file = iP4ResourceArray[n2];
                    if (file instanceof P4SubmittedFile) {
                        ip4Changes.add((P4SubmittedFile)file);
                    }
                    ++n2;
                }
            }
            P4SubmittedFile[] ip4Array = ip4Changes.toArray(new P4SubmittedFile[ip4Changes.size()]);
            this.model.setFilesInSelectedChangelist((IP4Resource[])ip4Array);
            this.model.setPendingChangeList(pendingChangeList);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Result<Boolean> requestReview(Object[] checkedFiles, String description) {
        changelist = null;
        isNewReview = true;
        result = new Result<T>(true, "");
        try {
            result = this.canWeConnectToSwarm();
            if (!result.isSuccessful()) {
                var16_6 = result;
                return var16_6;
            }
            this.model.setSelectedChangelistData(checkedFiles);
            changelist = ((IP4SubmittedChangelist)this.model.getPendingChangeList()).getChangelist();
            path = String.valueOf(this.SWARM_API_PATH) + "/";
            param = "change=" + changelist.getId();
            reviewers = this.model.getSelectedReviewerUserList();
            reviewerParam = "";
            requiredReviewerParam = "";
            for (String reviewer : reviewers.getReviewersNotRequired()) {
                reviewerParam = String.valueOf(reviewerParam) + "reviewers[]=" + reviewer + "&";
            }
            for (String reviewer : reviewers.getRequiredReviewers()) {
                requiredReviewerParam = String.valueOf(requiredReviewerParam) + "requiredReviewers[]=" + reviewer + "&";
            }
            if (!isNewReview) ** GOTO lbl46
            searchedReviewId = null;
            searchedReviewId = this.model.getSearchedSwarmReviewId();
            if (searchedReviewId != null) {
                path = String.valueOf(path) + searchedReviewId + "/changes/";
            } else {
                if (!reviewerParam.isEmpty()) {
                    param = String.valueOf(param) + "&" + reviewerParam;
                }
                if (!requiredReviewerParam.isEmpty()) {
                    param = String.valueOf(param) + "&" + requiredReviewerParam;
                }
            }
            apiResult = this.callAPI("POST", path, param, null);
            if (!apiResult.isSuccessful()) {
                var16_7 = result.withNoSuccess("Unable to create review: " + apiResult.getMessage(), apiResult.isError(), false);
                return var16_7;
            }
            response = apiResult.getResultData();
            ok = response.isSuccessful();
            if (ok) {
                result.withSuccess("Review created", Boolean.TRUE);
                return result;
            }
            result.withNoSuccess("Unable to create review: " + response.getResponseMessage(), false, false);
            return result;
lbl46:
            // 1 sources

            result.withSuccess("Review updated", Boolean.TRUE);
            return result;
        }
        catch (APIException ex) {
            result.withNoSuccess(ex.getMessage(), true, false);
            return result;
        }
        catch (Exception ex) {
            e = new APIException("Unknown error", ex, -1);
            result.withNoSuccess(e.getMessage(), true, false);
            return result;
        }
        finally {
            this.clearState();
        }
    }

    @Override
    public boolean updateChangelist() {
        return false;
    }

    @Override
    public Result<Boolean> isChangeListCandidateForNewReview(IP4SubmittedChangelist currentSelection) {
        IP4SubmittedChangelist pendingChangeList = currentSelection;
        Result<Boolean> canContinue = this.canContinue();
        if (!canContinue.isSuccessful()) {
            return new Result<Boolean>(canContinue, canContinue.isSuccessful());
        }
        boolean hasReview = !this.isChangelistInReview(pendingChangeList);
        return new Result<Boolean>(hasReview).withValues(hasReview, false, "New Review support status: " + hasReview, false, hasReview);
    }

    @Override
    public Result<Boolean> isChangeListCandidateForUpdateReview(IP4SubmittedChangelist currentSelection) {
        IP4SubmittedChangelist pendingChangeList = currentSelection;
        Result<Boolean> canContinue = this.canContinue();
        if (!canContinue.isSuccessful()) {
            return new Result<Boolean>(canContinue, canContinue.isSuccessful());
        }
        boolean hasReview = !this.isChangelistInReview(pendingChangeList);
        return new Result<Boolean>(hasReview).withValues(hasReview, false, "Upate Review support status: " + hasReview, false, hasReview);
    }

    @Override
    public Result<Boolean> isOpenChange(IP4SubmittedChangelist currentSelection) {
        Result<Boolean> canContinue = this.canContinue();
        if (!canContinue.isSuccessful()) {
            return new Result<Boolean>(canContinue, canContinue.isSuccessful());
        }
        return new Result<Boolean>(true).withValues(true, false, "Open change supported", false, Boolean.TRUE);
    }

    @Override
    public Result<Boolean> isOpenReview(IP4SubmittedChangelist currentSelection) {
        IP4SubmittedChangelist pendingChangeList = currentSelection;
        Result<Boolean> canContinue = this.canContinue();
        if (!canContinue.isSuccessful()) {
            return new Result<Boolean>(canContinue, canContinue.isSuccessful());
        }
        boolean finalResult = this.isChangelistInReview(pendingChangeList);
        return new Result<Boolean>(finalResult).withValues(finalResult, false, "Open review support status: " + finalResult, false, finalResult);
    }
}

