/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.swarmreview;

import com.perforce.p4java.core.IUserSummary;
import com.perforce.team.ui.swarmreview.ReviewerUser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class ReviewerUserList
implements Serializable {
    private List<ReviewerUser> users = new ArrayList<ReviewerUser>();

    public ReviewerUserList() {
    }

    public ReviewerUserList(ReviewerUser ... users) {
        this.users.addAll(new ArrayList<ReviewerUser>(Arrays.asList(users)));
    }

    public ReviewerUserList(IUserSummary ... users) {
        if (users != null && users.length > 0) {
            IUserSummary[] iUserSummaryArray = users;
            int n = users.length;
            int n2 = 0;
            while (n2 < n) {
                IUserSummary user = iUserSummaryArray[n2];
                ReviewerUser ruser = new ReviewerUser(user);
                this.addReviewer(ruser);
                ++n2;
            }
        }
    }

    public ReviewerUserList(List<IUserSummary> users) {
        if (users != null && users.size() > 0) {
            for (IUserSummary user : users) {
                ReviewerUser ruser = new ReviewerUser(user);
                this.addReviewer(ruser);
            }
        }
    }

    public Iterator<ReviewerUser> iterator() {
        return this.users.iterator();
    }

    public void addReviewer(ReviewerUser reviwer) {
        this.users.add(reviwer);
    }

    public void addReviewers(ReviewerUserList reviewer) {
        this.users.addAll(reviewer.users);
    }

    public void removeReviewers(ReviewerUserList reviewer) {
        this.users.removeAll(reviewer.users);
    }

    public void removeReviewer(ReviewerUser reviewer) {
        this.users.remove(reviewer);
    }

    public void removeReviewer(int reviewerIndex) {
        this.users.remove(reviewerIndex);
    }

    public void clearList() {
        this.users.clear();
    }

    public int getSize() {
        return this.users.size();
    }

    public boolean isEmpty() {
        return this.users.isEmpty();
    }

    public ReviewerUser[] toArray() {
        ReviewerUser[] ruArray = new ReviewerUser[this.users.size()];
        ruArray = this.users.toArray(ruArray);
        return ruArray;
    }

    public List<String> getRequiredReviewers() {
        ArrayList<String> reuiredUsers = new ArrayList<String>();
        Iterator<ReviewerUser> it = this.iterator();
        while (it.hasNext()) {
            ReviewerUser user = it.next();
            if (!user.isRequired()) continue;
            reuiredUsers.add(user.getLogin());
        }
        return reuiredUsers;
    }

    public List<String> getReviewersNotRequired() {
        ArrayList<String> notReuiredUsers = new ArrayList<String>();
        Iterator<ReviewerUser> it = this.iterator();
        while (it.hasNext()) {
            ReviewerUser user = it.next();
            if (user.isRequired()) continue;
            notReuiredUsers.add(user.getLogin());
        }
        return notReuiredUsers;
    }

    public void addUnique(ReviewerUserList reviewers) {
        for (ReviewerUser ruser : reviewers.users) {
            boolean found = false;
            for (ReviewerUser newuser : this.users) {
                if (!newuser.equals(ruser)) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.users.add(ruser);
        }
    }
}

