/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.swarmreview;

import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4ShelvedChangelist;
import com.perforce.team.ui.swarmreview.PendingChangeListData;
import com.perforce.team.ui.swarmreview.ReviewerUserList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ReviewModel<T extends IP4Changelist> {
    private IP4Resource[] filesInSelectedChangelist;
    private IP4Resource[] filesInSelectedShelf;
    private ReviewerUserList reviewerUsers;
    private ReviewerUserList selectedReviewerUsers = new ReviewerUserList();
    private List<T> allP4ChangeLists = new ArrayList<T>();
    private Object[] selectedChangelistData;
    private String description;
    protected T changeList;
    protected IP4ShelvedChangelist shelvedChangeList;
    private Map<Integer, Integer> changeIdToSwarmReviewIdMap = new HashMap<Integer, Integer>();
    private List<Integer> changeIdsLinkedToSwarm = new ArrayList<Integer>();
    private Map<String, T> p4ChangeListIdToChangeListMap = new HashMap<String, T>();
    private Map<String, PendingChangeListData> changeListDataMap = new HashMap<String, PendingChangeListData>();
    private Map<Integer, ReviewerUserList> changeListIdToReviewerUserMap = new HashMap<Integer, ReviewerUserList>();
    private Integer searchedSwarmReviewId;
    private Integer swarmSpecificChangelistId;

    ReviewModel() {
    }

    public abstract T getPendingChangeList();

    public abstract void setPendingChangeList(T var1);

    public Map<String, PendingChangeListData> getChangeListDataMap() {
        return this.changeListDataMap;
    }

    public void addChangeListData(PendingChangeListData cld) {
        this.changeListDataMap.put(String.valueOf(String.valueOf(cld.getChangelistId())) + "@" + cld.getPendingChangeList().getClientName(), cld);
    }

    public PendingChangeListData getChangeListDataById(IP4PendingChangelist cld) {
        return this.changeListDataMap.get(String.valueOf(String.valueOf(cld.getId())) + "@" + cld.getClientName());
    }

    public void setShelvedChangeList(IP4ShelvedChangelist shelvedChangeList) {
        this.shelvedChangeList = shelvedChangeList;
    }

    public IP4ShelvedChangelist getShelvedChangeList() {
        return this.shelvedChangeList;
    }

    public void setChangeListIdToReviewerUserMap(Map<Integer, ReviewerUserList> rMap) {
        this.changeListIdToReviewerUserMap = rMap;
    }

    public Map<Integer, ReviewerUserList> getChangeListIdToReviewerUserMap() {
        return this.changeListIdToReviewerUserMap;
    }

    public List<T> getAllP4ChangeLists() {
        return this.allP4ChangeLists;
    }

    public void setAllP4ChangeLists(List<T> allChangeLists) {
        this.allP4ChangeLists = allChangeLists;
    }

    public Map<String, T> getP4ChangeListIdToChangeListMap() {
        return this.p4ChangeListIdToChangeListMap;
    }

    public void setP4ChangeListIdToChangeListMap(Map<String, T> changeListIdToChangeListMap) {
        this.p4ChangeListIdToChangeListMap = changeListIdToChangeListMap;
    }

    public void addP4Changelist(T changeList) {
        this.p4ChangeListIdToChangeListMap.put(String.valueOf(String.valueOf(changeList.getId())) + "@" + changeList.getClientName(), changeList);
    }

    public void addChangeIdsLinkedToSwarm(Integer swarmId, List<Integer> changes) {
        this.changeIdsLinkedToSwarm.addAll(changes);
        if (changes != null) {
            for (Integer changeid : changes) {
                this.changeIdToSwarmReviewIdMap.put(changeid, swarmId);
            }
        }
    }

    public void clearSwarmLinkedChangeCache() {
        this.changeIdsLinkedToSwarm.clear();
        this.changeIdToSwarmReviewIdMap.clear();
    }

    public Integer getSwarmReviewIdFor(Integer pendingChangeId) {
        return this.changeIdToSwarmReviewIdMap.get(pendingChangeId);
    }

    public boolean isChangeInReview(Integer changeId) {
        return this.changeIdsLinkedToSwarm.contains(changeId);
    }

    public List<Integer> getChangeListIdsLinkedToSwarm() {
        return this.changeIdsLinkedToSwarm;
    }

    public IP4Resource[] getFilesInSelectedChangelist() {
        return this.filesInSelectedChangelist;
    }

    public void setFilesInSelectedChangelist(IP4Resource[] changelistData) {
        this.filesInSelectedChangelist = changelistData;
    }

    public IP4Resource[] getFilesInSelectedShelf() {
        return this.filesInSelectedShelf;
    }

    public void setFilesInSelectedShelf(IP4Resource[] changelistData) {
        this.filesInSelectedShelf = changelistData;
    }

    public void setReviewerUsers(ReviewerUserList reviewerUserData) {
        this.reviewerUsers = reviewerUserData;
    }

    public ReviewerUserList getReviewerUsers() {
        return this.reviewerUsers;
    }

    public ReviewerUserList getSelectedReviewerUserList() {
        return this.selectedReviewerUsers;
    }

    public void setSelectedReviewerUserList(ReviewerUserList selectedReviewerUser) {
        this.selectedReviewerUsers = selectedReviewerUser;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Object[] getSelectedChangelistData() {
        return this.selectedChangelistData;
    }

    public void setSelectedChangelistData(Object[] selectedChangelistData) {
        this.selectedChangelistData = selectedChangelistData;
    }

    public Integer getSwarmSpecificChangelist() {
        return this.swarmSpecificChangelistId;
    }

    public void setSwarmSpecificChangelist(Integer updateReviewChangelist) {
        this.swarmSpecificChangelistId = updateReviewChangelist;
    }

    public Integer getSearchedSwarmReviewId() {
        return this.searchedSwarmReviewId;
    }

    public void setSearchedSwarmReviewId(Integer searchedSwarmReviewId) {
        this.searchedSwarmReviewId = searchedSwarmReviewId;
    }
}

