/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.swarmreview;

import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4ShelvedChangelist;
import java.util.Arrays;

public class PendingChangeListData {
    private IP4PendingChangelist pendingChangeList;
    private IP4ShelvedChangelist shelvedChangeList;
    private IP4Resource[] filesInPendingChangelist;
    private IP4Resource[] filesShelved;

    public PendingChangeListData(IP4PendingChangelist pendingChangeList, IP4ShelvedChangelist shelvedChangeList, IP4Resource[] filesInPendingChangelist, IP4Resource[] filesShelved) {
        this.pendingChangeList = pendingChangeList;
        this.filesInPendingChangelist = filesInPendingChangelist;
        this.shelvedChangeList = shelvedChangeList;
        this.filesShelved = filesShelved;
    }

    public IP4PendingChangelist getPendingChangeList() {
        return this.pendingChangeList;
    }

    public IP4Resource[] getFilesInPendingChangelist() {
        return this.filesInPendingChangelist;
    }

    public int getChangelistId() {
        return this.getPendingChangeList().getId();
    }

    public IP4Resource[] getFilesShelved() {
        return this.filesShelved;
    }

    public boolean hasShelvedFiles() {
        return this.filesShelved != null && this.filesShelved.length > 0;
    }

    public IP4ShelvedChangelist getShelvedChangeList() {
        return this.shelvedChangeList;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof PendingChangeListData) {
            Object[] clientPending = ((PendingChangeListData)obj).filesInPendingChangelist;
            Object[] clientShelved = ((PendingChangeListData)obj).filesShelved;
            boolean pendingsame = Arrays.equals(this.filesInPendingChangelist, clientPending);
            boolean shelvedsame = Arrays.equals(this.filesShelved, clientShelved);
            return pendingsame && shelvedsame;
        }
        return false;
    }

    public int hashcode() {
        return this.shelvedChangeList.hashCode() + this.filesShelved.hashCode();
    }
}

