/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.streams;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Stream;
import com.perforce.team.ui.streams.FilteredStreamsViewer;
import com.perforce.team.ui.views.IPerforceView;
import com.perforce.team.ui.views.Messages;
import com.perforce.team.ui.views.PerforceFilterViewControl;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;

public class StreamsViewControl
extends PerforceFilterViewControl
implements IPartListener2,
IPropertyChangeListener {
    public static final String DISPLAY_DETAILS = "com.perforce.team.ui.streams.display_details";
    public static final String HIDE_FILTERS = "com.perforce.team.ui.streams.HIDE_FILTERS";
    public static final String TREE_EXPAND = "com.perforce.team.ui.streams.expand_tree";
    private FilteredStreamsViewer streamsViewer;
    private boolean visible = false;

    protected void fillContextMenu(IMenuManager mgr) {
    }

    public boolean isShownUnloadedOnly() {
        return this.streamsViewer.getFilterModel().isShowUnloadedOnly();
    }

    public void setVisible(boolean show) {
        this.visible = show;
    }

    public StreamsViewControl(IPerforceView view) {
        super(view);
    }

    @Override
    public void setFocus() {
        if (this.streamsViewer != null) {
            this.streamsViewer.setFocus();
        }
    }

    @Override
    public void dispose() {
        this.removeProjectListeners();
        IWorkbenchPartSite site = this.getView().getSite();
        if (site != null) {
            site.getPage().removePartListener((IPartListener2)this);
        }
    }

    @Override
    public void refresh() {
        if (this.streamsViewer != null) {
            this.streamsViewer.refreshInput(false);
        }
    }

    @Override
    protected String getSelectedName() {
        return Messages.StreamsView_Streams;
    }

    public void showDisplayDetails(boolean checked) {
        this.streamsViewer.showDisplayDetails(checked);
    }

    public TreeViewer getTreeViewer() {
        return this.streamsViewer.getTreeViewer();
    }

    public IP4Stream getSelectedStream() {
        return this.streamsViewer.getSelectedStream();
    }

    public void enableAutoUpdate(boolean enable) {
        this.streamsViewer.enableAutoUpdate(enable);
    }

    public void enableDoubleClick(boolean enable) {
        if (enable) {
            this.streamsViewer.getTreeViewer().addDoubleClickListener((IDoubleClickListener)this.streamsViewer);
        } else {
            this.streamsViewer.getTreeViewer().removeDoubleClickListener((IDoubleClickListener)this.streamsViewer);
        }
    }

    @Override
    protected void createControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.perforce.team.ui.streams_view");
        this.streamsViewer = new FilteredStreamsViewer(this.getView().getSite());
        this.streamsViewer.createPartControl(parent);
        this.setFilterViewer(this.streamsViewer);
        this.addProjectListeners();
        this.createMenus();
        IWorkbenchPartSite site = this.getView().getSite();
        if (site != null) {
            site.getPage().addPartListener((IPartListener2)this);
        }
        IPreferenceStore store = StreamsViewControl.getPreferenceStore();
        store.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property == "pref_retrieve_num_streams" && this.streamsViewer != null) {
            this.getView().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    StreamsViewControl.this.streamsViewer.updateMoreLink();
                }
            });
        }
    }

    private void createMenus() {
        final Action showDetailsAction = new Action(Messages.StreamsView_ShowStreamDetails){

            public int getStyle() {
                return 2;
            }
        };
        showDetailsAction.setChecked(StreamsViewControl.getPreferenceStore().getBoolean(DISPLAY_DETAILS));
        showDetailsAction.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                StreamsViewControl.getPreferenceStore().setValue(StreamsViewControl.DISPLAY_DETAILS, showDetailsAction.isChecked());
                StreamsViewControl.this.streamsViewer.showDisplayDetails(showDetailsAction.isChecked());
            }
        });
        this.streamsViewer.showDisplayDetails(showDetailsAction.isChecked());
        IActionBars bars = this.getActionBars();
        if (bars != null) {
            IMenuManager pulldown = bars.getMenuManager();
            pulldown.add((IContributionItem)new Separator());
            pulldown.add((IAction)showDetailsAction);
            this.createFilterAction((IContributionManager)pulldown);
            pulldown.update(false);
            pulldown.add((IContributionItem)new Separator());
        }
    }

    @Override
    protected void setViewerInput(IP4Connection connection) {
        this.p4Connection = connection;
        if (this.visible && !this.updateStreams()) {
            this.showNoConnection();
        }
    }

    private boolean updateStreams() {
        if (this.connectionOK(this.p4Connection)) {
            IP4Connection viewerInput = this.streamsViewer.getConnection();
            if (viewerInput != this.p4Connection) {
                this.streamsViewer.clearFilter();
            }
            if (viewerInput != this.p4Connection) {
                this.refresh(true, true);
            }
            return true;
        }
        return false;
    }

    @Override
    protected String getFilterPreference() {
        return HIDE_FILTERS;
    }

    public void refresh(boolean clearCache, boolean retrieve) {
        if (!this.connectionOK(this.p4Connection)) {
            return;
        }
        if (clearCache) {
            this.streamsViewer.clearCache(this.p4Connection);
        }
        this.updateConnectionLabel();
        this.showDisplayArea();
        this.streamsViewer.setConnection(this.p4Connection);
        this.streamsViewer.refreshInput(retrieve);
    }

    public void collapseAll() {
        StreamsViewControl.getPreferenceStore().setValue(TREE_EXPAND, false);
        this.streamsViewer.expand();
    }

    public void expandAll() {
        StreamsViewControl.getPreferenceStore().setValue(TREE_EXPAND, true);
        this.streamsViewer.expand();
    }

    public void partActivated(IWorkbenchPartReference partRef) {
        if (partRef.getId().equals("com.perforce.team.ui.StreamsView")) {
            if (!this.visible) {
                this.updateStreams();
            }
            this.visible = true;
        }
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
        if (partRef.getId().equals("com.perforce.team.ui.StreamsView")) {
            this.visible = false;
        }
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        if (partRef.getId().equals("com.perforce.team.ui.StreamsView")) {
            if (!this.visible) {
                this.updateStreams();
            }
            this.visible = true;
        }
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }
}

