/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.streams;

import com.perforce.p4java.core.IMapEntry;
import com.perforce.p4java.core.IStream;
import com.perforce.p4java.core.IStreamIgnoredMapping;
import com.perforce.p4java.core.IStreamRemappedMapping;
import com.perforce.p4java.core.IStreamSummary;
import com.perforce.p4java.core.IStreamViewMapping;
import com.perforce.p4java.core.ViewMap;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.impl.generic.core.Stream;
import com.perforce.p4java.impl.generic.core.StreamSummary;
import com.perforce.team.core.P4LogUtils;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Stream;
import com.perforce.team.core.p4java.P4Depot;
import com.perforce.team.ui.PerforceUIPlugin;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;

public class StreamUtil {
    public static final String DELIMITER = " ";
    public static final String EXTRA_TAG_BASEPARENT = "baseParent";
    public static final String EXTRA_TAG_FIRMERTHANPARENT = "firmerThanParent";
    public static final String EXTRA_TAG_UNKNOW_VALUE = "n/a";
    public static final String DEFAULT_PARENT = "none";

    public static boolean connectionOK(IP4Connection connection) {
        return connection != null && !connection.isOffline() && !connection.isDisposed();
    }

    public static String getStreamClientView(IP4Stream stream) {
        List mappings = stream.getClientView();
        StringBuilder sb = new StringBuilder();
        for (String mapping : mappings) {
            sb.append(String.valueOf(mapping) + "\n");
        }
        return sb.toString();
    }

    public static String getRemmapedPaths(ViewMap<IStreamRemappedMapping> remap) {
        StringBuilder sb = new StringBuilder();
        for (IStreamRemappedMapping mapping : remap.getEntryList()) {
            String lhs = mapping.getLeftRemapPath();
            String rhs = mapping.getRightRemapPath();
            sb.append(String.valueOf(lhs == null ? "" : String.valueOf(lhs) + DELIMITER) + (rhs == null ? "" : rhs) + "\n");
        }
        return sb.toString();
    }

    public static String getIgnoredPatterns(ViewMap<IStreamIgnoredMapping> ignoreView) {
        StringBuilder sb = new StringBuilder();
        for (IStreamIgnoredMapping mapping : ignoreView.getEntryList()) {
            sb.append(String.valueOf(mapping.getIgnorePath()) + "\n");
        }
        return sb.toString();
    }

    public static String getStreamViewPaths(ViewMap<IStreamViewMapping> viewMap) {
        StringBuilder sb = new StringBuilder();
        for (IStreamViewMapping mapping : viewMap.getEntryList()) {
            IStreamViewMapping.PathType type = mapping.getPathType();
            String lhs = mapping.getViewPath();
            String rhs = mapping.getDepotPath();
            sb.append(String.valueOf(type == null ? "" : String.valueOf(type.toString()) + DELIMITER) + (lhs == null ? "" : String.valueOf(lhs) + DELIMITER) + (rhs == null ? "" : rhs) + "\n");
        }
        return sb.toString();
    }

    public static String makeStreamAbsolute(String streamRoot) {
        Assert.isNotNull((Object)streamRoot);
        StringBuilder sb = new StringBuilder();
        if (!streamRoot.startsWith("//")) {
            sb.append("//");
        }
        sb.append(streamRoot);
        if (!streamRoot.endsWith("/")) {
            sb.append("/");
        }
        return sb.toString();
    }

    public static ViewMap<IStreamViewMapping> parseStreamViewMapping(String lines) {
        ViewMap streamView = new ViewMap();
        if (lines != null) {
            String[] viewPaths = lines.split(SystemUtils.LINE_SEPARATOR);
            int i = 0;
            while (i < viewPaths.length) {
                Stream.StreamViewMapping entry;
                String mapping = viewPaths[i];
                if (mapping == null) {
                    throw new NullPointerError("null view mapping string passed to Stream.newStream");
                }
                if (-1 == mapping.indexOf(DELIMITER)) {
                    mapping = String.valueOf(mapping) + DELIMITER;
                }
                if ((entry = new Stream.StreamViewMapping(i, mapping)).getPathType() == null) {
                    entry.setPathType(IStreamViewMapping.PathType.SHARE);
                }
                streamView.addEntry((IMapEntry)entry);
                ++i;
            }
        }
        return streamView;
    }

    public static ViewMap<IStreamRemappedMapping> parseRemappedMapping(String lines) {
        ViewMap remappedView = new ViewMap();
        if (lines != null) {
            String[] remappedPaths = lines.split(SystemUtils.LINE_SEPARATOR);
            int i = 0;
            while (i < remappedPaths.length) {
                String mapping = remappedPaths[i];
                if (mapping == null) {
                    throw new NullPointerError("null remapped mapping string passed to Stream.newStream");
                }
                remappedView.addEntry((IMapEntry)new Stream.StreamRemappedMapping(i, mapping));
                ++i;
            }
        }
        return remappedView;
    }

    public static ViewMap<IStreamIgnoredMapping> parseIgnoredMapping(String lines) {
        String[] ignoredPaths;
        ViewMap ignoredMapping = new ViewMap();
        if (lines != null && (ignoredPaths = lines.split(SystemUtils.LINE_SEPARATOR)) != null) {
            int i = 0;
            while (i < ignoredPaths.length) {
                String mapping = ignoredPaths[i];
                if (mapping == null) {
                    throw new NullPointerError("null ignored path string passed to Stream.newStream");
                }
                ignoredMapping.addEntry((IMapEntry)new Stream.StreamIgnoredMapping(i, mapping));
                ++i;
            }
        }
        return ignoredMapping;
    }

    public static boolean isParentEmpty(IStreamSummary stream) {
        String parent = stream.getParent();
        return StringUtils.isEmpty((CharSequence)parent) || parent.equals(DEFAULT_PARENT) || parent.equals("//none/");
    }

    public static boolean isStreamEmpty(IStreamSummary stream) {
        String s = stream.getStream();
        return StringUtils.isEmpty((CharSequence)s) || s.equals(DEFAULT_PARENT) || s.equals("//none/");
    }

    public static String getDepotName(IStreamSummary sum) {
        String path = sum.getStream();
        if (StringUtils.isEmpty((CharSequence)path)) {
            return "";
        }
        Assert.isTrue((boolean)path.startsWith("//"));
        String[] segments = path.substring(2).split("/");
        if (sum.getType() == IStreamSummary.Type.MAINLINE) {
            Assert.isTrue((segments != null && segments.length > 0 ? 1 : 0) != 0);
        } else {
            Assert.isTrue((segments != null && segments.length > 1 ? 1 : 0) != 0);
        }
        return segments[0];
    }

    public static String getDepot(IStreamSummary sum) {
        String path = sum.getStream();
        if (StringUtils.isEmpty((CharSequence)path)) {
            return "";
        }
        Assert.isTrue((boolean)path.startsWith("//"));
        String[] segments = path.substring(2).split("/");
        if (sum.getType() == IStreamSummary.Type.MAINLINE) {
            Assert.isTrue((segments != null && segments.length > 0 ? 1 : 0) != 0);
        } else {
            Assert.isTrue((segments != null && segments.length > 1 ? 1 : 0) != 0);
        }
        return "//" + segments[0];
    }

    public static String getParentDepot(IStreamSummary sum) {
        if (StreamUtil.isParentEmpty(sum)) {
            return StreamUtil.getDepot(sum);
        }
        String path = sum.getParent();
        if (StringUtils.isEmpty((CharSequence)path)) {
            return "";
        }
        Assert.isTrue((boolean)path.startsWith("//"));
        String[] segments = path.substring(2).split("/");
        Assert.isTrue((segments != null && segments.length > 0 ? 1 : 0) != 0);
        return "//" + segments[0];
    }

    public static String normalizePath(String streampath) {
        if (StringUtils.isEmpty((CharSequence)streampath)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int index = -1;
        int i = 0;
        while (i < streampath.length()) {
            if (streampath.charAt(i) != '/') {
                index = i;
                break;
            }
            ++i;
        }
        sb.append("//");
        if (index >= 0) {
            sb.append(streampath.substring(index));
        }
        if (sb.length() > 2 && streampath.endsWith("/")) {
            i = sb.length() - 1;
            while (i > 0) {
                if (sb.charAt(i) != '/') break;
                sb.deleteCharAt(i);
                --i;
            }
        }
        return sb.toString();
    }

    public static boolean isStreamPathFormat(String path) {
        String sub;
        String[] segments;
        if (StringUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        return path.startsWith("//") && (segments = (sub = path.substring(2)).split("/")).length == 2;
    }

    public static String getNormalizedPathSegment(String path, int index) {
        Assert.isTrue((boolean)StreamUtil.isStreamPathFormat(path));
        Assert.isTrue((index < 2 ? 1 : 0) != 0);
        return path.substring(2).split("/")[index];
    }

    public static String normalizeStreamPathForQuery(String parentStreamRoot) {
        return StreamUtil.normalizePath(parentStreamRoot);
    }

    public static IStream copyStream(IStream s) {
        Stream stream = new Stream();
        stream.setOwnerName(s.getOwnerName());
        stream.setDescription(s.getDescription());
        stream.setName(s.getName());
        stream.setStream(s.getStream());
        stream.setType(s.getType());
        stream.setParent(s.getParent());
        StreamSummary.Options streamOptions = new StreamSummary.Options();
        IStreamSummary.IOptions oldOptions = s.getOptions();
        if (oldOptions != null) {
            streamOptions = new StreamSummary.Options();
            streamOptions.setLocked(oldOptions.isLocked());
            streamOptions.setOwnerSubmit(oldOptions.isOwnerSubmit());
            streamOptions.setNoToParent(oldOptions.isNoToParent());
            streamOptions.setNoFromParent(oldOptions.isNoFromParent());
        }
        stream.setOptions((IStreamSummary.IOptions)streamOptions);
        ViewMap streamView = new ViewMap();
        ViewMap oldStreamView = s.getStreamView();
        if (oldStreamView != null) {
            int i = 0;
            while (i < oldStreamView.getSize()) {
                IStreamViewMapping entry = (IStreamViewMapping)oldStreamView.getEntry(i);
                Stream.StreamViewMapping newEntry = new Stream.StreamViewMapping(entry.getOrder(), entry.getPathType(), entry.getViewPath(), entry.getDepotPath());
                newEntry.setPathType(entry.getPathType());
                streamView.addEntry((IMapEntry)newEntry);
                ++i;
            }
        } else {
            streamView.addEntry((IMapEntry)new Stream.StreamViewMapping(0, IStreamViewMapping.PathType.SHARE, "...", null));
        }
        stream.setStreamView(streamView);
        ViewMap remappedView = new ViewMap();
        ViewMap oldRemappedView = s.getRemappedView();
        if (oldRemappedView != null) {
            int i = 0;
            while (i < oldRemappedView.getSize()) {
                IStreamRemappedMapping entry = (IStreamRemappedMapping)oldRemappedView.getEntry(i);
                Stream.StreamRemappedMapping newEntry = new Stream.StreamRemappedMapping(entry.getOrder(), entry.getLeftRemapPath(), entry.getRightRemapPath());
                remappedView.addEntry((IMapEntry)newEntry);
                ++i;
            }
        }
        stream.setRemappedView(remappedView);
        ViewMap ignoredMapping = new ViewMap();
        ViewMap oldIgnoredMapping = s.getIgnoredView();
        if (oldIgnoredMapping != null) {
            int i = 0;
            while (i < oldIgnoredMapping.getSize()) {
                IStreamIgnoredMapping entry = (IStreamIgnoredMapping)oldIgnoredMapping.getEntry(i);
                Stream.StreamIgnoredMapping newEntry = new Stream.StreamIgnoredMapping(entry.getOrder(), entry.getIgnorePath());
                ignoredMapping.addEntry((IMapEntry)newEntry);
                ++i;
            }
        }
        stream.setIgnoredView(ignoredMapping);
        return stream;
    }

    public static void updateStream(IStream src, IStream dst) {
        dst.setOwnerName(src.getOwnerName());
        dst.setDescription(src.getDescription());
        dst.setName(src.getName());
        dst.setStream(src.getStream());
        dst.setType(src.getType());
        dst.setParent(src.getParent());
        dst.setOptions(src.getOptions());
        dst.setStreamView(src.getStreamView());
        dst.setIgnoredView(src.getIgnoredView());
        dst.setRemappedView(src.getRemappedView());
    }

    public static IStream createDefaultStream(IP4Connection connection) {
        Stream stream = new Stream();
        stream.setOwnerName(connection.getUser());
        stream.setOptions((IStreamSummary.IOptions)new StreamSummary.Options());
        return stream;
    }

    public static IStream createNewStream(IP4Stream src) {
        Stream stream = new Stream();
        stream.setOptions((IStreamSummary.IOptions)new StreamSummary.Options());
        if (src != null) {
            stream.setOwnerName(src.getConnection().getUser());
            IStream parent = (IStream)src.getAdapter(IStream.class);
            stream.setParent(parent.getStream());
            if (parent.getType() == IStreamSummary.Type.MAINLINE) {
                stream.setType(IStreamSummary.Type.DEVELOPMENT);
            } else {
                stream.setType(parent.getType());
            }
        } else {
            stream.setType(IStreamSummary.Type.DEVELOPMENT);
        }
        if (stream.getType() == IStreamSummary.Type.DEVELOPMENT) {
            stream.getOptions().setNoFromParent(false);
            stream.getOptions().setNoToParent(false);
        } else if (stream.getType() == IStreamSummary.Type.TASK) {
            stream.getOptions().setNoFromParent(false);
            stream.getOptions().setNoToParent(false);
        } else if (stream.getType() == IStreamSummary.Type.RELEASE) {
            stream.getOptions().setNoFromParent(true);
            stream.getOptions().setNoToParent(false);
        } else if (stream.getType() == IStreamSummary.Type.MAINLINE) {
            stream.getOptions().setNoFromParent(true);
            stream.getOptions().setNoToParent(true);
        } else if (stream.getType() == IStreamSummary.Type.VIRTUAL) {
            stream.getOptions().setNoFromParent(true);
            stream.getOptions().setNoToParent(true);
        }
        return stream;
    }

    public static String getStreamRoot(IStreamSummary sum) {
        String path = sum.getStream();
        if (StringUtils.isEmpty((CharSequence)path)) {
            return "UnKnown";
        }
        Assert.isTrue((boolean)path.startsWith("//"));
        String[] segments = path.substring(2).split("/");
        Assert.isTrue((segments != null && segments.length > 1 ? 1 : 0) != 0);
        String root = segments[1];
        int index = root.indexOf("/");
        if (index > 0) {
            return root.substring(0, index);
        }
        return root;
    }

    public static String print(Object obj) {
        if (Platform.inDebugMode()) {
            String snapShot = ReflectionToStringBuilder.reflectionToString((Object)obj, (ToStringStyle)new P4LogUtils.RecursiveToStringStyle(-1));
            PerforceProviderPlugin.logInfo((String)snapShot);
            return snapShot;
        }
        return "";
    }

    public static void updateStreamDepot(IStream stream, String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            stream.setStream("//UnKnown/" + StreamUtil.getStreamRoot((IStreamSummary)stream));
            return;
        }
        if (StreamUtil.isStreamEmpty((IStreamSummary)stream)) {
            String name = stream.getName();
            name = !StringUtils.isEmpty((CharSequence)name) ? StreamUtil.escapeWhiteSpace(name) : "UnKnown";
            stream.setStream(String.valueOf(path) + "/" + name);
        } else {
            stream.setStream(String.valueOf(path) + "/" + StreamUtil.getStreamRoot((IStreamSummary)stream));
        }
    }

    public static void updateStream(IStream stream, String name, String depot) {
        name = !StringUtils.isEmpty((CharSequence)name) ? StreamUtil.escapeWhiteSpace(name) : "UnKnown";
        stream.setStream(String.valueOf(depot) + "/" + name);
    }

    public static void updateStreamName(IStream stream, String name, String depot) {
        name = !StringUtils.isEmpty((CharSequence)name) ? StreamUtil.escapeWhiteSpace(name) : "UnKnown";
        stream.setStream(String.valueOf(depot) + name);
    }

    public static String escapeWhiteSpace(String src) {
        return src.replace(' ', '_');
    }

    public static IStream getStream(IP4Connection connection) {
        IP4Stream p4stream = connection.getStream(connection.getClient().getStream());
        if (p4stream != null) {
            IStream stream = (IStream)p4stream.getAdapter(IStream.class);
            return stream;
        }
        return null;
    }

    public static IStreamSummary getParentStream(IStreamSummary stream, IP4Connection connection) {
        IStreamSummary parentStream = null;
        if (!StreamUtil.isParentEmpty(stream)) {
            parentStream = connection.getStreamSummary(stream.getParent());
        }
        return parentStream;
    }

    public static boolean isFirmerThanParent(IStreamSummary stream) {
        return stream.getType() == IStreamSummary.Type.RELEASE;
    }

    public static boolean isSofterThanParent(IStreamSummary stream) {
        return stream.getType() == IStreamSummary.Type.DEVELOPMENT;
    }

    public static String convertToJavaRegex(String filter) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < filter.length()) {
            if (filter.charAt(i) == '*') {
                if (i == 0) {
                    sb.append(".");
                } else if (filter.charAt(i - 1) != '.') {
                    sb.append(".");
                }
            }
            sb.append(filter.charAt(i));
            ++i;
        }
        return sb.toString();
    }

    public static List<IStreamSummary> getChildStream(IStream parent, IP4Connection connection) {
        ArrayList<IStreamSummary> list = new ArrayList<IStreamSummary>();
        List streams = connection.getFilteredStreams(false, null, "Parent=" + parent.getStream(), 0);
        for (IP4Stream s : streams) {
            list.add(s.getStreamSummary());
        }
        return list;
    }

    public static List<IStreamSummary> getPreferredCopySources(IStream stream, IP4Connection connection) {
        ArrayList<IStreamSummary> preferredStreams = new ArrayList<IStreamSummary>();
        if (stream != null) {
            if (stream.getType() == IStreamSummary.Type.DEVELOPMENT || stream.getType() == IStreamSummary.Type.MAINLINE || stream.getType() == IStreamSummary.Type.VIRTUAL) {
                preferredStreams.addAll(StreamUtil.getChildrenCopyFrom(stream, connection));
            } else if (stream.getType() == IStreamSummary.Type.RELEASE) {
                preferredStreams.addAll(StreamUtil.getChildrenCopyFrom(stream, connection));
                IStreamSummary.IOptions opt = stream.getOptions();
                if (!opt.isNoFromParent()) {
                    IStreamSummary parent = StreamUtil.getParentStream((IStreamSummary)stream, connection);
                    preferredStreams.add(parent);
                }
            }
        }
        return preferredStreams;
    }

    private static List<IStreamSummary> getChildrenCopyFrom(IStream stream, IP4Connection connection) {
        ArrayList<IStreamSummary> list = new ArrayList<IStreamSummary>();
        List<IStreamSummary> children = StreamUtil.getChildStream(stream, connection);
        for (IStreamSummary c : children) {
            IStreamSummary.IOptions opt = c.getOptions();
            if (StreamUtil.isFirmerThanParent(c) || opt.isNoToParent()) continue;
            list.add(c);
        }
        return list;
    }

    public static List<IStreamSummary> getPreferredMergeSources(IStream stream, IP4Connection connection) {
        ArrayList<IStreamSummary> preferredStreams = new ArrayList<IStreamSummary>();
        if (stream != null) {
            if (stream.getType() == IStreamSummary.Type.RELEASE || stream.getType() == IStreamSummary.Type.MAINLINE || stream.getType() == IStreamSummary.Type.VIRTUAL) {
                preferredStreams.addAll(StreamUtil.getChildrenMergeFrom(stream, connection));
            } else if (stream.getType() == IStreamSummary.Type.DEVELOPMENT || stream.getType() == IStreamSummary.Type.TASK) {
                preferredStreams.addAll(StreamUtil.getChildrenMergeFrom(stream, connection));
                IStreamSummary.IOptions opt = stream.getOptions();
                if (!opt.isNoFromParent()) {
                    IStreamSummary parent = StreamUtil.getParentStream((IStreamSummary)stream, connection);
                    preferredStreams.add(parent);
                }
            }
        }
        return preferredStreams;
    }

    private static List<IStreamSummary> getChildrenMergeFrom(IStream target, IP4Connection connection) {
        ArrayList<IStreamSummary> list = new ArrayList<IStreamSummary>();
        List<IStreamSummary> children = StreamUtil.getChildStream(target, connection);
        for (IStreamSummary c : children) {
            IStreamSummary.IOptions opt = c.getOptions();
            if (!StreamUtil.isFirmerThanParent(c) || opt.isNoToParent()) continue;
            list.add(c);
        }
        return list;
    }

    public static boolean isValidStreamFormat(IStream stream) {
        String s;
        if (!StreamUtil.isStreamEmpty((IStreamSummary)stream) && (s = stream.getStream()).startsWith("//")) {
            int count = 0;
            int index = -1;
            int i = 2;
            while (i < s.length()) {
                if (s.charAt(i) == '/') {
                    ++count;
                    index = i;
                }
                ++i;
            }
            if (count >= 1 && index != s.length() - 1) {
                return true;
            }
        }
        return false;
    }

    public static IStreamSummary matchStream(String id, List<IStreamSummary> list) {
        for (IStreamSummary sum : list) {
            if (sum == null || !id.equals(sum.getStream())) continue;
            return sum;
        }
        return null;
    }

    public static String getStreamDisplayText(IStreamSummary sum) {
        int show = PerforceUIPlugin.getPlugin().getPreferenceStore().getInt("pref_display_stream_name_root");
        switch (show) {
            case 1: {
                return sum.getName();
            }
            case 2: {
                return sum.getStream();
            }
        }
        return String.valueOf(sum.getName()) + DELIMITER + "(" + sum.getStream() + ")";
    }

    public static IStream.IExtraTag getExtraTag(IStream stream, String name) {
        List extraTags = stream.getExtraTags();
        for (IStream.IExtraTag tag : extraTags) {
            if (!tag.getName().equals(name)) continue;
            return tag;
        }
        return null;
    }

    public static String getBaseParent(IStreamSummary stream) {
        IStream.IExtraTag tag;
        if (stream instanceof IStream && (tag = StreamUtil.getExtraTag((IStream)stream, EXTRA_TAG_BASEPARENT)) != null && !EXTRA_TAG_UNKNOW_VALUE.equals(tag.getValue())) {
            return tag.getValue();
        }
        return stream.getParent();
    }

    public static IStream getBaseParent(IStreamSummary sum, IP4Connection connection) {
        try {
            IStream s = null;
            s = sum instanceof IStream ? (IStream)sum : (IStream)connection.getStreamSummary(sum.getStream());
            IStream.IExtraTag tag = StreamUtil.getExtraTag(s, EXTRA_TAG_BASEPARENT);
            if (tag != null && !EXTRA_TAG_UNKNOW_VALUE.equals(tag.getValue())) {
                return StreamUtil.getBaseParent(connection.getStreamSummary(tag.getValue()), connection);
            }
            return (IStream)connection.getStreamSummary(s.getParent());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static IStreamSummary findStreamSummary(IP4Connection conn, String stream) {
        IP4Resource[] iP4ResourceArray = conn.members();
        int n = iP4ResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            List streams;
            IP4Resource r = iP4ResourceArray[n2];
            if (r instanceof P4Depot && (streams = ((P4Depot)r).getStreams()) != null && !streams.isEmpty()) {
                for (IStreamSummary s : streams) {
                    if (!stream.equals(s.getStream())) continue;
                    return s;
                }
            }
            ++n2;
        }
        return null;
    }

    public static String[] parseStream(String stream) {
        if (stream.startsWith("//")) {
            stream = stream.substring(2);
        }
        if (stream.endsWith("/")) {
            stream = stream.substring(0, stream.length() - 1);
        }
        return stream.split("/");
    }
}

