/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.shelve;

import com.perforce.p4java.core.IChangelist;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Listener;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4ShelveFile;
import com.perforce.team.core.p4java.IP4ShelvedChangelist;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.core.p4java.P4ShelvedChangelist;
import com.perforce.team.core.p4java.P4Workspace;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.changelists.OpenChangelistDialog;
import com.perforce.team.ui.p4java.actions.ViewChangelistAction;
import com.perforce.team.ui.shelve.Messages;
import com.perforce.team.ui.shelve.OpenEditorAction;
import com.perforce.team.ui.shelve.ShelveTable;
import com.perforce.team.ui.views.IPerforceView;
import com.perforce.team.ui.views.PendingDragAdapter;
import com.perforce.team.ui.views.PerforceFilterViewControl;
import com.perforce.team.ui.views.PerforceProjectView;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.progress.UIJob;

public class ShelveViewControl
extends PerforceFilterViewControl
implements IPropertyChangeListener {
    public static final String DISPLAY_DETAILS = "com.perforce.team.ui.shelve.display_details";
    public static final String HIDE_FILTERS = "com.perforce.team.ui.shelve.HIDE_FILTERS";
    private ShelveTable table;
    private IP4Listener resourceListener = new IP4Listener(){

        public void resoureChanged(final P4Event event) {
            if (event.getType() == P4Event.EventType.DELETE_SHELVE || event.getType() == P4Event.EventType.SUBMIT_SHELVEDCHANGELIST || event.getType() == P4Event.EventType.CREATE_SHELVE || event.getType() == P4Event.EventType.UPDATE_SHELVE) {
                List<IP4ShelvedChangelist> list = new ArrayList();
                if (event.getType() == P4Event.EventType.SUBMIT_SHELVEDCHANGELIST) {
                    IP4Resource[] iP4ResourceArray = event.getResources();
                    int n = iP4ResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IP4Resource r = iP4ResourceArray[n2];
                        if (r instanceof IP4ShelvedChangelist) {
                            list.add((IP4ShelvedChangelist)r);
                        }
                        ++n2;
                    }
                } else {
                    list = ShelveViewControl.this.getAffectedLists(event.getPending());
                }
                final IP4ShelvedChangelist[] shelved = list.toArray(new IP4ShelvedChangelist[list.size()]);
                if (shelved.length > 0) {
                    UIJob job = new UIJob(Messages.ShelveView_UpdateShelvedChangesView){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            Composite control = ShelveViewControl.this.table.getControl();
                            if (control != null && !control.isDisposed()) {
                                switch (event.getType()) {
                                    case DELETE_SHELVE: 
                                    case SUBMIT_SHELVEDCHANGELIST: {
                                        ShelveViewControl.this.handleDelete(shelved);
                                        break;
                                    }
                                    case CREATE_SHELVE: {
                                        ShelveViewControl.this.handleCreate(shelved);
                                        break;
                                    }
                                    case UPDATE_SHELVE: {
                                        ShelveViewControl.this.handleUpdate(shelved);
                                        break;
                                    }
                                }
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                }
            }
        }

        public String getName() {
            return ShelveViewControl.this.getClass().getSimpleName();
        }
    };
    private Action showDetailsAction;
    private Action refreshAction;
    private Action openAction;
    private Action prefsAction;
    private Action openByIdAction;

    public ShelveViewControl(IPerforceView view) {
        super(view);
    }

    private List<IP4ShelvedChangelist> getAffectedLists(IP4PendingChangelist[] pendings) {
        ArrayList<IP4ShelvedChangelist> shelved = new ArrayList<IP4ShelvedChangelist>();
        IP4PendingChangelist[] iP4PendingChangelistArray = pendings;
        int n = pendings.length;
        int n2 = 0;
        while (n2 < n) {
            IP4PendingChangelist list = iP4PendingChangelistArray[n2];
            IChangelist cList = list.getChangelist();
            IP4Connection connection = list.getConnection();
            if (cList != null && connection != null) {
                shelved.add((IP4ShelvedChangelist)new P4ShelvedChangelist(connection, cList, list.isReadOnly()));
            }
            ++n2;
        }
        return shelved;
    }

    private void handleCreate(IP4ShelvedChangelist[] lists) {
        IP4ShelvedChangelist[] iP4ShelvedChangelistArray = lists;
        int n = lists.length;
        int n2 = 0;
        while (n2 < n) {
            IP4ShelvedChangelist list = iP4ShelvedChangelistArray[n2];
            this.table.addShelvedChangelist(list);
            ++n2;
        }
    }

    private void handleDelete(IP4ShelvedChangelist[] lists) {
        this.table.removeShelvedChangelist(lists);
    }

    private void handleUpdate(IP4ShelvedChangelist[] lists) {
        IP4ShelvedChangelist[] iP4ShelvedChangelistArray = lists;
        int n = lists.length;
        int n2 = 0;
        while (n2 < n) {
            IP4ShelvedChangelist list = iP4ShelvedChangelistArray[n2];
            this.table.refreshShelvedChangelist(list);
            ++n2;
        }
    }

    private void createActions() {
        final PerforceUIPlugin plugin = PerforceUIPlugin.getPlugin();
        this.showDetailsAction = new Action(Messages.ShelveView_ShowChangelistDetails){

            public int getStyle() {
                return 2;
            }
        };
        this.showDetailsAction.setChecked(plugin.getPreferenceStore().getBoolean(DISPLAY_DETAILS));
        this.showDetailsAction.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                plugin.getPreferenceStore().setValue(ShelveViewControl.DISPLAY_DETAILS, ShelveViewControl.this.showDetailsAction.isChecked());
                ShelveViewControl.this.table.showDisplayDetails(ShelveViewControl.this.showDetailsAction.isChecked());
            }
        });
        this.table.showDisplayDetails(this.showDetailsAction.isChecked());
        this.refreshAction = new Action(Messages.ShelveView_Refresh, plugin.getImageDescriptor("normal/refresh.png")){

            public void run() {
                if (ShelveViewControl.this.table != null) {
                    ShelveViewControl.this.table.refresh();
                }
            }
        };
        this.openAction = new Action(Messages.ShelveView_OpenInEditor){

            public void run() {
                IP4ShelveFile file = ShelveViewControl.this.getSelectedShelveFile();
                if (file != null) {
                    OpenEditorAction open = new OpenEditorAction();
                    open.selectionChanged(null, (ISelection)new StructuredSelection((Object)file));
                    open.run(null);
                }
            }
        };
        this.prefsAction = new Action(Messages.ShelveView_OpenPreferences, plugin.getImageDescriptor("views/preferences.png")){

            public void run() {
                P4UIUtils.openPreferencePage("com.perforce.team.ui.shelve.ShelvePreferencePage");
            }
        };
        this.prefsAction.setToolTipText(Messages.ShelveView_OpenPreferencePage);
        this.openByIdAction = new Action(Messages.ShelveView_OpenChangelist, PerforceUIPlugin.getDescriptor("perforce/shelved_editor.png")){

            public void run() {
                int id;
                if (ShelveViewControl.this.p4Connection == null) {
                    return;
                }
                OpenChangelistDialog dialog = new OpenChangelistDialog(ShelveViewControl.this.displayArea.getShell(), Messages.ShelveView_OpenShelvedChangelist);
                if (dialog.open() == 0 && (id = dialog.getId()) > 0) {
                    ViewChangelistAction action = new ViewChangelistAction();
                    action.view(id, ShelveViewControl.this.p4Connection, IChangelist.Type.SHELVED);
                }
            }
        };
        TreeViewer viewer = this.table.getViewer();
        MenuManager manager = new MenuManager();
        Menu menu = manager.createContextMenu(viewer.getControl());
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)ShelveViewControl.this.refreshAction);
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        manager.setRemoveAllWhenShown(true);
        viewer.getControl().setMenu(menu);
        this.registerContextMenu(manager, (ISelectionProvider)viewer);
        IActionBars bars = this.getActionBars();
        if (bars != null) {
            IToolBarManager tbm = bars.getToolBarManager();
            tbm.add((IAction)this.refreshAction);
            tbm.add((IAction)this.openByIdAction);
            tbm.add((IAction)this.prefsAction);
            tbm.update(false);
            IMenuManager pulldown = bars.getMenuManager();
            pulldown.add((IAction)this.showDetailsAction);
            this.createFilterAction((IContributionManager)pulldown);
            pulldown.update(false);
        }
    }

    @Override
    public void setFocus() {
        this.table.getControl().setFocus();
    }

    @Override
    public void dispose() {
        this.removeProjectListeners();
        P4Workspace.getWorkspace().removeListener(this.resourceListener);
        PerforceUIPlugin.getPlugin().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    @Override
    public void refresh() {
    }

    @Override
    protected String getFilterPreference() {
        return HIDE_FILTERS;
    }

    @Override
    protected String getSelectedName() {
        return Messages.ShelveView_ShelvedChangelists;
    }

    @Override
    protected void createControl(Composite parent) {
        this.table = new ShelveTable(PerforceProjectView.getItems("com.perforce.team.ui.shelve.FILE_FOLDER_HISTORY"), PerforceProjectView.getItems("com.perforce.team.ui.shelve.USER_HISTORY"), PerforceProjectView.getItems("com.perforce.team.ui.shelve.WORKSPACE_HISTORY"));
        this.setFilterViewer(this.table);
        this.table.createPartControl(parent);
        this.table.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object resource = ShelveViewControl.this.getSingleObjectSelection();
                if (resource instanceof IP4ShelveFile) {
                    ShelveViewControl.this.openAction.run();
                } else if (resource instanceof IP4ShelvedChangelist) {
                    ViewChangelistAction view = new ViewChangelistAction();
                    view.selectionChanged(null, (ISelection)new StructuredSelection(resource));
                    view.run(null);
                }
            }
        });
        this.table.getViewer().addDragSupport(19, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new PendingDragAdapter((ISelectionProvider)this.table.getViewer()));
        this.createActions();
        this.addProjectListeners();
        P4Workspace.getWorkspace().addListener(this.resourceListener);
        PerforceUIPlugin.getPlugin().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    private Object getSingleObjectSelection() {
        Object selected = null;
        IStructuredSelection selection = (IStructuredSelection)this.table.getViewer().getSelection();
        if (selection.size() == 1) {
            selected = selection.getFirstElement();
        }
        return selected;
    }

    private IP4ShelveFile getSelectedShelveFile() {
        Object file = this.getSingleObjectSelection();
        return file instanceof IP4ShelveFile ? (IP4ShelveFile)file : null;
    }

    @Override
    protected void setViewerInput(IP4Connection connection) {
        if (this.connectionOK(connection)) {
            this.table.showChangelists((IP4Resource)connection);
            this.showDisplayArea();
        } else {
            this.showNoConnection();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property == "com.perforce.team.ui.preferences.NUM_SHELVES_RETRIEVE" && this.table != null) {
            this.table.updateMoreLink();
        }
    }

    public boolean isLoading() {
        return this.table != null && this.table.isLoading();
    }

    public ShelveTable getTabel() {
        return this.table;
    }
}

