/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.shelve;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Container;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.p4java.actions.AsyncEnablementAction;
import com.perforce.team.ui.shelve.ConfirmShelveDialog;
import com.perforce.team.ui.shelve.Messages;
import com.perforce.team.ui.shelve.ShelveFileDialog;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;

public class ShelveAction
extends AsyncEnablementAction {
    public static void showNotSupported(final IP4Connection connection) {
        if (connection != null) {
            PerforceUIPlugin.syncExec(new Runnable(){

                @Override
                public void run() {
                    P4ConnectionManager.getManager().openInformation(P4UIUtils.getDialogShell(), Messages.ShelveAction_NoShelvingTitle, MessageFormat.format(Messages.ShelveAction_NoShelvingMessage, connection.getParameters().getPort()));
                }
            });
        }
    }

    @Override
    protected boolean isEnabledEx() throws TeamException {
        boolean enabled = this.containsOnlineConnection();
        if (enabled) {
            enabled = false;
            P4Collection collection = this.getResourceSelection();
            IP4Resource[] iP4ResourceArray = collection.members();
            int n = iP4ResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IP4File file;
                IP4Resource resource = iP4ResourceArray[n2];
                if (resource instanceof IP4Container ? (enabled = resource.getConnection().isShelvingSupported()) : resource instanceof IP4File && (file = (IP4File)resource).isOpened() && (enabled = file.getConnection().isShelvingSupported())) break;
                ++n2;
            }
        }
        return enabled;
    }

    @Override
    protected void runAction() {
        P4Runnable runnable = new P4Runnable(){

            public void run(IProgressMonitor monitor) {
                P4Collection collection = ShelveAction.this.getFileSelection();
                HashMap<IP4PendingChangelist, P4Collection> listMappings = new HashMap<IP4PendingChangelist, P4Collection>();
                IP4Resource[] iP4ResourceArray = collection.members();
                int n = iP4ResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IP4PendingChangelist list;
                    IP4File file;
                    IP4Resource resource = iP4ResourceArray[n2];
                    if (resource instanceof IP4File && (file = (IP4File)resource).isOpened() && (list = file.getChangelist(true)) != null) {
                        P4Collection fileCollection;
                        if (list.needsRefresh()) {
                            list.refresh();
                        }
                        if ((fileCollection = (P4Collection)listMappings.get(list)) == null) {
                            fileCollection = ShelveAction.this.createCollection();
                            listMappings.put(list, fileCollection);
                        }
                        fileCollection.add((IP4Resource)file);
                    }
                    ++n2;
                }
                if (!listMappings.isEmpty()) {
                    for (Map.Entry entry : listMappings.entrySet()) {
                        IP4PendingChangelist list = (IP4PendingChangelist)entry.getKey();
                        P4Collection files = (P4Collection)entry.getValue();
                        if (list.getConnection().isShelvingSupported()) {
                            if (!list.isDefault()) {
                                ShelveAction.this.showShelveDialog(list, files.members());
                                continue;
                            }
                            ShelveAction.this.showDialog(list, files);
                            continue;
                        }
                        ShelveAction.showNotSupported(list.getConnection());
                    }
                } else {
                    ShelveAction.this.showNoOpenedFilesDialog();
                }
            }

            public String getTitle() {
                return Messages.ShelveAction_ShelvingFiles;
            }
        };
        this.runRunnable((IP4Runnable)runnable);
    }

    private void showNoOpenedFilesDialog() {
        PerforceUIPlugin.syncExec(new Runnable(){

            @Override
            public void run() {
                P4ConnectionManager.getManager().openInformation(P4UIUtils.getDialogShell(), Messages.ShelveAction_NoFilesToShelveTitle, Messages.ShelveAction_NoFilesToShelveMessage);
            }
        });
    }

    private void shelveNew(final IP4PendingChangelist list, final IP4File[] files, final boolean newChangelist, final String initialDescription, final boolean revert, final boolean wipe) {
        P4Runnable runnable = new P4Runnable(){

            public void run(IProgressMonitor monitor) {
                int work = 1;
                if (newChangelist) {
                    work += 2;
                }
                monitor.beginTask(ShelveAction.this.generateTitle(Messages.ShelveAction_Shelving, (IP4Resource[])files, IP4Resource.Type.REMOTE), work);
                IP4PendingChangelist pending = null;
                if (newChangelist) {
                    monitor.subTask(Messages.ShelveAction_CreatingNewChangelist);
                    String description = initialDescription;
                    if (description == null) {
                        description = Messages.ShelveAction_NewShelveChangelistDescription;
                    }
                    pending = list.getConnection().createChangelist(description, null);
                    monitor.worked(1);
                    if (pending != null) {
                        monitor.subTask(MessageFormat.format(Messages.ShelveAction_ReopeningFilesInNewChangelist, pending.getId()));
                        ShelveAction.this.createCollection((IP4Resource[])files).reopen(pending);
                    }
                    monitor.worked(1);
                } else {
                    pending = list;
                }
                if (pending != null) {
                    pending.shelve(files);
                    monitor.worked(1);
                }
                if (revert) {
                    P4Collection revertSelection = ShelveAction.this.createCollection((IP4Resource[])files);
                    revertSelection.revert(wipe);
                    monitor.worked(1);
                    revertSelection.refreshLocalResources(2);
                    revertSelection.resetStateValidation();
                    ShelveAction.this.updateActionState();
                }
                monitor.done();
            }

            public String getTitle() {
                return Messages.ShelveAction_ShelvingFiles;
            }
        };
        this.runRunnable((IP4Runnable)runnable);
    }

    private void shelveUpdate(final IP4PendingChangelist pending, final IP4Resource[] files) {
        P4Runnable runnable = new P4Runnable(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask(ShelveAction.this.generateTitle(Messages.ShelveAction_Shelving, files, IP4Resource.Type.REMOTE), 1);
                if (pending != null) {
                    pending.updateShelvedFiles(files);
                    monitor.worked(1);
                }
                monitor.done();
            }

            public String getTitle() {
                return Messages.ShelveAction_ShelvingFiles;
            }
        };
        this.runRunnable((IP4Runnable)runnable);
    }

    private void showShelveDialog(final IP4PendingChangelist list, final IP4Resource[] selected) {
        PerforceUIPlugin.syncExec(new Runnable(){

            @Override
            public void run() {
                IP4Resource[] selection;
                ShelveFileDialog dialog = new ShelveFileDialog(P4UIUtils.getDialogShell(), list, list.members(), selected);
                if (dialog.open() == 0 && (selection = dialog.getSelectedFiles()).length > 0) {
                    ShelveAction.this.shelveUpdate(list, selection);
                }
            }
        });
    }

    private void showDialog(final IP4PendingChangelist list, P4Collection files) {
        IP4Resource[] members = files.members();
        final IP4File[] fileMembers = new IP4File[members.length];
        System.arraycopy(members, 0, fileMembers, 0, fileMembers.length);
        PerforceUIPlugin.syncExec(new Runnable(){

            @Override
            public void run() {
                IP4File[] selection;
                ConfirmShelveDialog dialog = new ConfirmShelveDialog(P4UIUtils.getDialogShell(), list, fileMembers);
                if (dialog.open() == 0 && (selection = dialog.getSelectedFiles()).length > 0) {
                    String description = dialog.getDescription();
                    boolean revert = dialog.isRevertChecked();
                    boolean wipe = dialog.isRemoveChecked();
                    ShelveAction.this.shelveNew(list, selection, true, description, revert, wipe);
                }
            }
        });
    }
}

